/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.apitokens.graphql;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.api.usermanager.JahiaUserManagerService;
import org.jahia.modules.apitokens.TokenDetails;
import org.jahia.modules.apitokens.TokenService;
import org.jahia.modules.apitokens.graphql.TokenState;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.security.GraphQLRequiresPermission;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRTemplate;
import org.joda.time.DateTime;

@GraphQLName(value="PersonalApiTokensMutation")
@GraphQLDescription(value="Mutations for Personal Api Tokens")
public class GqlPersonalApiTokensMutation {
    @Inject
    @GraphQLOsgiService
    private TokenService tokensService;
    @Inject
    @GraphQLOsgiService
    private JCRTemplate jcrTemplate;
    @Inject
    @GraphQLOsgiService
    private JahiaUserManagerService userManagerService;

    @GraphQLField
    @GraphQLDescription(value="Create a new token")
    @GraphQLRequiresPermission(value="personal-api-tokens")
    public String createToken(@GraphQLName(value="name") @GraphQLDescription(value="Name to give to the token") @GraphQLNonNull String name, @GraphQLName(value="site") @GraphQLDescription(value="The site the user belongs to, null if global user") String site, @GraphQLName(value="expireAt") @GraphQLDescription(value="Expiration date of the token") String expireAt, @GraphQLName(value="scopes") @GraphQLDescription(value="Scopes attached to this token") List<String> scopes, @GraphQLName(value="state") @GraphQLDescription(value="State to give the newly created token") TokenState state) {
        String path = this.jcrTemplate.getSessionFactory().getCurrentUser().getLocalPath();
        try {
            return (String)this.jcrTemplate.doExecute(this.jcrTemplate.getSessionFactory().getCurrentUser(), null, null, session -> {
                Calendar expiration = expireAt != null ? new DateTime((Object)expireAt).toCalendar(Locale.getDefault()) : null;
                String token = this.tokensService.tokenBuilder(path, JCRContentUtils.escapeLocalNodeName((String)name), session).setExpirationDate(expiration).setActive(state != TokenState.DISABLED).setScopes(scopes).create();
                session.save();
                return token;
            });
        }
        catch (Exception e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Update an existing token")
    public boolean updateToken(@GraphQLName(value="key") @GraphQLDescription(value="The token key") @GraphQLNonNull String key, @GraphQLName(value="name") @GraphQLDescription(value="Name to give to the token") String name, @GraphQLName(value="expireAt") @GraphQLDescription(value="Expiration date of the token, use empty string to unset expiration date") String expireAt, @GraphQLName(value="scopes") @GraphQLDescription(value="Scopes attached to this token") List<String> scopes, @GraphQLName(value="state") @GraphQLDescription(value="State to give the token") TokenState state) {
        try {
            return (Boolean)this.jcrTemplate.doExecute(this.jcrTemplate.getSessionFactory().getCurrentUser(), null, null, session -> {
                TokenDetails details = this.tokensService.getTokenDetails(key, session);
                if (details == null) {
                    return false;
                }
                if (name != null) {
                    details.setName(name);
                }
                if (expireAt != null) {
                    if (StringUtils.isEmpty((String)expireAt)) {
                        details.setExpirationDate(null);
                    } else {
                        details.setExpirationDate(new DateTime((Object)expireAt).toCalendar(Locale.getDefault()));
                    }
                }
                if (state != null) {
                    details.setActive(state != TokenState.DISABLED);
                }
                if (scopes != null) {
                    details.setScopes(scopes);
                }
                boolean updateToken = this.tokensService.updateToken(details, session);
                session.save();
                return updateToken;
            });
        }
        catch (RepositoryException e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Delete an existing token")
    public boolean deleteToken(@GraphQLName(value="key") @GraphQLDescription(value="The token key") @GraphQLNonNull String key) {
        try {
            return (Boolean)this.jcrTemplate.doExecute(this.jcrTemplate.getSessionFactory().getCurrentUser(), null, null, session -> {
                boolean deleteToken = this.tokensService.deleteToken(key, session);
                session.save();
                return deleteToken;
            });
        }
        catch (RepositoryException e) {
            throw new DataFetchingException((Throwable)e);
        }
    }
}

