/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.rolesmanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.modules.rolesmanager.I18nRoleProperties;
import org.jahia.modules.rolesmanager.NodeType;
import org.jahia.modules.rolesmanager.PermissionBean;
import org.jahia.modules.rolesmanager.RoleBean;
import org.jahia.modules.rolesmanager.RoleType;
import org.jahia.modules.rolesmanager.RoleTypeConfiguration;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.context.i18n.LocaleContextHolder;

public class RolesAndPermissionsHandler
implements Serializable {
    private static final long serialVersionUID = 7910715831938629654L;
    private static Logger logger = LoggerFactory.getLogger(RolesAndPermissionsHandler.class);
    @Autowired
    private transient RoleTypeConfiguration roleTypes;
    @Autowired
    private transient JahiaTemplateManagerService templateManagerService;
    private RoleBean roleBean = new RoleBean();
    private String currentContext;
    private String currentGroup;
    private List<String> uuids;
    private transient List<JCRNodeWrapper> allPermissions;

    public RoleTypeConfiguration getRoleTypes() {
        return this.roleTypes;
    }

    public RoleBean getRoleBean() {
        return this.roleBean;
    }

    public void setRoleBean(RoleBean roleBean) {
        this.roleBean = roleBean;
        this.currentContext = "current";
        this.currentGroup = roleBean.getPermissions() != null ? roleBean.getPermissions().get(this.currentContext).keySet().iterator().next() : null;
    }

    private JCRSessionWrapper getSession() throws RepositoryException {
        return this.getSession(LocaleContextHolder.getLocale());
    }

    private JCRSessionWrapper getSession(Locale locale) throws RepositoryException {
        return JCRSessionFactory.getInstance().getCurrentUserSession("default", locale);
    }

    public Map<String, List<RoleBean>> getRoles() throws RepositoryException {
        return this.getRoles(false, false);
    }

    public Map<String, List<RoleBean>> getRolesToDelete() throws RepositoryException {
        return this.getRoles(true, true);
    }

    public Map<String, List<RoleBean>> getSelectedRoles() throws RepositoryException {
        return this.getRoles(true, false);
    }

    public Map<String, List<RoleBean>> getRoles(boolean filterUUIDs, boolean getChildren) throws RepositoryException {
        QueryManagerWrapper qm = this.getSession().getWorkspace().getQueryManager();
        StringBuilder statement = new StringBuilder("select * from [jnt:role] as role");
        if (filterUUIDs) {
            statement.append(" where ");
            Iterator<String> it = this.uuids.iterator();
            while (it.hasNext()) {
                String uuid = it.next();
                statement.append("[jcr:uuid] = '").append(uuid).append("'");
                if (getChildren) {
                    statement.append(" or isdescendantnode(role, ['").append(this.getSession().getNodeByIdentifier(uuid).getPath()).append("'])");
                }
                if (!it.hasNext()) continue;
                statement.append(" or ");
            }
        }
        Query q = qm.createQuery(statement.toString(), "JCR-SQL2");
        LinkedHashMap<String, List<RoleBean>> all = new LinkedHashMap<String, List<RoleBean>>();
        if (!filterUUIDs) {
            for (RoleType roleType : this.roleTypes.getValues()) {
                all.put(roleType.getName(), new ArrayList());
            }
        }
        NodeIterator ni = q.execute().getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
            if (next.getName().equals("privileged")) continue;
            RoleBean role = this.createRoleBean(next, false, false);
            String key = role.getRoleType().getName();
            if (!all.containsKey(key)) {
                all.put(key, new ArrayList());
            }
            ((List)all.get(key)).add(role);
        }
        for (List roleBeans : all.values()) {
            Collections.sort(roleBeans, new Comparator<RoleBean>(){

                @Override
                public int compare(RoleBean o1, RoleBean o2) {
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
        }
        return all;
    }

    public RoleBean getRole(String uuid, boolean getPermissions) throws RepositoryException {
        JCRSessionWrapper currentUserSession = this.getSession();
        JCRNodeWrapper role = currentUserSession.getNodeByIdentifier(uuid);
        return this.createRoleBean(role, getPermissions, true);
    }

    public boolean copyRole(final String roleName, final String deepCopy, final String uuid, final MessageContext messageContext) throws RepositoryException {
        JCRSessionWrapper currentUserSession = this.getSession();
        boolean copy = (Boolean)JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(currentUserSession.getUser(), currentUserSession.getWorkspace().getName(), null, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                String newRoleName;
                JCRNodeWrapper roleToCopy = session.getNodeByIdentifier(uuid);
                String string = newRoleName = StringUtils.isNotEmpty((String)roleName) ? JCRContentUtils.generateNodeName((String)roleName) : roleName;
                if (!RolesAndPermissionsHandler.this.testRoleName(newRoleName, messageContext, session)) {
                    return false;
                }
                boolean copy = roleToCopy.copy(roleToCopy.getParent().getPath(), newRoleName);
                if (StringUtils.isEmpty((String)deepCopy)) {
                    JCRNodeWrapper copiedNode = session.getNode(roleToCopy.getParent().getPath() + "/" + newRoleName);
                    JCRNodeIteratorWrapper iterator = copiedNode.getNodes();
                    while (iterator.hasNext()) {
                        JCRNodeWrapper subNode = (JCRNodeWrapper)iterator.next();
                        if (!subNode.isNodeType("jnt:role")) continue;
                        subNode.remove();
                    }
                }
                session.save();
                return copy;
            }
        });
        if (copy) {
            messageContext.addMessage(new MessageBuilder().source((Object)"roleName").defaultText(this.getMessage("rolesmanager.rolesAndPermissions.successfullyCopied")).build());
        }
        return copy;
    }

    private RoleBean createRoleBean(JCRNodeWrapper role, boolean getPermissions, boolean getSubRoles) throws RepositoryException {
        RoleBean roleBean = new RoleBean();
        JCRNodeWrapper parentRole = JCRContentUtils.getParentOfType((JCRNodeWrapper)role, (String)"jnt:role");
        String uuid = role.getIdentifier();
        roleBean.setUuid(uuid);
        roleBean.setParentUuid(parentRole != null ? parentRole.getIdentifier() : null);
        roleBean.setName(role.getName());
        roleBean.setPath(role.getPath());
        roleBean.setDepth(role.getDepth());
        TreeMap<String, I18nRoleProperties> i18nRoleProperties = new TreeMap<String, I18nRoleProperties>();
        for (Locale l : role.getExistingLocales()) {
            JCRNodeWrapper n = this.getSession(l).getNodeByIdentifier(uuid);
            if (!n.hasProperty("jcr:title") && !n.hasProperty("jcr:description")) {
                i18nRoleProperties.put(l.getLanguage(), null);
                continue;
            }
            I18nRoleProperties properties = new I18nRoleProperties();
            properties.setLanguage(l.getDisplayName(LocaleContextHolder.getLocale()));
            if (n.hasProperty("jcr:title")) {
                properties.setTitle(n.getProperty("jcr:title").getString());
            }
            if (n.hasProperty("jcr:description")) {
                properties.setDescription(n.getProperty("jcr:description").getString());
            }
            i18nRoleProperties.put(l.getLanguage(), properties);
        }
        roleBean.setI18nProperties(i18nRoleProperties);
        if (role.hasProperty("j:hidden")) {
            roleBean.setHidden(role.getProperty("j:hidden").getBoolean());
        }
        String roleGroup = "edit-role";
        if (role.hasProperty("j:roleGroup")) {
            roleGroup = role.getProperty("j:roleGroup").getString();
        }
        RoleType roleType = this.roleTypes.get(roleGroup);
        roleBean.setRoleType(roleType);
        if (getPermissions) {
            ArrayList<String> tabs = new ArrayList<String>(roleBean.getRoleType().getScopes());
            HashMap<String, List<String>> permIdsMap = new HashMap<String, List<String>>();
            this.fillPermIds(role, tabs, permIdsMap, false);
            HashMap<String, List<String>> inheritedPermIdsMap = new HashMap<String, List<String>>();
            this.fillPermIds(role.getParent(), tabs, inheritedPermIdsMap, true);
            LinkedHashMap<String, Map<String, Map<String, PermissionBean>>> permsForRole = new LinkedHashMap<String, Map<String, Map<String, PermissionBean>>>();
            roleBean.setPermissions(permsForRole);
            for (String tab : tabs) {
                this.addPermissionsForScope(roleBean, tab, permIdsMap, inheritedPermIdsMap);
            }
            if (roleType.getAvailableNodeTypes() != null) {
                ArrayList<String> nodeTypesOnRole = new ArrayList<String>();
                if (role.hasProperty("j:nodeTypes")) {
                    for (JCRValueWrapper value : role.getProperty("j:nodeTypes").getValues()) {
                        nodeTypesOnRole.add(value.getString());
                    }
                }
                TreeSet<NodeType> nodeTypes = new TreeSet<NodeType>();
                for (String s : roleType.getAvailableNodeTypes()) {
                    boolean includeSubtypes = false;
                    if (s.endsWith("/*")) {
                        s = StringUtils.substringBeforeLast((String)s, (String)"/*");
                        includeSubtypes = true;
                    }
                    ExtendedNodeType t = NodeTypeRegistry.getInstance().getNodeType(s);
                    nodeTypes.add(new NodeType(t.getName(), t.getLabel(LocaleContextHolder.getLocale()), nodeTypesOnRole.contains(t.getName())));
                    if (!includeSubtypes) continue;
                    for (ExtendedNodeType sub : t.getSubtypesAsList()) {
                        nodeTypes.add(new NodeType(sub.getName(), sub.getLabel(LocaleContextHolder.getLocale()), nodeTypesOnRole.contains(sub.getName())));
                    }
                }
                roleBean.setNodeTypes(nodeTypes);
            }
        }
        if (getSubRoles) {
            List subRoles = JCRContentUtils.getNodes((JCRNodeWrapper)role, (String)"jnt:role");
            ArrayList<RoleBean> subRoleBeans = new ArrayList<RoleBean>(subRoles.size());
            for (JCRNodeWrapper subRole : subRoles) {
                subRoleBeans.add(this.createRoleBean(subRole, false, false));
            }
            roleBean.setSubRoles(subRoleBeans);
        }
        return roleBean;
    }

    public void revertRole() throws RepositoryException {
        this.roleBean = this.getRole(this.roleBean.getUuid(), true);
    }

    private void fillPermIds(JCRNodeWrapper role, List<String> tabs, Map<String, List<String>> permIdsMap, boolean recursive) throws RepositoryException {
        if (!role.isNodeType("jnt:role")) {
            return;
        }
        if (recursive) {
            this.fillPermIds(role.getParent(), tabs, permIdsMap, true);
        }
        ArrayList<String> setPermIds = new ArrayList<String>();
        permIdsMap.put("current", setPermIds);
        if (role.hasProperty("j:permissionNames")) {
            JCRValueWrapper[] values;
            for (JCRValueWrapper value : values = role.getProperty("j:permissionNames").getValues()) {
                String valueString = value.getString();
                if (setPermIds.contains(valueString)) continue;
                setPermIds.add(valueString);
            }
        }
        JCRNodeIteratorWrapper ni = role.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
            if (!next.isNodeType("jnt:externalPermissions")) continue;
            try {
                JCRValueWrapper[] values;
                String path = next.getProperty("j:path").getString();
                permIdsMap.put(path, new ArrayList());
                for (JCRValueWrapper value : values = next.getProperty("j:permissionNames").getValues()) {
                    String valueString;
                    List<String> ids = permIdsMap.get(path);
                    if (!ids.contains(valueString = value.getString())) {
                        ids.add(valueString);
                    }
                    if (tabs.contains(path)) continue;
                    tabs.add(path);
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot initialize role " + next.getPath(), (Throwable)e);
            }
            catch (IllegalStateException e) {
                logger.error("Cannot initialize role " + next.getPath(), (Throwable)e);
            }
        }
    }

    private boolean testRoleName(String roleName, MessageContext messageContext, JCRSessionWrapper currentUserSession) throws RepositoryException {
        if (StringUtils.isEmpty((String)roleName)) {
            messageContext.addMessage(new MessageBuilder().source((Object)"roleName").defaultText(this.getMessage("rolesmanager.rolesAndPermissions.role.noName")).error().build());
            return false;
        }
        JCRNodeIteratorWrapper nodes = currentUserSession.getWorkspace().getQueryManager().createQuery("select * from [jnt:role] as r where localname()='" + JCRContentUtils.sqlEncode((String)roleName) + "' and isdescendantnode(r,['/roles'])", "JCR-SQL2").execute().getNodes();
        if (nodes.hasNext()) {
            messageContext.addMessage(new MessageBuilder().source((Object)"roleName").defaultText(this.getMessage("rolesmanager.rolesAndPermissions.role.exists")).error().build());
            return false;
        }
        return true;
    }

    public boolean addRole(String roleName, String parentRoleId, String roleTypeString, MessageContext messageContext) throws RepositoryException {
        JCRSessionWrapper currentUserSession = this.getSession();
        String string = roleName = StringUtils.isNotEmpty((String)roleName) ? JCRContentUtils.generateNodeName((String)roleName) : roleName;
        if (!this.testRoleName(roleName, messageContext, currentUserSession)) {
            return false;
        }
        JCRNodeWrapper parent = StringUtils.isBlank((String)parentRoleId) ? currentUserSession.getNode("/roles") : currentUserSession.getNodeByIdentifier(parentRoleId);
        JCRNodeWrapper role = parent.addNode(roleName, "jnt:role");
        RoleType roleType = this.roleTypes.get(roleTypeString);
        role.setProperty("j:roleGroup", roleType.getName());
        role.setProperty("j:privilegedAccess", roleType.isPrivileged());
        if (roleType.getDefaultNodeTypes() != null) {
            ArrayList<Value> values = new ArrayList<Value>();
            for (String nodeType : roleType.getDefaultNodeTypes()) {
                values.add(currentUserSession.getValueFactory().createValue(nodeType));
            }
            role.setProperty("j:nodeTypes", values.toArray(new Value[values.size()]));
        }
        role.setProperty("j:roleGroup", roleType.getName());
        currentUserSession.save();
        this.setRoleBean(this.createRoleBean(role, true, false));
        return true;
    }

    public void selectRoles(String uuids) throws RepositoryException {
        this.uuids = Arrays.asList(uuids.split(","));
    }

    public boolean deleteRoles() throws RepositoryException {
        JCRSessionWrapper currentUserSession = this.getSession();
        for (String uuid : this.uuids) {
            try {
                currentUserSession.getNodeByIdentifier(uuid).remove();
            }
            catch (ItemNotFoundException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Cannot find role " + uuid);
            }
        }
        currentUserSession.save();
        return true;
    }

    private void addPermissionsForScope(RoleBean roleBean, String scope, Map<String, List<String>> permIdsMap, Map<String, List<String>> inheritedPermIdsMap) throws RepositoryException {
        PermissionBean bean;
        Map<String, PermissionBean> p;
        Map<String, Map<String, Map<String, PermissionBean>>> permissions = roleBean.getPermissions();
        if (!permissions.containsKey(scope)) {
            permissions.put(scope, new LinkedHashMap());
        }
        List<JCRNodeWrapper> allPermissions = this.getAllPermissions();
        String type = null;
        Map<String, List<String>> globalPermissionsGroups = this.roleTypes.getPermissionsGroups();
        Map<String, List<String>> permissionsGroupsForRoleType = roleBean.getRoleType().getPermissionsGroups();
        if (scope.equals("current")) {
            if (roleBean.getRoleType().getDefaultNodeTypes() != null && roleBean.getRoleType().getDefaultNodeTypes().size() == 1) {
                type = roleBean.getRoleType().getDefaultNodeTypes().get(0);
            }
        } else if (scope.equals("currentSite")) {
            type = "jnt:virtualsite";
        } else if (scope.startsWith("/")) {
            try {
                type = this.getSession().getNode(scope).getPrimaryNodeTypeName();
            }
            catch (PathNotFoundException e) {
                logger.debug("Error retrieving scope", (Throwable)e);
            }
            catch (RepositoryException e) {
                logger.error("Error retrieving scope", (Throwable)e);
            }
        }
        if (type == null || !globalPermissionsGroups.containsKey(type) && (permissionsGroupsForRoleType == null || !permissionsGroupsForRoleType.containsKey(type))) {
            type = "nt:base";
        }
        if (permissionsGroupsForRoleType != null && permissionsGroupsForRoleType.containsKey(type)) {
            for (String s : permissionsGroupsForRoleType.get(type)) {
                permissions.get(scope).put(s, new TreeMap());
            }
        } else {
            for (String s : globalPermissionsGroups.get(type)) {
                permissions.get(scope).put(s, new TreeMap());
            }
        }
        HashMap<String, PermissionBean> mappedPermissions = new HashMap<String, PermissionBean>();
        HashMap<String, String> allGroups = new HashMap<String, String>();
        for (String string : permissions.get(scope).keySet()) {
            for (String s1 : Arrays.asList(string.split(","))) {
                allGroups.put(s1, string);
            }
        }
        for (Map.Entry entry : this.roleTypes.getPermissionsMapping().entrySet()) {
            String[] splitPath = ((String)entry.getKey()).split("/");
            String permissionGroup = splitPath[2];
            if (!allGroups.containsKey(permissionGroup)) continue;
            p = permissions.get(scope).get(allGroups.get(permissionGroup));
            bean = new PermissionBean();
            bean.setUuid(null);
            bean.setParentPath(StringUtils.substringBeforeLast((String)((String)entry.getKey()), (String)"/"));
            bean.setName(StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"/"));
            String localName = StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"/");
            if (localName.contains(":")) {
                localName = StringUtils.substringAfter((String)localName, (String)":");
            }
            String title = StringUtils.capitalize((String)localName.replaceAll("([A-Z])", " $0").replaceAll("[_-]", " ").toLowerCase());
            String rbName = localName.replaceAll("-", "_");
            bean.setTitle(Messages.getInternal((String)("label.permission." + rbName), (Locale)LocaleContextHolder.getLocale(), (String)title));
            bean.setDescription(Messages.getInternal((String)("label.permission." + rbName + ".description"), (Locale)LocaleContextHolder.getLocale(), (String)""));
            bean.setPath((String)entry.getKey());
            bean.setDepth(splitPath.length - 1);
            bean.setMappedPermissions(new TreeMap<String, PermissionBean>());
            if (p.containsKey(bean.getParentPath())) {
                p.get(bean.getParentPath()).setHasChildren(true);
            }
            p.put((String)entry.getKey(), bean);
            for (String s : (List)entry.getValue()) {
                this.createMappedPermission(s, bean, mappedPermissions);
            }
        }
        for (JCRNodeWrapper jCRNodeWrapper : allPermissions) {
            JCRNodeWrapper permissionGroup = this.getPermissionGroupNode(jCRNodeWrapper);
            String permissionPath = this.getPermissionPath(jCRNodeWrapper);
            if (!mappedPermissions.containsKey(permissionPath) && mappedPermissions.containsKey(this.getPermissionPath(jCRNodeWrapper.getParent()))) {
                PermissionBean bean2 = (PermissionBean)mappedPermissions.get(this.getPermissionPath(jCRNodeWrapper.getParent()));
                this.createMappedPermission(permissionPath, bean2, mappedPermissions);
            }
            if (allGroups.containsKey(permissionGroup.getName()) && !mappedPermissions.containsKey(permissionPath) && (!(p = permissions.get(scope).get(allGroups.get(permissionGroup.getName()))).containsKey(permissionPath) || jCRNodeWrapper.getPath().startsWith("/permissions"))) {
                bean = new PermissionBean();
                this.setPermissionBeanProperties(jCRNodeWrapper, bean);
                if (p.containsKey(bean.getParentPath())) {
                    p.get(bean.getParentPath()).setHasChildren(true);
                }
                p.put(permissionPath, bean);
                this.setPermissionFlags(jCRNodeWrapper, p, bean, permIdsMap.get(scope), inheritedPermIdsMap.get(scope), p.get(bean.getParentPath()));
            }
            if (!mappedPermissions.containsKey(permissionPath)) continue;
            PermissionBean bean2 = (PermissionBean)mappedPermissions.get(permissionPath);
            Map<String, PermissionBean> p2 = permissions.get(scope).get(allGroups.get(bean2.getPath().split("/")[2]));
            this.setPermissionFlags(jCRNodeWrapper, p2, bean2, permIdsMap.get(scope), inheritedPermIdsMap.get(scope), p2.get(bean2.getParentPath()));
        }
        for (Map map : roleBean.getPermissions().values()) {
            for (Map map2 : map.values()) {
                ArrayList values = new ArrayList(map2.values());
                for (PermissionBean bean3 : values) {
                    if (bean3.getMappedPermissions() == null) continue;
                    Boolean lastValue = null;
                    for (PermissionBean value : bean3.getMappedPermissions().values()) {
                        if (lastValue == null) {
                            lastValue = value.isSuperSet() || value.isSet();
                        }
                        if (lastValue.equals(value.isSuperSet() || value.isSet())) continue;
                        bean3.setMappedPermissionsExpanded(true);
                        bean3.setSet(false);
                        bean3.setSuperSet(false);
                        bean3.setPartialSet(true);
                        break;
                    }
                    if (!bean3.isMappedPermissionsExpanded()) continue;
                    for (PermissionBean mapped : bean3.getMappedPermissions().values()) {
                        map2.put(mapped.getPath(), mapped);
                    }
                }
            }
        }
    }

    private void createMappedPermission(String permissionPath, PermissionBean parent, Map<String, PermissionBean> mappedPermissions) throws RepositoryException {
        PermissionBean mapped = new PermissionBean();
        this.setPermissionBeanProperties(this.getSession().getNode(permissionPath), mapped);
        mapped.setPath(parent.getPath() + "/" + mapped.getName());
        mapped.setParentPath(parent.getPath());
        mapped.setDepth(parent.getDepth() + 1);
        parent.getMappedPermissions().put(permissionPath, mapped);
        mappedPermissions.put(permissionPath, parent);
    }

    private void setPermissionFlags(JCRNodeWrapper permissionNode, Map<String, PermissionBean> permissions, PermissionBean bean, List<String> permIds, List<String> inheritedPermIds, PermissionBean parentBean) throws RepositoryException {
        if (permIds != null && permIds.contains(permissionNode.getName()) || parentBean != null && parentBean.isSet()) {
            bean.setSet(true);
            if (bean.getMappedPermissions() != null && bean.getMappedPermissions().containsKey(permissionNode.getPath())) {
                bean.getMappedPermissions().get(permissionNode.getPath()).setSet(true);
            }
            while (parentBean != null && !parentBean.isSet() && !parentBean.isSuperSet()) {
                parentBean.setPartialSet(true);
                parentBean = permissions.get(parentBean.getParentPath());
            }
        }
        parentBean = permissions.get(bean.getParentPath());
        if (inheritedPermIds != null && inheritedPermIds.contains(permissionNode.getName()) || parentBean != null && parentBean.isSuperSet()) {
            bean.setSuperSet(true);
            if (bean.getMappedPermissions() != null && bean.getMappedPermissions().containsKey(permissionNode.getPath())) {
                bean.getMappedPermissions().get(permissionNode.getPath()).setSuperSet(true);
            }
            while (parentBean != null && !parentBean.isSet() && !parentBean.isSuperSet()) {
                parentBean.setPartialSet(true);
                parentBean = permissions.get(parentBean.getParentPath());
            }
        }
    }

    private String getPermissionPath(JCRNodeWrapper permissionNode) {
        String path = permissionNode.getPath();
        if (path.startsWith("/modules")) {
            path = "/permissions/" + StringUtils.substringAfter((String)path, (String)"/permissions/");
        }
        return path;
    }

    private String getPermissionModule(JCRNodeWrapper permissionNode) {
        String path = permissionNode.getPath();
        if (path.startsWith("/modules/")) {
            String s = StringUtils.substringAfter((String)path, (String)"/modules/");
            return StringUtils.substringBefore((String)s, (String)"/");
        }
        return null;
    }

    private int getPermissionDepth(JCRNodeWrapper permissionNode) throws RepositoryException {
        String path = permissionNode.getPath();
        if (path.startsWith("/modules")) {
            return permissionNode.getDepth() - 3;
        }
        return permissionNode.getDepth();
    }

    private JCRNodeWrapper getPermissionGroupNode(JCRNodeWrapper permissionNode) throws RepositoryException {
        JCRNodeWrapper permissionGroup = (JCRNodeWrapper)permissionNode.getAncestor(2);
        if (permissionGroup.isNodeType("jnt:module")) {
            permissionGroup = (JCRNodeWrapper)permissionNode.getAncestor(5);
        }
        return permissionGroup;
    }

    private void setPermissionBeanProperties(JCRNodeWrapper permissionNode, PermissionBean bean) throws RepositoryException {
        String module = this.getPermissionModule(permissionNode);
        bean.setUuid(permissionNode.getIdentifier());
        bean.setParentPath(this.getPermissionPath(permissionNode.getParent()));
        bean.setName(permissionNode.getName());
        String localName = permissionNode.getName();
        if (localName.contains(":")) {
            localName = StringUtils.substringAfter((String)localName, (String)":");
        }
        String title = StringUtils.capitalize((String)localName.replaceAll("([A-Z])", " $0").replaceAll("[_-]", " ").toLowerCase());
        String rbName = localName.replaceAll("-", "_");
        if (module != null) {
            bean.setTitle(Messages.get((JahiaTemplatesPackage)this.templateManagerService.getTemplatePackageById(module), (String)("label.permission." + rbName), (Locale)LocaleContextHolder.getLocale(), (String)title));
        } else {
            bean.setTitle(Messages.getInternal((String)("label.permission." + rbName), (Locale)LocaleContextHolder.getLocale(), (String)title));
        }
        bean.setModule(module);
        bean.setDescription(Messages.getInternal((String)("label.permission." + rbName + ".description"), (Locale)LocaleContextHolder.getLocale(), (String)""));
        bean.setPath(this.getPermissionPath(permissionNode));
        bean.setDepth(this.getPermissionDepth(permissionNode));
    }

    public String getCurrentContext() {
        return this.currentContext;
    }

    public void setCurrentContext(String tab) {
        this.currentContext = tab;
        this.currentGroup = this.roleBean.getPermissions().get(this.currentContext).keySet().iterator().next();
    }

    public String getCurrentGroup() {
        return this.currentGroup;
    }

    public void setCurrentGroup(String context, String currentGroup) {
        this.setCurrentContext(context);
        this.currentGroup = currentGroup;
    }

    public void storeValues(String[] selectedValues, String[] partialSelectedValues) {
        Map<String, PermissionBean> permissionBeans = this.roleBean.getPermissions().get(this.currentContext).get(this.currentGroup);
        ArrayList perms = selectedValues != null ? Arrays.asList(selectedValues) : new ArrayList();
        for (PermissionBean permissionBean : permissionBeans.values()) {
            if (permissionBean.isSet() == perms.contains(permissionBean.getPath())) continue;
            this.roleBean.setDirty(true);
            permissionBean.setSet(perms.contains(permissionBean.getPath()));
            if (permissionBean.isMappedPermissionsExpanded() || permissionBean.getMappedPermissions() == null) continue;
            for (PermissionBean mapped : permissionBean.getMappedPermissions().values()) {
                mapped.setSet(perms.contains(permissionBean.getPath()));
            }
        }
        perms = partialSelectedValues != null ? Arrays.asList(partialSelectedValues) : new ArrayList();
        for (PermissionBean permissionBean : permissionBeans.values()) {
            if (permissionBean.isPartialSet() == perms.contains(permissionBean.getPath())) continue;
            this.roleBean.setDirty(true);
            permissionBean.setPartialSet(perms.contains(permissionBean.getPath()));
            if (permissionBean.isMappedPermissionsExpanded() || permissionBean.getMappedPermissions() == null) continue;
            for (PermissionBean mapped : permissionBean.getMappedPermissions().values()) {
                mapped.setPartialSet(perms.contains(permissionBean.getPath()));
            }
        }
    }

    public void addContext(String newContext) throws RepositoryException {
        if (!newContext.startsWith("/")) {
            return;
        }
        if (!this.roleBean.getPermissions().containsKey(newContext)) {
            this.addPermissionsForScope(this.roleBean, newContext, new HashMap<String, List<String>>(), new HashMap<String, List<String>>());
        }
        this.setCurrentContext(newContext);
    }

    public void removeContext(String scope) throws RepositoryException {
        if (this.roleBean.getPermissions().containsKey(scope)) {
            this.roleBean.getPermissions().remove(scope);
        }
        if (this.currentContext.equals(scope)) {
            this.setCurrentContext(this.roleBean.getPermissions().keySet().iterator().next());
        }
    }

    public void save() throws RepositoryException {
        JCRSessionWrapper currentUserSession = this.getSession();
        HashMap permissions = new HashMap();
        for (Map.Entry<String, Map<String, Map<String, PermissionBean>>> entry : this.roleBean.getPermissions().entrySet()) {
            ArrayList<Value> permissionValues = new ArrayList<Value>();
            permissions.put(entry.getKey(), permissionValues);
            for (Map<String, PermissionBean> map : entry.getValue().values()) {
                for (PermissionBean bean : map.values()) {
                    PermissionBean parentBean = map.get(bean.getParentPath());
                    if (!bean.isSet() || parentBean != null && parentBean.isSet()) continue;
                    if (bean.getMappedPermissions() != null) {
                        for (PermissionBean mapped : bean.getMappedPermissions().values()) {
                            if (!mapped.isSet()) continue;
                            permissionValues.add(currentUserSession.getValueFactory().createValue(mapped.getName(), 1));
                        }
                        continue;
                    }
                    permissionValues.add(currentUserSession.getValueFactory().createValue(bean.getName(), 1));
                }
            }
        }
        JCRNodeWrapper role = currentUserSession.getNodeByIdentifier(this.roleBean.getUuid());
        HashSet<String> externalPermissionNodes = new HashSet<String>();
        for (Map.Entry s : permissions.entrySet()) {
            String key = (String)s.getKey();
            if (key.equals("current")) {
                role.setProperty("j:permissionNames", ((List)permissions.get("current")).toArray(new Value[((List)permissions.get("current")).size()]));
                continue;
            }
            key = key.equals("/") ? "root-access" : ISO9075.encode((String)(key.startsWith("/") ? key.substring(1) : key).replace("/", "-")) + "-access";
            if (((List)s.getValue()).isEmpty()) continue;
            if (!role.hasNode(key)) {
                JCRNodeWrapper extPermissions = role.addNode(key, "jnt:externalPermissions");
                extPermissions.setProperty("j:path", (String)s.getKey());
                extPermissions.setProperty("j:permissionNames", ((List)s.getValue()).toArray(new Value[((List)s.getValue()).size()]));
            } else {
                role.getNode(key).setProperty("j:permissionNames", ((List)s.getValue()).toArray(new Value[((List)s.getValue()).size()]));
            }
            externalPermissionNodes.add(key);
        }
        JCRNodeIteratorWrapper ni = role.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
            if (!next.getPrimaryNodeTypeName().equals("jnt:externalPermissions") || externalPermissionNodes.contains(next.getName())) continue;
            next.remove();
        }
        Map<String, I18nRoleProperties> i18nRoleProperties = this.roleBean.getI18nProperties();
        for (String l : i18nRoleProperties.keySet()) {
            JCRNodeWrapper n = this.getSession(new Locale(l)).getNodeByIdentifier(this.roleBean.getUuid());
            I18nRoleProperties properties = i18nRoleProperties.get(l);
            if (properties == null) {
                if (n.hasProperty("jcr:title")) {
                    n.getProperty("jcr:title").remove();
                }
                if (!n.hasProperty("jcr:description")) continue;
                n.getProperty("jcr:description").remove();
                continue;
            }
            String title = properties.getTitle();
            if (StringUtils.isNotBlank((String)title)) {
                n.setProperty("jcr:title", title);
            } else if (n.hasProperty("jcr:title")) {
                n.getProperty("jcr:title").remove();
            }
            String description = properties.getDescription();
            if (StringUtils.isNotBlank((String)description)) {
                n.setProperty("jcr:description", description);
                continue;
            }
            if (!n.hasProperty("jcr:description")) continue;
            n.getProperty("jcr:description").remove();
        }
        role.setProperty("j:hidden", this.roleBean.isHidden());
        if (this.roleBean.getNodeTypes() != null) {
            ArrayList<Value> values = new ArrayList<Value>();
            for (NodeType nodeType : this.roleBean.getNodeTypes()) {
                if (!nodeType.isSet()) continue;
                values.add(currentUserSession.getValueFactory().createValue(nodeType.getName()));
            }
            role.setProperty("j:nodeTypes", values.toArray(new Value[values.size()]));
        }
        this.roleBean.setDirty(false);
        currentUserSession.save();
    }

    public List<JCRNodeWrapper> getAllPermissions() throws RepositoryException {
        if (this.allPermissions != null) {
            return this.allPermissions;
        }
        this.allPermissions = new ArrayList<JCRNodeWrapper>();
        JCRSessionWrapper currentUserSession = this.getSession();
        QueryManagerWrapper qm = currentUserSession.getWorkspace().getQueryManager();
        String statement = "select * from [jnt:permission]";
        Query q = qm.createQuery(statement, "JCR-SQL2");
        NodeIterator ni = q.execute().getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
            int depth = 2;
            if (((JCRNodeWrapper)next.getAncestor(1)).isNodeType("jnt:modules")) {
                depth = 5;
                JahiaTemplatesPackage pack = this.templateManagerService.getTemplatePackageById(next.getAncestor(2).getName());
                if (pack == null || !pack.getVersion().toString().equals(next.getAncestor(3).getName())) continue;
            }
            if (next.getDepth() < depth) continue;
            this.allPermissions.add(next);
        }
        Collections.sort(this.allPermissions, new Comparator<JCRNodeWrapper>(){

            @Override
            public int compare(JCRNodeWrapper o1, JCRNodeWrapper o2) {
                if (RolesAndPermissionsHandler.this.getPermissionPath(o1).equals(RolesAndPermissionsHandler.this.getPermissionPath(o2))) {
                    return -o1.getPath().compareTo(o2.getPath());
                }
                return RolesAndPermissionsHandler.this.getPermissionPath(o1).compareTo(RolesAndPermissionsHandler.this.getPermissionPath(o2));
            }
        });
        return this.allPermissions;
    }

    public void storeDetails(String[] languageCodes, String[] languageNames, String[] titles, String[] descriptions, Boolean hidden, String[] nodeTypes) {
        block10: {
            if (languageCodes != null) {
                Map<String, I18nRoleProperties> i18nProperties = this.roleBean.getI18nProperties();
                for (int i = 0; i < languageCodes.length; ++i) {
                    I18nRoleProperties properties;
                    String l = languageCodes[i];
                    String title = titles != null && languageCodes.length == 1 ? StringUtils.join((Object[])titles, (String)", ") : (titles != null && i < titles.length ? titles[i] : "");
                    String description = descriptions != null && languageCodes.length == 1 ? StringUtils.join((Object[])descriptions, (String)", ") : (descriptions != null && i < descriptions.length ? descriptions[i] : "");
                    if (StringUtils.isBlank((String)title) && StringUtils.isBlank((String)description)) {
                        i18nProperties.put(l, null);
                        continue;
                    }
                    if (!i18nProperties.containsKey(l) || i18nProperties.get(l) == null) {
                        properties = new I18nRoleProperties();
                        properties.setLanguage(languageNames[i]);
                        i18nProperties.put(l, properties);
                    } else {
                        properties = i18nProperties.get(l);
                    }
                    if (!title.equals(properties.getTitle())) {
                        this.roleBean.setDirty(true);
                        properties.setTitle(title);
                    }
                    if (description.equals(properties.getDescription())) continue;
                    this.roleBean.setDirty(true);
                    properties.setDescription(description);
                }
            }
            this.roleBean.setHidden(hidden != null && hidden != false);
            if (this.roleBean.getNodeTypes() == null) break block10;
            if (nodeTypes != null) {
                List<String> values = Arrays.asList(nodeTypes);
                for (NodeType nodeType : this.roleBean.getNodeTypes()) {
                    nodeType.setSet(values.contains(nodeType.getName()));
                }
            } else {
                for (NodeType nodeType : this.roleBean.getNodeTypes()) {
                    nodeType.setSet(false);
                }
            }
        }
    }

    public void expandMapped(String path) {
        block4: {
            Map<String, PermissionBean> permissionBeans = this.roleBean.getPermissions().get(this.currentContext).get(this.currentGroup);
            PermissionBean permissionBean = permissionBeans.get(path);
            if (permissionBean == null || permissionBean.isPartialSet()) break block4;
            if (!permissionBean.isMappedPermissionsExpanded()) {
                permissionBean.setMappedPermissionsExpanded(true);
                for (PermissionBean mapped : permissionBean.getMappedPermissions().values()) {
                    permissionBeans.put(mapped.getPath(), mapped);
                }
            } else {
                permissionBean.setMappedPermissionsExpanded(false);
                for (PermissionBean mapped : permissionBean.getMappedPermissions().values()) {
                    permissionBeans.remove(mapped.getPath());
                }
            }
        }
    }

    private String getMessage(String key) {
        return Messages.get((String)"resources.JahiaRolesManager", (String)key, (Locale)LocaleContextHolder.getLocale());
    }

    public Map<String, String> getAvailableLanguages() throws RepositoryException {
        TreeSet languages = new TreeSet(this.getSession().getNodeByIdentifier(this.roleBean.getUuid()).getResolveSite().getLanguages());
        Map<String, I18nRoleProperties> i18nProperties = this.roleBean.getI18nProperties();
        for (String l : i18nProperties.keySet()) {
            if (i18nProperties.get(l) == null) continue;
            languages.remove(l);
        }
        TreeMap<String, String> availableLanguages = new TreeMap<String, String>();
        for (String l : languages) {
            Locale locale = new Locale(l);
            availableLanguages.put(l, locale.getDisplayName(LocaleContextHolder.getLocale()));
        }
        return availableLanguages;
    }
}

