/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.jaas;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class JahiaHTTPLoginModule
implements LoginModule {
    private static final Logger LOGGER = Logger.getLogger(JahiaHTTPLoginModule.class.getName());
    private Subject subject;
    private Principal user = null;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("name?"), new PasswordCallback("pass?", false)};
            this.callbackHandler.handle(callbacks);
            final String name = ((NameCallback)callbacks[0]).getName();
            char[] pass = ((PasswordCallback)callbacks[1]).getPassword();
            URL url = new URL(this.options.get("url") + "?user=" + URLEncoder.encode(name, "UTF-8") + "&pass=" + URLEncoder.encode(new String(pass), "UTF-8"));
            int i = ((HttpURLConnection)url.openConnection()).getResponseCode();
            if (i == 200) {
                this.user = new Principal(){

                    @Override
                    public String getName() {
                        return name;
                    }
                };
            }
        }
        catch (UnsupportedCallbackException callbacks) {
        }
        catch (Exception e) {
            LOGGER.info("An exception occurred while attempting to log user. Error was: " + e.getLocalizedMessage());
        }
        return this.user != null;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.user == null) {
            return false;
        }
        this.subject.getPrincipals().add(this.user);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.user == null) {
            return false;
        }
        this.logout();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.user);
        this.user = null;
        return true;
    }
}

