/*
 * Decompiled with CFR 0.152.
 */
package com.extjs.gxt.ui.client.widget.form;

import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.core.XTemplate;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionProvider;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.Size;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.ListView;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.ListModelPropertyEditor;
import com.extjs.gxt.ui.client.widget.form.PropertyEditor;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class ListField<D extends ModelData>
extends Field<D>
implements SelectionProvider<D> {
    protected ListView<D> listView = new ListView();
    protected ListStore<D> store;
    private XTemplate template;
    private String listStyle = "x-combo-list";
    private String selectedStyle = "x-combo-selected";
    private String itemSelector;
    private El input;
    private String valueField;

    public ListField() {
        this.setSize(200, 100);
        this.setPropertyEditor((PropertyEditor<D>)new ListModelPropertyEditor());
    }

    public void addSelectionChangedListener(SelectionChangedListener<D> listener) {
        this.listView.getSelectionModel().addListener(Events.SelectionChange, listener);
    }

    public void disable() {
        super.disable();
        this.listView.disable();
    }

    public void enable() {
        super.enable();
        this.listView.enable();
    }

    public String getDisplayField() {
        return this.getPropertyEditor().getDisplayProperty();
    }

    public String getItemSelector() {
        return this.itemSelector;
    }

    public ListView<D> getListView() {
        return this.listView;
    }

    public ListModelPropertyEditor<D> getPropertyEditor() {
        return (ListModelPropertyEditor)this.propertyEditor;
    }

    public String getRawValue() {
        return "";
    }

    public List<D> getSelection() {
        return this.listView.getSelectionModel().getSelectedItems();
    }

    public ListStore<D> getStore() {
        return this.store;
    }

    public XTemplate getTemplate() {
        return this.template;
    }

    public D getValue() {
        List<D> sel = this.getSelection();
        if (sel.size() > 0) {
            return (D)((ModelData)sel.get(0));
        }
        return null;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void removeSelectionListener(SelectionChangedListener<D> listener) {
        this.listView.getSelectionModel().removeListener(Events.SelectionChange, listener);
    }

    public void setDisplayField(String displayField) {
        this.getPropertyEditor().setDisplayProperty(displayField);
    }

    public void setItemSelector(String itemSelector) {
        this.itemSelector = itemSelector;
    }

    public void setPropertyEditor(PropertyEditor<D> propertyEditor) {
        assert (propertyEditor instanceof ListModelPropertyEditor) : "PropertyEditor must be a ModelPropertyEditor instance";
        super.setPropertyEditor(propertyEditor);
    }

    public void setSelection(List<D> selection) {
        if (selection != null && selection.size() > 0) {
            super.setValue((Object)((ModelData)selection.get(0)));
            this.listView.getSelectionModel().setSelection(selection);
        } else {
            super.setValue(null);
            this.listView.getSelectionModel().deselectAll();
        }
    }

    public void setValue(D value) {
        super.setValue(value);
        this.listView.getSelectionModel().select(value, false);
    }

    public void setStore(ListStore<D> store) {
        this.store = store;
    }

    public void setTemplate(String html) {
        this.assertPreRender();
        this.template = XTemplate.create((String)html);
    }

    public void setTemplate(XTemplate template) {
        this.assertPreRender();
        this.template = template;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    protected void doAttachChildren() {
        super.doAttachChildren();
        ComponentHelper.doAttach(this.listView);
    }

    protected void doDetachChildren() {
        super.doDetachChildren();
        ComponentHelper.doDetach(this.listView);
    }

    protected El getInputEl() {
        return this.input;
    }

    protected void onFocus(ComponentEvent ce) {
        super.onFocus(ce);
        this.listView.focus();
    }

    protected void onRender(Element parent, int index) {
        this.setElement(DOM.createDiv(), parent, index);
        this.addStyleName("x-form-list");
        this.input = new El((Element)Document.get().createHiddenInputElement().cast());
        this.getElement().appendChild((Node)this.input.dom);
        if (this.template == null) {
            String html = "<tpl for=\".\"><div class='x-combo-list-item' role='option'>{" + this.getDisplayField() + "}</div></tpl>";
            this.template = XTemplate.create((String)html);
        }
        this.listView.setBorders(false);
        this.listView.setTemplate(this.template);
        this.listView.addStyleName(this.listStyle);
        this.listView.setItemSelector(this.itemSelector != null ? this.itemSelector : ".x-combo-list-item");
        this.listView.setStore(this.store);
        this.listView.setSelectStyle(this.selectedStyle);
        this.listView.setOverStyle("x-combo-over");
        this.listView.getSelectionModel().addListener(Events.SelectionChange, new Listener<SelectionChangedEvent<D>>(){

            public void handleEvent(SelectionChangedEvent<D> se) {
                ListField.this.onSelectionChange(se.getSelection());
            }
        });
        this.listView.render(this.getElement());
        this.listView.getAriaSupport().setRole("listbox");
        ComponentHelper.setParent((Widget)this, this.listView);
        this.disableTextSelection(true);
        this.sinkEvents(1);
        super.onRender(parent, index);
    }

    protected void onResize(int width, int height) {
        super.onResize(width, height);
        Size frameWidth = this.el().getFrameSize();
        this.listView.setSize(width -= frameWidth.width, height -= frameWidth.height);
    }

    protected void onSelectionChange(List<D> sel) {
        String prop = this.valueField != null ? this.valueField : this.listView.getDisplayProperty();
        String s = "";
        for (ModelData m : sel) {
            s = s + m.get(prop);
            s = s + ",";
        }
        if (s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        this.input.setValue(s);
    }

    protected boolean validateValue(String value) {
        return true;
    }
}

