/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.data;

import com.extjs.gxt.ui.client.data.ModelData;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class SerializableBaseModel
implements ModelData,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> strings;
    private Map<String, Integer> integers;
    private Map<String, Boolean> booleans;
    private transient Map<String, Serializable> properties;

    public <X> X get(String property) {
        if (this.strings != null && this.strings.containsKey(property)) {
            return (X)this.strings.get(property);
        }
        if (this.integers != null && this.integers.containsKey(property)) {
            return (X)this.integers.get(property);
        }
        if (this.booleans != null && this.booleans.containsKey(property)) {
            return (X)this.booleans.get(property);
        }
        if (this.properties != null) {
            return (X)this.properties.get(property);
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        HashMap<String, Object> returning = new HashMap<String, Object>();
        for (Map.Entry<String, Serializable> entry : this.properties.entrySet()) {
            returning.put(entry.getKey(), entry.getValue());
        }
        if (this.strings != null) {
            for (Map.Entry<String, Object> entry : this.strings.entrySet()) {
                returning.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.integers != null) {
            for (Map.Entry<String, Object> entry : this.integers.entrySet()) {
                returning.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.booleans != null) {
            for (Map.Entry<String, Object> entry : this.booleans.entrySet()) {
                returning.put(entry.getKey(), entry.getValue());
            }
        }
        return returning;
    }

    public Collection<String> getPropertyNames() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        HashSet<String> returning = new HashSet<String>();
        returning.addAll(this.properties.keySet());
        if (this.strings != null) {
            returning.addAll(this.strings.keySet());
        }
        if (this.integers != null) {
            returning.addAll(this.integers.keySet());
        }
        if (this.booleans != null) {
            returning.addAll(this.booleans.keySet());
        }
        return returning;
    }

    public <X> X remove(String property) {
        if (this.strings != null && this.strings.containsKey(property)) {
            return (X)this.strings.remove(property);
        }
        if (this.integers != null && this.integers.containsKey(property)) {
            return (X)this.integers.remove(property);
        }
        if (this.booleans != null && this.booleans.containsKey(property)) {
            return (X)this.booleans.remove(property);
        }
        if (this.properties != null) {
            return (X)this.properties.remove(property);
        }
        return null;
    }

    public <X> X set(String property, X value) {
        if (value instanceof String) {
            if (this.strings == null) {
                this.strings = new LinkedHashMap<String, String>();
            }
            return (X)this.strings.put(property, (String)value);
        }
        if (value instanceof Integer) {
            if (this.integers == null) {
                this.integers = new LinkedHashMap<String, Integer>();
            }
            return (X)this.integers.put(property, (Integer)value);
        }
        if (value instanceof Boolean) {
            if (this.booleans == null) {
                this.booleans = new LinkedHashMap<String, Boolean>();
            }
            return (X)this.booleans.put(property, (Boolean)value);
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Serializable>();
        }
        return (X)this.properties.put(property, (Serializable)value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializableBaseModel that = (SerializableBaseModel)o;
        if (this.booleans != null ? !this.booleans.equals(that.booleans) : that.booleans != null) {
            return false;
        }
        if (this.integers != null ? !this.integers.equals(that.integers) : that.integers != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.strings != null ? !this.strings.equals(that.strings) : that.strings != null);
    }

    public int hashCode() {
        int result = this.strings != null ? this.strings.hashCode() : 0;
        result = 31 * result + (this.integers != null ? this.integers.hashCode() : 0);
        result = 31 * result + (this.booleans != null ? this.booleans.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

