/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.data.definition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;

public class GWTJahiaNodeProperty
implements Serializable {
    private static final long serialVersionUID = 462346339035404507L;
    private boolean multiple;
    private boolean dirty;
    private String name;
    private List<GWTJahiaNodePropertyValue> values;

    public GWTJahiaNodeProperty() {
    }

    public GWTJahiaNodeProperty(String name, String value) {
        this(name, new GWTJahiaNodePropertyValue(value));
    }

    public GWTJahiaNodeProperty(String name, String value, int valueType) {
        this(name, new GWTJahiaNodePropertyValue(value, valueType));
    }

    public GWTJahiaNodeProperty(String name, GWTJahiaNodePropertyValue v) {
        this();
        this.setName(name);
        this.setValue(v);
    }

    public GWTJahiaNodeProperty cloneObject() {
        GWTJahiaNodeProperty prop = new GWTJahiaNodeProperty();
        prop.setName(this.getName());
        prop.setMultiple(this.isMultiple());
        ArrayList<GWTJahiaNodePropertyValue> vals = new ArrayList<GWTJahiaNodePropertyValue>(this.values.size());
        for (GWTJahiaNodePropertyValue aVal : this.values) {
            if (aVal.getNode() != null) {
                vals.add(new GWTJahiaNodePropertyValue(aVal.getNode(), aVal.getType()));
                continue;
            }
            if (aVal.getLinkNode() != null) {
                vals.add(new GWTJahiaNodePropertyValue(aVal.getLinkNode(), aVal.getType()));
                continue;
            }
            vals.add(new GWTJahiaNodePropertyValue(aVal.getString(), aVal.getType()));
        }
        prop.setValues(vals);
        return prop;
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            GWTJahiaNodeProperty prop = (GWTJahiaNodeProperty)obj;
            return prop.getName().equals(this.getName()) && prop.getValues().containsAll(this.getValues()) && this.getValues().containsAll(prop.getValues());
        }
        return false;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<GWTJahiaNodePropertyValue> getValues() {
        return this.values;
    }

    public void setValues(List<GWTJahiaNodePropertyValue> values) {
        this.dirty = true;
        this.values = values;
    }

    public void setValue(GWTJahiaNodePropertyValue value) {
        ArrayList<GWTJahiaNodePropertyValue> vals = new ArrayList<GWTJahiaNodePropertyValue>(1);
        vals.add(value);
        this.setValues(vals);
    }

    public String toString() {
        if (this.multiple) {
            StringBuilder buf = new StringBuilder(this.name);
            buf.append(" = ");
            for (int i = 0; i < this.values.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.values.get(i).toString());
            }
            return buf.toString();
        }
        return this.name + " = " + this.values.toString();
    }
}

