/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.data.node;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseTreeModel;
import com.extjs.gxt.ui.client.data.ListLoadConfig;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.SortInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTBitSet;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeVersion;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowInfo;
import org.jahia.ajax.gwt.client.util.Collator;

public class GWTJahiaNode
extends BaseTreeModel
implements Serializable,
Comparable<GWTJahiaNode>,
ListLoadConfig {
    private static final long serialVersionUID = -1918118279356793994L;
    public static final String TAGS = "tags";
    public static final String SITE_LANGUAGES = "siteLanguages";
    public static final String NAME = "name";
    public static final String ESCAPED_NAME = "escapedName";
    public static final String PATH = "path";
    public static final String ICON = "icon";
    public static final String LOCKED = "locked";
    public static final String LOCK_ALLOWS_ADD = "lockAllowsAdd";
    public static final String LOCKABLE = "lockable";
    public static final String PERMISSIONS = "permissions";
    public static final String DELETEABLE = "deleteable";
    public static final String ACL = "hasACL";
    public static final String UUID = "uuid";
    public static final String DISPLAY_NAME = "displayName";
    public static final String FILE = "file";
    public static final String SIZE = "size";
    public static final String NODE_TYPES = "nodeTypes";
    public static final String INHERITED_NODE_TYPES = "inheritedNodeTypes";
    public static final String PROVIDER_KEY = "providerKey";
    public static final String PREVIEW = "preview";
    public static final String PREVIEW_LARGE = "previewLarge";
    public static final String THUMBNAILS = "thumbnails";
    public static final String SITE_UUID = "siteUUID";
    public static final String SITE_TYPE = "siteType";
    public static final String SITE_KEY = "siteKey";
    public static final String CURRENT_VERSION = "currentVersion";
    public static final String VERSIONS = "versions";
    public static final String CHILDREN_INFO = "childrenInfo";
    public static final String COUNT = "count";
    public static final String PUBLICATION_INFO = "publicationInfo";
    public static final String PUBLICATION_INFOS = "publicationInfos";
    public static final String QUICK_PUBLICATION_INFO = "quickPublicationInfo";
    public static final String AVAILABLE_WORKKFLOWS = "j:availableWorkflows";
    public static final String WORKFLOW_INFO = "workflowInfo";
    public static final String WORKFLOW_INFOS = "workflowInfos";
    public static final String PRIMARY_TYPE_LABEL = "primaryTypeLabel";
    public static final String DEFAULT_LANGUAGE = "j:defaultLanguage";
    public static final String VISIBILITY_INFO = "visibilityInfo";
    public static final String IS_VISIBLE = "isVisible";
    public static final String LOCKS_INFO = "locksInfo";
    public static final String SUBNODES_CONSTRAINTS_INFO = "subnodesConstraintsInfo";
    public static final String SITE_MANDATORY_LANGUAGES = "siteMandatoryLanguages";
    public static final String RESOURCE_BUNDLE = "resourceBundle";
    public static final String INCLUDE_CHILDREN = "includeChildren";
    public static final String EDIT_MODE_BLOCKED = "editModeBlocked";
    public static final String WORK_IN_PROGRESS_LANGUAGES = "j:workInProgressLanguages";
    public static final String WORK_IN_PROGRESS_STATUS = "j:workInProgressStatus";
    public static final List<String> DEFAULT_FIELDS = Arrays.asList("icon", "tags", "childrenInfo", "j:view", "j:width", "j:height", "permissions", "locksInfo", "publicationInfo", "subnodesConstraintsInfo");
    public static final List<String> DEFAULT_REFERENCE_FIELDS = Arrays.asList("icon", "count", "childrenInfo", "name", "displayName");
    public static final String HOMEPAGE_PATH = "homepage-path";
    public static final List<String> DEFAULT_SITE_FIELDS = Arrays.asList("j:moduleType", "j:installedModules", "j:templatesSet", "j:dependencies", "j:languages", "j:defaultLanguage", "homepage-path", "siteLanguages", "j:versionInfo", "permissions", "locksInfo", "j:resolvedDependencies", "j:serverName");
    public static final List<String> DEFAULT_USER_FIELDS = Arrays.asList("j:firstName", "j:lastName");
    public static final List<String> DEFAULT_GROUP_FIELDS = Arrays.asList("j:firstName", "j:lastName");
    public static final List<String> DEFAULT_SITEMAP_FIELDS = Arrays.asList("j:versionInfo", "editModeBlocked");
    public static final List<String> RESERVED_FIELDS = Arrays.asList("tags", "name", "path", "icon", "locked", "lockAllowsAdd", "lockable", "permissions", "deleteable", "uuid", "displayName", "file", "size", "nodeTypes", "inheritedNodeTypes", "providerKey", "preview", "thumbnails", "siteUUID", "currentVersion", "versions", "childrenInfo", "count", "j:availableWorkflows", "j:defaultLanguage", "homepage-path", "locksInfo", "visibilityInfo", "publicationInfo", "publicationInfos", "quickPublicationInfo", "workflowInfo", "workflowInfos", "primaryTypeLabel", "siteLanguages", "subnodesConstraintsInfo", "j:versionInfo", "resourceBundle", "j:resolvedDependencies", "j:isDynamicMountPoint", "index", "j:view", "j:width", "j:height", "j:password");
    private boolean displayable = false;
    private boolean isShared = false;
    private boolean reference = false;
    private String url;
    private boolean hasChildren = false;
    private boolean versioned = false;
    private SortInfo sortInfo = new SortInfo("displayName", Style.SortDir.ASC);
    private List<GWTJahiaNodeVersion> versions;
    private String selectedVersion;
    private String languageCode;
    private boolean expandOnLoad = false;
    private boolean selectedOnLoad = false;
    private GWTJahiaNode referencedNode;
    private GWTJahiaWorkflowInfo workflowInfo;
    private GWTBitSet permissions;
    private boolean matchFilters = false;
    private Map<String, GWTJahiaPublicationInfo> publicationInfos;
    private GWTJahiaPublicationInfo quickPublicationInfo;
    private Map<String, GWTJahiaWorkflowInfo> workflowInfos;
    private Map<String, List<GWTJahiaPublicationInfo>> fullPublicationInfos;
    private boolean wcagCompliance;
    private List<String> invalidLanguages;
    protected Set<String> removedChildrenPaths = new HashSet<String>();

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setDisplayable(boolean disp) {
        this.displayable = disp;
    }

    public boolean isDisplayable() {
        return this.displayable;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setLockable(Boolean lockable) {
        this.set(LOCKABLE, lockable);
    }

    public Boolean isLockable() {
        return this.get(LOCKABLE) != null ? (Boolean)this.get(LOCKABLE) : false;
    }

    public void setLocked(Boolean locked) {
        this.set(LOCKED, locked);
    }

    public Boolean isLocked() {
        return this.get(LOCKED) != null ? (Boolean)this.get(LOCKED) : false;
    }

    public void setLockAllowsAdd(Boolean locked) {
        this.set(LOCK_ALLOWS_ADD, locked);
    }

    public Boolean isLockAllowsAdd() {
        return this.get(LOCK_ALLOWS_ADD) != null ? (Boolean)this.get(LOCK_ALLOWS_ADD) : false;
    }

    public Map<String, List<String>> getLockInfos() {
        return (Map)this.get("lockInfos");
    }

    public void setLockInfos(Map<String, List<String>> lockInfos) {
        this.set("lockInfos", lockInfos);
    }

    public Boolean canUnlock() {
        return (Boolean)this.get("canUnlock");
    }

    public void setCanUnlock(Boolean canUnlock) {
        this.set("canUnlock", canUnlock);
    }

    public Boolean canLock() {
        return (Boolean)this.get("canLock");
    }

    public void setCanLock(Boolean canLock) {
        this.set("canLock", canLock);
    }

    public void setPermissions(GWTBitSet permissions) {
        this.permissions = permissions;
    }

    public GWTBitSet getPermissions() {
        return this.permissions;
    }

    public void setName(String name) {
        this.set(NAME, name);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setEscapedName(String escapedName) {
        this.set(ESCAPED_NAME, escapedName);
    }

    public String getEscapedName() {
        String escapedName = (String)this.get(ESCAPED_NAME);
        return escapedName != null ? escapedName : (String)this.get(NAME);
    }

    public void setUUID(String uuid) {
        this.set(UUID, uuid);
    }

    public String getUUID() {
        return (String)this.get(UUID);
    }

    public void setDisplayName(String name) {
        this.set(DISPLAY_NAME, name);
    }

    public String getDisplayName() {
        return (String)this.get(DISPLAY_NAME);
    }

    public void setPath(String path) {
        this.set(PATH, path);
    }

    public String getPath() {
        return (String)this.get(PATH);
    }

    public void setTags(String tags) {
        this.set(TAGS, tags);
    }

    public String getTags() {
        return (String)this.get(TAGS);
    }

    public void setFile(Boolean file) {
        this.set(FILE, file);
    }

    public Boolean isFile() {
        return (Boolean)this.get(FILE);
    }

    public void setSize(Long size) {
        this.set(SIZE, size);
    }

    public Long getSize() {
        return (Long)this.get(SIZE);
    }

    public void setNodeTypes(List<String> nodeTypes) {
        this.set(NODE_TYPES, nodeTypes);
    }

    public List<String> getNodeTypes() {
        return (List)this.get(NODE_TYPES);
    }

    public void setInheritedNodeTypes(List<String> nodeTypes) {
        this.set(INHERITED_NODE_TYPES, nodeTypes);
    }

    public List<String> getInheritedNodeTypes() {
        return (List)this.get(INHERITED_NODE_TYPES);
    }

    public void setIcon(String icon) {
        this.set(ICON, icon);
    }

    public String getIcon() {
        return (String)this.get(ICON);
    }

    public void setProviderKey(String providerName) {
        this.set(PROVIDER_KEY, providerName);
    }

    public String getProviderKey() {
        return (String)this.get(PROVIDER_KEY);
    }

    public void setPreview(String preview) {
        this.set(PREVIEW, preview);
    }

    public String getPreview() {
        return (String)this.get(PREVIEW);
    }

    public void setPreviewLarge(String preview) {
        this.set(PREVIEW_LARGE, preview);
    }

    public String getPreviewLarge() {
        return (String)this.get(PREVIEW_LARGE);
    }

    @Deprecated
    public void setThumbnailsMap(Map<String, String> preview) {
        this.set(THUMBNAILS, preview);
    }

    @Deprecated
    public Map<String, String> getThumbnailsMap() {
        return (Map)this.get(THUMBNAILS);
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public void setSiteUUID(String siteUUID) {
        this.set(SITE_UUID, siteUUID);
    }

    public String getSiteUUID() {
        return (String)this.get(SITE_UUID);
    }

    public void setSiteKey(String siteKey) {
        this.set(SITE_KEY, siteKey);
    }

    public String getSiteKey() {
        return (String)this.get(SITE_KEY);
    }

    public void setVisibilityInfo(Map<GWTJahiaNode, ModelData> visible) {
        this.set(VISIBILITY_INFO, visible);
    }

    public Map<GWTJahiaNode, ModelData> getVisibilityInfo() {
        return (Map)this.get(VISIBILITY_INFO);
    }

    public void setVisible(Boolean visible) {
        this.set(IS_VISIBLE, visible);
    }

    public Boolean isVisible() {
        return (Boolean)this.get(IS_VISIBLE);
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public void setVersioned(boolean versioned) {
        this.versioned = versioned;
    }

    public boolean isMatchFilters() {
        return this.matchFilters;
    }

    public void setMatchFilters(boolean matchFilters) {
        this.matchFilters = matchFilters;
    }

    @Override
    public int compareTo(GWTJahiaNode o) {
        if (this.isFile().booleanValue()) {
            if (o.isFile().booleanValue()) {
                return Collator.getInstance().localeCompare(this.getName(), o.getName());
            }
            return -1;
        }
        if (o.isFile().booleanValue()) {
            return 1;
        }
        return Collator.getInstance().localeCompare(this.getName(), o.getName());
    }

    public Style.SortDir getSortDir() {
        return this.sortInfo.getSortDir();
    }

    public String getSortField() {
        return this.sortInfo.getSortField();
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public void setSortDir(Style.SortDir sortDir) {
        this.sortInfo.setSortDir(sortDir);
    }

    public void setSortField(String s) {
        this.sortInfo.setSortField(s);
    }

    public void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public void setVersions(List<GWTJahiaNodeVersion> versions) {
        this.versions = versions;
    }

    public List<GWTJahiaNodeVersion> getVersions() {
        return this.versions;
    }

    public void setCurrentVersion(String currentVersion) {
        this.set(CURRENT_VERSION, currentVersion);
    }

    public String getCurrentVersion() {
        return (String)this.get(CURRENT_VERSION);
    }

    public void setSelectedVersion(String selectedVersion) {
        this.selectedVersion = selectedVersion;
    }

    public String getSelectedVersion() {
        return this.selectedVersion;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setIsShared(boolean isShared) {
        this.isShared = isShared;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setReferencedNode(GWTJahiaNode referencedNode) {
        this.referencedNode = referencedNode;
    }

    public GWTJahiaNode getReferencedNode() {
        return this.referencedNode;
    }

    public void setChildConstraints(String constraints) {
        this.set("constraints", constraints);
    }

    public String getChildConstraints() {
        return (String)this.get("constraints");
    }

    public void setExpandOnLoad(boolean expandOnLoad) {
        this.expandOnLoad = expandOnLoad;
    }

    public boolean isExpandOnLoad() {
        return this.expandOnLoad;
    }

    public void setSelectedOnLoad(boolean selectedOnLoad) {
        this.selectedOnLoad = selectedOnLoad;
    }

    public boolean isSelectedOnLoad() {
        return this.selectedOnLoad;
    }

    public boolean isPage() {
        return this.getInheritedNodeTypes().contains("jnt:page") || this.getNodeTypes().contains("jnt:page");
    }

    public GWTJahiaPublicationInfo getAggregatedPublicationInfo() {
        if (this.publicationInfos == null) {
            return null;
        }
        return this.publicationInfos.get(JahiaGWTParameters.getLanguage());
    }

    public void setWorkflowInfo(GWTJahiaWorkflowInfo workflowInfo) {
        this.workflowInfo = workflowInfo;
    }

    public GWTJahiaWorkflowInfo getWorkflowInfo() {
        return this.workflowInfo;
    }

    public GWTJahiaPublicationInfo getQuickPublicationInfo() {
        return this.quickPublicationInfo;
    }

    public void setQuickPublicationInfo(GWTJahiaPublicationInfo quickPublicationInfo) {
        this.quickPublicationInfo = quickPublicationInfo;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GWTJahiaNode that = (GWTJahiaNode)o;
        return this.getPath() != null ? this.getPath().equals(that.getPath()) : that.getPath() == null;
    }

    public int hashCode() {
        return this.getPath() != null ? this.getPath().hashCode() : 0;
    }

    public void setAggregatedPublicationInfos(Map<String, GWTJahiaPublicationInfo> publicationInfos) {
        this.publicationInfos = publicationInfos;
    }

    public Map<String, GWTJahiaPublicationInfo> getAggregatedPublicationInfos() {
        return this.publicationInfos;
    }

    public void setWorkflowInfos(Map<String, GWTJahiaWorkflowInfo> workflowInfos) {
        this.workflowInfos = workflowInfos;
    }

    public Map<String, GWTJahiaWorkflowInfo> getWorkflowInfos() {
        return this.workflowInfos;
    }

    public void setFullPublicationInfos(Map<String, List<GWTJahiaPublicationInfo>> fullPublicationInfos) {
        this.fullPublicationInfos = fullPublicationInfos;
    }

    public Map<String, List<GWTJahiaPublicationInfo>> getFullPublicationInfos() {
        return this.fullPublicationInfos;
    }

    public boolean isReference() {
        return this.reference;
    }

    public void setReference(boolean reference) {
        this.reference = reference;
    }

    public void setHasAcl(Boolean deleteable) {
        this.set(ACL, deleteable);
    }

    public Boolean isHasAcl() {
        return (Boolean)this.get(ACL);
    }

    public boolean isWCAGComplianceCheckEnabled() {
        return this.wcagCompliance;
    }

    public void setWCAGComplianceCheckEnabled(boolean wcagComplianceCheckEnabled) {
        this.wcagCompliance = wcagComplianceCheckEnabled;
    }

    public boolean isNodeType(String nodeType) {
        return this.getNodeTypes().contains(nodeType) || this.getInheritedNodeTypes().contains(nodeType);
    }

    public boolean isNodeType(Collection<String> nodeTypes) {
        for (String nodeType : nodeTypes) {
            if (!this.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    public void setCanMarkForDeletion(boolean canMarkForDeletion) {
        this.set("canMarkForDeletion", canMarkForDeletion);
    }

    public boolean canMarkForDeletion() {
        return (Boolean)this.get("canMarkForDeletion");
    }

    public List<String> getInvalidLanguages() {
        return this.invalidLanguages;
    }

    public void setInvalidLanguages(List<String> invalidLanguages) {
        this.invalidLanguages = invalidLanguages;
    }

    public List<String> getRemovedChildrenPaths() {
        return new ArrayList<String>(this.removedChildrenPaths);
    }

    public void clearRemovedChildrenPaths() {
        this.removedChildrenPaths = new HashSet<String>();
    }

    public void remove(int index) {
        GWTJahiaNode child = (GWTJahiaNode)this.children.get(index);
        if (child.get(UUID) != null) {
            String path = child.getPath();
            this.removedChildrenPaths.add(path);
        }
        super.remove(index);
    }

    public void remove(ModelData child) {
        if (this.children.contains(child) && child.get(UUID) != null) {
            this.removedChildrenPaths.add(((GWTJahiaNode)child).getPath());
        }
        super.remove(child);
    }

    public void removeAll() {
        for (ModelData child : this.children) {
            this.removedChildrenPaths.add(((GWTJahiaNode)child).getPath());
        }
        super.removeAll();
    }

    public boolean isInWorkInProgress(String language) {
        String wipStatusStr = this.getWorkInProgressStatus();
        if (wipStatusStr == null) {
            return false;
        }
        WipStatus wipStatus = WipStatus.valueOf(wipStatusStr);
        switch (wipStatus) {
            case DISABLED: {
                return false;
            }
            case ALL_CONTENT: {
                return true;
            }
            case LANGUAGES: {
                List<String> wipLanguages = this.getWorkInProgressLanguages();
                return wipLanguages != null && wipLanguages.contains(language);
            }
        }
        throw new IllegalStateException("Unsupported WIP status: " + (Object)((Object)wipStatus));
    }

    public List<String> getWorkInProgressLanguages() {
        return (List)this.get(WORK_IN_PROGRESS_LANGUAGES);
    }

    public String getWorkInProgressStatus() {
        return (String)this.get(WORK_IN_PROGRESS_STATUS);
    }

    public void setWorkInProgressLanguages(List<String> languages) {
        this.set(WORK_IN_PROGRESS_LANGUAGES, languages);
    }

    public void setWorkInProgressStatus(String status) {
        this.set(WORK_IN_PROGRESS_STATUS, status);
    }

    public boolean isMarkedForDeletion() {
        List<String> nodeTypes = this.getNodeTypes();
        return nodeTypes != null && nodeTypes.contains("jmix:markedForDeletion");
    }

    public boolean isMarkedForDeletionRoot() {
        List<String> nodeTypes = this.getNodeTypes();
        return nodeTypes != null && nodeTypes.contains("jmix:markedForDeletionRoot");
    }

    public static enum WipStatus {
        DISABLED,
        ALL_CONTENT,
        LANGUAGES;

    }
}

