/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util.icons;

import com.extjs.gxt.ui.client.data.ModelIconProvider;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Image;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;

public class ContentModelIconProvider
implements ModelIconProvider<GWTJahiaNode> {
    private static ContentModelIconProvider iconProvider = new ContentModelIconProvider();

    private ContentModelIconProvider() {
    }

    public static ContentModelIconProvider getInstance() {
        if (iconProvider == null) {
            iconProvider = new ContentModelIconProvider();
        }
        return iconProvider;
    }

    public AbstractImagePrototype getIcon(GWTJahiaNode gwtJahiaNode) {
        return this.getIcon(gwtJahiaNode, false);
    }

    public AbstractImagePrototype getIcon(GWTJahiaNode gwtJahiaNode, boolean large) {
        if (gwtJahiaNode != null) {
            String icon = gwtJahiaNode.getIcon();
            boolean isOpened = gwtJahiaNode.isExpandOnLoad();
            return this.getIcon(icon, isOpened, large);
        }
        return null;
    }

    public AbstractImagePrototype getIcon(GWTJahiaNodeType gwtJahiaNodeType) {
        return this.getIcon(gwtJahiaNodeType, false);
    }

    public AbstractImagePrototype getIcon(GWTJahiaNodeType gwtJahiaNodeType, boolean large) {
        if (gwtJahiaNodeType != null) {
            String icon = gwtJahiaNodeType.getIcon();
            return this.getIcon(icon, false, large);
        }
        return null;
    }

    public AbstractImagePrototype getIcon(final String icon, boolean isOpened, final boolean large) {
        return new AbstractImagePrototype(){

            public String getUrl() {
                String url = icon;
                String suffix = ".png";
                if (icon != null && icon.contains(".")) {
                    url = icon.substring(0, icon.indexOf("."));
                    suffix = icon.substring(icon.indexOf("."));
                }
                return url + (large ? "_large" : "") + suffix;
            }

            public void applyTo(Image image) {
                image.setUrl(this.getUrl());
            }

            public void applyTo(AbstractImagePrototype.ImagePrototypeElement imageElement) {
            }

            public AbstractImagePrototype.ImagePrototypeElement createElement() {
                SpanElement tmp = Document.get().createSpanElement();
                tmp.setInnerHTML(this.getHTML());
                return (AbstractImagePrototype.ImagePrototypeElement)tmp.getFirstChildElement();
            }

            public Image createImage() {
                return new Image(this.getUrl());
            }

            public String getHTML() {
                return "<img src=\"" + this.getUrl() + "\" />";
            }
        };
    }
}

