/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget;

import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;

public abstract class SearchField
extends ToolBar {
    private TextField<String> field;

    public SearchField(String name, boolean saveSearchbutton) {
        this.addStyleName("search-container");
        LabelToolItem label = new LabelToolItem(name);
        this.field = new TextField();
        this.field.setWidth(150);
        this.field.setFieldLabel(name);
        this.field.addKeyListener(new KeyListener(){

            public void componentKeyPress(ComponentEvent event) {
                if (event.getKeyCode() == 13) {
                    SearchField.this.onFieldValidation(SearchField.this.field.getRawValue());
                }
            }
        });
        this.add((Component)label);
        this.add((Component)this.field);
        Button ok = new Button();
        ok.setIcon(StandardIconsProvider.STANDARD_ICONS.savedSearch());
        ok.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent e) {
                SearchField.this.onFieldValidation(SearchField.this.field.getRawValue());
            }
        });
        this.add((Component)ok);
        this.add((Component)new FillToolItem());
        if (saveSearchbutton) {
            Button save = new Button(Messages.get("saveSearch.label"));
            save.addStyleName("button-savesearch");
            save.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent event) {
                    SearchField.this.onSaveButtonClicked(SearchField.this.field.getRawValue());
                }
            });
            this.add((Component)save);
        }
    }

    public String getText() {
        return this.field.getRawValue();
    }

    public void clear() {
        this.field.setRawValue("");
    }

    public abstract void onFieldValidation(String var1);

    public abstract void onSaveButtonClicked(String var1);
}

