/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.ckeditor;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.ckeditor.CKEditorConfig;
import org.jahia.ajax.gwt.client.widget.form.CKEditorField;

public class CKEditor
extends Component {
    private String instanceId;
    private CKEditorConfig config;
    private boolean isLoaded;
    private boolean isDetached = false;
    private CKEditorField field;
    private boolean focus = false;
    private String name;

    public CKEditor(CKEditorConfig config, CKEditorField field) {
        if (config == null) {
            config = new CKEditorConfig();
            String toolbar = "Light";
            if (PermissionsUtils.isPermitted("wysiwyg-editor-toolbar/full") || PermissionsUtils.isPermitted("studioModeAccess")) {
                toolbar = "Full";
            } else if (PermissionsUtils.isPermitted("wysiwyg-editor-toolbar/basic")) {
                toolbar = "Basic";
            }
            config.setDefaultToolbar(toolbar);
        }
        this.config = config;
        this.field = field;
    }

    protected void onRender(Element target, int index) {
        Element ele = DOM.createTextArea();
        DOM.setElementAttribute((com.google.gwt.dom.client.Element)target, (String)"name", (String)this.name);
        DOM.setElementAttribute((com.google.gwt.dom.client.Element)ele, (String)"width", (String)this.config.getWidth());
        DOM.setElementAttribute((com.google.gwt.dom.client.Element)ele, (String)"height", (String)this.config.getHeight());
        this.setElement(ele, target, index);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                CKEditor.this.instanceId = CKEditor.this.getElement().getId();
                DOM.setElementAttribute((com.google.gwt.dom.client.Element)CKEditor.this.getElement(), (String)"name", (String)CKEditor.this.instanceId);
                CKEditor.this.destroyEditor();
                CKEditor.this.initEditor();
                CKEditor.this.isLoaded = true;
                CKEditor.this.field.afterCKEditorInstanceReady();
                if (CKEditor.this.focus) {
                    CKEditor.this.focusCK();
                }
            }
        });
        super.onRender(target, index);
    }

    protected void onDetach() {
        if (this.isLoaded) {
            this.destroyEditor();
            this.isDetached = true;
            super.onDetach();
        }
    }

    protected void onAttach() {
        if (this.isDetached) {
            this.initEditor();
            this.isDetached = false;
        }
        super.onAttach();
    }

    public void setData(String html) {
        if (this.isLoaded) {
            this._setCKData(html);
        }
    }

    public String getData() {
        if (this.isLoaded) {
            return this.getCKData();
        }
        Log.warn((String)"cKeditor is not yet loaded. getData() returns null value");
        return null;
    }

    public void clear() {
        this.setData(null);
    }

    public boolean isDirty() {
        try {
            return this.checkDirty();
        }
        catch (Exception e) {
            Log.error((String)("Error calling checkDirty() on CKEditor instance.Cause: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private native void _setCKData(String var1);

    private native String getCKData();

    public void focus() {
        this.focus = true;
    }

    public void onFocus() {
        this.field.onFocus();
    }

    public void onBlur() {
        this.field.onBlur();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void checkWCAGCompliance(String editorId) {
        CKEditorField fld = CKEditorField.getInstance(editorId);
        if (fld != null) {
            fld.checkWCAGCompliance();
        }
    }

    private native boolean initEditor();

    private native void destroyEditor();

    private native boolean checkDirty();

    private native void focusCK();
}

