/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.messages.Messages;

public abstract class AbstractMultipleField<T>
extends MultiField<List<T>> {
    private Button addFieldButton;
    private boolean allowBlank;

    AbstractMultipleField() {
        this.setOrientation(Style.Orientation.VERTICAL);
    }

    protected void onRender(Element target, int index) {
        super.onRender(target, index);
        this.addFieldButton = new Button(Messages.get("label.add"));
        this.addFieldButton.addStyleName("button-add");
        this.addFieldButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                AbstractMultipleField.this.addField(null);
                AbstractMultipleField.this.fireEvent(Events.Change, (ComponentEvent)ce);
            }
        });
        if (!this.readOnly) {
            this.lc.add((Widget)this.addFieldButton);
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                AbstractMultipleField.this.lc.setWidth(AbstractMultipleField.this.getWidth());
                for (Field field : AbstractMultipleField.this.fields) {
                    field.setWidth(AbstractMultipleField.this.getWidth());
                }
                AbstractMultipleField.this.lc.layout();
            }
        });
        this.originalValue = this.value;
        if (GXT.isAriaEnabled() && !this.allowBlank) {
            this.setAriaState("aria-required", "true");
        }
    }

    public void markInvalid(String msg) {
        super.markInvalid(msg);
        if (this.errorIcon != null) {
            this.errorIcon.addStyleName("invalid-icon");
        }
    }

    private void addField(T value) {
        this.clearInvalid();
        Field field = this.getNewField();
        field.setWidth(this.getWidth());
        if (value != null) {
            field.setValue(value);
        }
        field.setReadOnly(this.readOnly);
        this.fields.add(field);
        field.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                AbstractMultipleField.this.fireEvent(Events.Change, be);
            }
        });
        if (this.afterRender) {
            TableData data = (TableData)ComponentHelper.getLayoutData((Component)field);
            if (data == null) {
                data = new TableData();
            }
            String style = "position: static;";
            if (this.spacing > 0) {
                style = style + "paddingTop:" + this.spacing + "px;";
            }
            data.setStyle(style);
            this.lc.insert((Widget)field, this.fields.size() - 1, (LayoutData)data);
            this.lc.layout();
        }
    }

    abstract Field getNewField();

    protected boolean validateValue(String value) {
        if (this.allowBlank) {
            return super.validateValue(value);
        }
        if (!this.fields.isEmpty()) {
            for (Field field : this.fields) {
                if ("".equals(field.getRawValue())) continue;
                return super.validateValue(value);
            }
        }
        this.markInvalid(GXT.MESSAGES.textField_blankText());
        return false;
    }

    public List<T> getValue() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Field field : this.getAll()) {
            values.add(field.getValue());
        }
        return values;
    }

    public void setValue(List<T> value) {
        super.setValue(value);
        for (Field field : this.fields) {
            this.lc.remove((Widget)field);
        }
        this.fields.clear();
        for (Object t : value) {
            this.addField(t);
        }
    }

    public void setRawValue(String value) {
    }

    public void setReadOnly(boolean readOnly) {
        boolean reRender = false;
        if (this.rendered) {
            if (this.readOnly && !readOnly) {
                this.lc.add((Widget)this.addFieldButton);
                reRender = true;
            }
            if (!this.readOnly && readOnly) {
                this.lc.remove((Widget)this.addFieldButton);
                reRender = true;
            }
            reRender |= !this.fields.isEmpty();
        }
        this.readOnly = readOnly;
        for (Field field : this.fields) {
            field.setReadOnly(readOnly);
        }
        if (reRender) {
            this.lc.layout();
        }
    }

    public void setAllowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
    }
}

