/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.ProgressBar;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.Linker;

public class ContentExport
extends Window {
    public ContentExport(Linker linker, final GWTJahiaNode n) {
        this.addStyleName("content-export");
        this.setHeadingHtml(Messages.get("label.export"));
        this.setSize(500, 80);
        this.setResizable(false);
        this.setLayout((Layout)new FitLayout());
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setId("JahiaGxtContentExport");
        this.setModal(true);
        final String result = JahiaGWTParameters.getContextPath() + "/cms/export/" + JahiaGWTParameters.getWorkspace() + n.getPath();
        final ProgressBar progressBar = new ProgressBar();
        this.add((Component)progressBar);
        Button b = new Button(Messages.get("label.close"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ContentExport.this.hide();
            }
        });
        b.addStyleName("button-close");
        this.addButton(b);
        if (!n.getNodeTypes().contains("jnt:page")) {
            HorizontalPanel p = new HorizontalPanel();
            p.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
            p.add((Widget)new Text(Messages.get("label.exportChoose", "Choose export format")));
            this.add((Widget)p);
            b = new Button(Messages.get("label.exportXML", "XML content"));
            b.addStyleName("button-exportxml");
            b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    ContentExport.this.startProgress(progressBar, n);
                    com.google.gwt.user.client.Window.open((String)(result + ".xml?cleanup=simple"), (String)"", (String)"");
                }
            });
            this.addButton(b);
        }
        b = new Button(Messages.get("label.exportZip", "ZIP"));
        b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                ContentExport.this.startProgress(progressBar, n);
                Window.Location.assign((String)(result + ".zip?live=false&cleanup=simple"));
            }
        });
        b.addStyleName("button-exportzip");
        this.addButton(b);
        b = new Button(Messages.get("label.exportZipWithLive", "ZIP"));
        b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                ContentExport.this.startProgress(progressBar, n);
                Window.Location.assign((String)(result + ".zip?live=true&cleanup=simple"));
            }
        });
        b.addStyleName("button-exportziplive");
        this.addButton(b);
    }

    private void startProgress(ProgressBar progressBar, final GWTJahiaNode n) {
        progressBar.setIncrement(50);
        progressBar.auto();
        new Timer(){

            public void run() {
                String exportedNode = Cookies.getCookie((String)"exportedNode");
                if (exportedNode != null && exportedNode.equals(n.getUUID())) {
                    ContentExport.this.hide();
                    Cookies.removeCookie((String)"exportedNode", (String)"/");
                    this.cancel();
                }
            }
        }.scheduleRepeating(1000);
    }
}

