/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.NumberField;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.ColumnData;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.ExistingFileException;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;

public class ImageCrop
extends Window {
    private Linker linker;
    private boolean autoName = true;
    private TextField<String> newname;
    private ComboBox<GWTJahiaValueDisplayBean> predefinedSizesBox;
    private NumberField width;
    private NumberField height;
    private NumberField top;
    private NumberField left;

    public ImageCrop(Linker linker, final GWTJahiaNode n, List<Integer[]> predefinedSizes) {
        this.addStyleName("image-crop");
        this.setLayout((Layout)new FitLayout());
        this.setSize(712, 550);
        this.linker = linker;
        this.setHeadingHtml(Messages.get("label.crop"));
        this.setId("JahiaGxtImageCrop");
        FormData formData = new FormData("100%");
        FormPanel form = new FormPanel();
        form.setFrame(false);
        form.setHeaderVisible(false);
        form.setBorders(false);
        form.setLabelWidth(70);
        LayoutContainer main = new LayoutContainer();
        main.setLayout((Layout)new ColumnLayout());
        LayoutContainer lcName = new LayoutContainer();
        lcName.setStyleAttribute("paddingRight", "10px");
        lcName.setLayout((Layout)new FormLayout(FormPanel.LabelAlign.LEFT));
        this.newname = new TextField();
        this.newname.setName("newname");
        this.newname.setId("newname");
        this.newname.setFieldLabel(Messages.get("newName.label", "New name"));
        int extIndex = n.getName().lastIndexOf(".");
        if (extIndex > 0) {
            String dotExt = n.getName().substring(extIndex);
            this.newname.setValue((Object)n.getName().replaceAll(dotExt, "-crop" + dotExt));
        } else {
            this.newname.setValue((Object)(n.getName() + "-crop"));
        }
        this.newname.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                ImageCrop.this.autoName = false;
            }
        });
        lcName.add(this.newname, (LayoutData)formData);
        LayoutContainer lcWidth = new LayoutContainer();
        lcWidth.setStyleAttribute("paddingRight", "10px");
        FormLayout formLayout = new FormLayout(FormPanel.LabelAlign.RIGHT);
        formLayout.setLabelWidth(40);
        lcWidth.setLayout((Layout)formLayout);
        form.add((Widget)lcName, (LayoutData)new ColumnData(0.6));
        this.width = new NumberField();
        this.width.setPropertyEditorType(Integer.class);
        this.height = new NumberField();
        this.height.setPropertyEditorType(Integer.class);
        String imageWidthStr = (String)n.get("j:width");
        String imageHeightStr = (String)n.get("j:height");
        int imageWidth = 0;
        int imageHeight = 0;
        try {
            imageWidth = imageWidthStr != null ? Integer.parseInt(imageWidthStr) : 0;
            imageHeight = imageHeightStr != null ? Integer.parseInt(imageHeightStr) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (predefinedSizes != null && !predefinedSizes.isEmpty()) {
            ArrayList<GWTJahiaValueDisplayBean> sizes = new ArrayList<GWTJahiaValueDisplayBean>();
            for (Integer[] d : predefinedSizes) {
                if (imageWidth != 0 && imageWidth <= d[0] || imageHeight != 0 && imageHeight <= d[1]) continue;
                String label = d[0] + " x " + d[1];
                GWTJahiaValueDisplayBean v = new GWTJahiaValueDisplayBean(label, label);
                v.set("width", d[0]);
                v.set("height", d[1]);
                sizes.add(v);
            }
            if (!sizes.isEmpty()) {
                this.predefinedSizesBox = new ComboBox();
                this.predefinedSizesBox.setDisplayField("display");
                this.predefinedSizesBox.setStore(new ListStore());
                this.predefinedSizesBox.setForceSelection(true);
                this.predefinedSizesBox.setTriggerAction(ComboBox.TriggerAction.ALL);
                this.predefinedSizesBox.setDeferHeight(true);
                this.predefinedSizesBox.getStore().add(sizes);
                this.predefinedSizesBox.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

                    public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> se) {
                        GWTJahiaValueDisplayBean v = (GWTJahiaValueDisplayBean)se.getSelectedItem();
                        ImageCrop.this.setDimensions((Integer)v.get("width"), (Integer)v.get("height"));
                    }
                });
                this.predefinedSizesBox.setEmptyText(Messages.get("selectPredefinedSize.label", "select a predefined size"));
                main.add(this.predefinedSizesBox, (LayoutData)new ColumnData(0.6));
            }
        }
        this.width.setFieldLabel(Messages.get("width.label", "Width"));
        this.width.setName("width");
        this.width.setId("width");
        lcWidth.add((Widget)this.width, (LayoutData)formData);
        LayoutContainer lcHeight = new LayoutContainer();
        lcHeight.setStyleAttribute("paddingLeft", "10px");
        formLayout = new FormLayout(FormPanel.LabelAlign.RIGHT);
        formLayout.setLabelWidth(40);
        lcHeight.setLayout((Layout)formLayout);
        this.height.setFieldLabel(Messages.get("height.label", "Height"));
        this.height.setName("height");
        this.height.setId("height");
        lcHeight.add((Widget)this.height, (LayoutData)formData);
        main.add((Widget)lcWidth, (LayoutData)new ColumnData(0.2));
        main.add((Widget)lcHeight, (LayoutData)new ColumnData(0.2));
        form.add((Widget)main, (LayoutData)new FormData("100%"));
        Image image = new Image();
        image.addLoadHandler(new LoadHandler(){

            public void onLoad(LoadEvent event) {
                ImageCrop.this.initJcrop();
            }
        });
        image.getElement().setId("cropbox");
        image.setUrl(n.getUrl());
        form.add((Widget)image);
        this.top = new NumberField();
        this.top.setPropertyEditorType(Integer.class);
        this.top.setName("top");
        this.top.setId("top");
        this.top.setVisible(false);
        form.add((Widget)this.top);
        this.left = new NumberField();
        this.left.setPropertyEditorType(Integer.class);
        this.left.setName("left");
        this.left.setId("left");
        this.left.setVisible(false);
        form.add((Widget)this.left);
        ButtonBar buttons = new ButtonBar();
        Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ImageCrop.this.hide();
            }
        });
        cancel.addStyleName("button-cancel");
        Button submit = new Button(Messages.get("label.ok"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                if (((Number)ImageCrop.this.width.getValue()).intValue() > 0 && ((Number)ImageCrop.this.height.getValue()).intValue() > 0) {
                    ImageCrop.this.cropImage(n.getPath(), ((String)ImageCrop.this.newname.getValue()).toString(), ((Number)ImageCrop.this.top.getValue()).intValue(), ((Number)ImageCrop.this.left.getValue()).intValue(), ((Number)ImageCrop.this.width.getValue()).intValue(), ((Number)ImageCrop.this.height.getValue()).intValue(), false);
                }
            }
        });
        submit.addStyleName("button-submit");
        buttons.add((Component)cancel);
        buttons.add((Component)submit);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setBottomComponent((Component)buttons);
        Listener<ComponentEvent> listener = new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                if (ImageCrop.this.width.getValue() != null && ImageCrop.this.height.getValue() != null) {
                    ImageCrop.this.setDimensions(((Number)ImageCrop.this.width.getValue()).intValue(), ((Number)ImageCrop.this.height.getValue()).intValue());
                    if (ImageCrop.this.predefinedSizesBox != null) {
                        ImageCrop.this.predefinedSizesBox.clearSelections();
                    }
                }
            }
        };
        this.width.addListener(Events.Change, (Listener)listener);
        this.height.addListener(Events.Change, (Listener)listener);
        this.add((Component)form);
        this.setModal(true);
        this.setHeaderVisible(true);
        this.setAutoHide(false);
    }

    public void cropSelectionChanged(int x, int y, int w, int h) {
        GWTJahiaValueDisplayBean v;
        this.left.setValue((Object)x);
        this.top.setValue((Object)y);
        this.width.setRawValue(String.valueOf(w));
        this.height.setRawValue(String.valueOf(h));
        if (this.autoName) {
            String n = (String)this.newname.getValue();
            int dp = n.lastIndexOf(46);
            this.newname.setValue((Object)(n.substring(0, n.lastIndexOf("-crop")) + "-crop" + w + "x" + h + (dp != -1 ? n.substring(dp, n.length()) : "")));
        }
        GWTJahiaValueDisplayBean gWTJahiaValueDisplayBean = v = this.predefinedSizesBox != null ? (GWTJahiaValueDisplayBean)this.predefinedSizesBox.getValue() : null;
        if (v != null && (w != (Integer)v.get("width") || h != (Integer)v.get("height"))) {
            this.predefinedSizesBox.clearSelections();
        }
    }

    private native void setDimensions(int var1, int var2);

    private native void initJcrop();

    private void cropImage(final String path, final String targetName, final int top, final int left, final int width, final int height, boolean force) {
        JahiaContentManagementService.App.getInstance().cropImage(path, targetName, top, left, width, height, force, new BaseAsyncCallback<Object>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                if (throwable instanceof ExistingFileException) {
                    if (com.google.gwt.user.client.Window.confirm((String)(Messages.get("alreadyExists.label") + "\n" + Messages.get("confirm.overwrite.label")))) {
                        ImageCrop.this.cropImage(path, targetName, top, left, width, height, true);
                    }
                } else {
                    com.google.gwt.user.client.Window.alert((String)(Messages.get("failure.crop.label") + "\n" + throwable.getLocalizedMessage()));
                    Log.error((String)Messages.get("failure.crop.label"), (Throwable)throwable);
                }
            }

            public void onSuccess(Object result) {
                ImageCrop.this.hide();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshMain", true);
                ImageCrop.this.linker.refresh(data);
            }
        });
    }
}

