/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;

public class PasswordPrompt
extends Window {
    private ManagerLinker m_linker;

    public PasswordPrompt(ManagerLinker linker, String username, final String providerKey, final MenuItem item, final String logoutLabel) {
        this.addStyleName("password-prompt");
        this.m_linker = linker;
        this.setHeadingHtml(Messages.get("label.password"));
        this.setSize(500, 200);
        this.setResizable(false);
        ButtonBar buttons = new ButtonBar();
        FormPanel form = new FormPanel();
        form.setFrame(false);
        form.setHeaderVisible(false);
        form.setBorders(false);
        this.setModal(true);
        final TextField user = new TextField();
        user.setValue((Object)username);
        user.setName("label.username");
        user.setFieldLabel(Messages.get("label.username"));
        form.add((Widget)user);
        final TextField pass = new TextField();
        pass.setName("label.password");
        pass.setFieldLabel(Messages.get("label.password"));
        pass.setPassword(true);
        form.add((Widget)pass);
        Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                PasswordPrompt.this.hide();
            }
        });
        cancel.addStyleName("button-cancel");
        Button submit = new Button(Messages.get("label.ok"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                JahiaContentManagementService.App.getInstance().storePasswordForProvider(providerKey, (String)user.getValue(), (String)pass.getValue(), new BaseAsyncCallback(){

                    public void onSuccess(Object o) {
                        PasswordPrompt.this.hide();
                        item.setText(logoutLabel);
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshAll", true);
                        PasswordPrompt.this.m_linker.refresh(data);
                    }

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        Log.error((String)Messages.get("fm_fail"), (Throwable)throwable);
                        PasswordPrompt.this.hide();
                    }
                });
            }
        });
        submit.addStyleName("button-submit");
        buttons.add((Component)submit);
        buttons.add((Component)cancel);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setTopComponent((Component)buttons);
        this.add((Component)form);
    }
}

