/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.core.XTemplate;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.DomEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.IconButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.util.Point;
import com.extjs.gxt.ui.client.util.Util;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.InfoConfig;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.ToolButton;
import com.extjs.gxt.ui.client.widget.layout.AbsoluteData;
import com.extjs.gxt.ui.client.widget.layout.AbsoluteLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaChannel;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.toolbar.GWTConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.WindowUtil;
import org.jahia.ajax.gwt.client.util.content.actions.ContentActions;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.content.DeleteItemWindow;
import org.jahia.ajax.gwt.client.widget.content.util.ContentHelper;
import org.jahia.ajax.gwt.client.widget.contentengine.EditContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditContentEnginePopupListener;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineJSConfig;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.contentengine.TranslateContentEngine;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.InfoLayers;
import org.jahia.ajax.gwt.client.widget.edit.ToolbarHeader;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.AreaModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Hover;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.JavaScripObjectWrapper;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Selection;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.SimpleModule;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionContextMenu;
import org.jahia.ajax.gwt.client.widget.toolbar.action.LanguageSwitcherActionItem;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowDashboardEngine;

public class MainModule
extends Module {
    private static final String[] RESERVED_REQUESTPARAMETERS = new String[]{"channel", "variant"};
    private static MainModule module;
    private EditLinker editLinker;
    private Storage storage;
    private ActionContextMenu contextMenu;
    private GWTEditConfiguration config;
    private Map<String, GWTEditConfiguration> configs = new HashMap<String, GWTEditConfiguration>();
    private InfoLayers infoLayers = new InfoLayers();
    private Map<String, Boolean> activeLayers = new HashMap<String, Boolean>();
    private boolean ctrlActive = false;
    private static Map<Module, Selection> selections;
    private boolean needParseAfterLayout = false;
    private Map<com.google.gwt.user.client.Element, Module> moduleMap;
    protected LayoutContainer scrollContainer;
    protected LayoutContainer center;
    protected EditFrame frame;
    private com.google.gwt.user.client.Element mainModuleElement;
    protected String frameError = null;
    protected boolean frameErrorRedirect = false;
    private final LayoutContainer headContainer;
    private String newLocation = null;
    private boolean firstLoad = true;
    protected String template;
    private GWTJahiaChannel activeChannel;
    private String activeChannelVariant;
    private static boolean globalSelectionDisabled;
    protected Point framePosition = new Point(0, 0);
    boolean inframe = false;

    public MainModule(String path, String template, String nodeTypes, GWTEditConfiguration config) {
        super("main", path, nodeTypes, (Layout)new BorderLayout());
        this.setScrollMode(Style.Scroll.NONE);
        this.addStyleName("mainmodule");
        this.id = "main";
        this.path = path;
        this.template = template;
        this.config = config;
        this.configs.put(this.config.getName(), this.config);
        this.depth = 0;
        this.storage = Storage.getSessionStorageIfSupported();
        if (this.storage != null) {
            String user = this.storage.getItem("currentUser");
            if (user != null && !user.equals(JahiaGWTParameters.getCurrentUser())) {
                this.storage.clear();
            }
            this.storage.setItem("currentUser", JahiaGWTParameters.getCurrentUser());
        }
        this.head = new ToolbarHeader();
        this.head.addStyleName("x-panel-header");
        this.head.setStyleAttribute("z-index", "999");
        this.head.setStyleAttribute("position", "relative");
        this.headContainer = new LayoutContainer((Layout)new FitLayout());
        this.headContainer.addStyleName("mainmodule-head-container");
        this.headContainer.add((Widget)this.head);
        String fullscreen = Window.Location.getParameter((String)"fullscreen");
        if (fullscreen == null) {
            this.add((Widget)this.headContainer, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 32.0f));
            if (config.getMainModuleToolbar() == null || config.getMainModuleToolbar().getGwtToolbarItems().isEmpty()) {
                this.headContainer.hide();
            }
        }
        this.frame = new EditFrame();
        this.frame.setWidth("100%");
        this.frame.setHeight("100%");
        this.frame.addStyleName("x-noshim");
        this.frame.sinkEvents(32768);
        this.scrollContainer = new LayoutContainer((Layout)new FlowLayout()){

            protected void onRightClick(ComponentEvent ce) {
                if (MainModule.this.contextMenu != null && this.fireEvent(Events.ContextMenu, ce)) {
                    Point position = MainModule.getInstance().getContainer().getPosition(false);
                    final int x = ce.getClientX() + position.x;
                    final int y = ce.getClientY() + position.y;
                    ce.stopEvent();
                    DeferredCommand.addCommand((Command)new Command(){

                        public void execute() {
                            this.onShowContextMenu(x, y);
                        }
                    });
                }
            }
        };
        this.scrollContainer.addStyleName("gwt-body-edit");
        this.scrollContainer.setStyleAttribute("position", "relative");
        this.scrollContainer.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                if (MainModule.this.contextMenu != null && MainModule.this.contextMenu.isVisible()) {
                    MainModule.this.contextMenu.hide();
                }
            }
        });
        this.scrollContainer.add((Widget)this.frame);
        this.center = new LayoutContainer((Layout)new FitLayout());
        this.center.setScrollMode(Style.Scroll.NONE);
        this.add((Widget)this.center, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        Hover.getInstance().setMainModule(this);
        module = this;
        MainModule.exportStaticMethod();
    }

    public boolean isInframe() {
        return this.inframe;
    }

    public static boolean isGlobalSelectionDisabled() {
        return globalSelectionDisabled;
    }

    public Map<Module, Selection> getSelections() {
        return selections;
    }

    public GWTConfiguration.DragAndDropBehavior getDragAndDropBehavior() {
        return this.config.getDragAndDropBehavior();
    }

    public void initWithLinker(EditLinker linker) {
        this.editLinker = linker;
        ((ToolbarHeader)this.head).removeAllTools();
        if (this.config.getMainModuleToolbar() != null && !this.config.getMainModuleToolbar().getGwtToolbarItems().isEmpty()) {
            for (GWTJahiaToolbarItem item : this.config.getMainModuleToolbar().getGwtToolbarItems()) {
                ((ToolbarHeader)this.head).addItem(linker, item);
            }
            ToolButton refresh = new ToolButton("x-tool-refresh", (SelectionListener)new SelectionListener<IconButtonEvent>(){

                public void componentSelected(IconButtonEvent event) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshMain", true);
                    MainModule.this.refresh(data);
                }
            });
            this.head.addTool((Component)refresh);
            refresh.addStyleName("window-actions-refresh");
            ((ToolbarHeader)this.head).attachTools();
            this.headContainer.add((Widget)this.head);
            this.headContainer.show();
        } else {
            this.headContainer.hide();
        }
        String location = this.newLocation;
        this.newLocation = null;
        String hash = Window.Location.getHash();
        if (location == null && !hash.equals("") && hash.contains("|")) {
            location = hash.substring(hash.indexOf(124) + 1);
        }
        if (location == null) {
            location = Window.Location.getPath();
            String queryString = Window.Location.getQueryString();
            if (queryString != null && !queryString.equals("")) {
                location = location + queryString;
            }
        }
        if (location.contains("://")) {
            location = location.substring(location.indexOf("://") + 3);
            location = location.substring(location.indexOf("/"));
        }
        if (location.startsWith(JahiaGWTParameters.getContextPath() + this.config.getDefaultUrlMapping() + "/")) {
            location = location.replaceFirst(this.config.getDefaultUrlMapping(), this.config.getDefaultUrlMapping() + "frame");
        }
        if (location.contains("frame/") && !this.isValidUrl(location)) {
            String start = location.substring(0, location.indexOf("frame/"));
            start = start.substring(JahiaGWTParameters.getContextPath().length());
            location = location.replaceFirst(start + "frame/", this.config.getDefaultUrlMapping() + "frame/");
        }
        this.resetFramePosition();
        this.goToUrl(URL.decode((String)location), true, true, true);
        Listener<ComponentEvent> listener = new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent ce) {
                MainModule.this.setCtrlActive((DomEvent)ce);
                MainModule.this.makeSelected();
            }
        };
        this.scrollContainer.addListener(Events.OnClick, (Listener)listener);
        this.scrollContainer.addListener(Events.OnDoubleClick, (Listener)new EditContentEnginePopupListener(this, this.editLinker));
        if (this.config.getContextMenu() != null) {
            this.contextMenu = new ActionContextMenu(this.config.getContextMenu(), this.editLinker){

                @Override
                public boolean beforeShow() {
                    MainModule.this.makeSelected();
                    if (MainModule.this.editLinker.getSelectionContext().getSingleSelection() == MainModule.this.editLinker.getSelectionContext().getMainNode()) {
                        Module selectedModule = MainModule.this.editLinker.getSelectedModule();
                        return selectedModule != null && selectedModule instanceof SimpleModule && super.beforeShow();
                    }
                    return super.beforeShow();
                }
            };
            this.scrollContainer.setContextMenu((Menu)this.contextMenu);
        }
        this.infoLayers.initWithLinker(linker);
    }

    private boolean isValidUrl(String url) {
        return url.startsWith(JahiaGWTParameters.getContextPath() + this.config.getDefaultUrlMapping() + "frame/");
    }

    private void layoutChannel() {
        this.center.removeAll();
        if (this.activeChannel == null || "generic".equals(this.activeChannel.getValue()) || !this.config.isSupportChannelsDisplay()) {
            this.scrollContainer.setPosition(0, 0);
            this.center.setLayout((Layout)new FitLayout());
            this.center.setScrollMode(Style.Scroll.NONE);
            this.center.add((Widget)this.scrollContainer);
        } else {
            int variantIndex = this.activeChannel.getVariants().indexOf(this.activeChannelVariant);
            if (variantIndex == -1) {
                variantIndex = 0;
            }
            LayoutContainer deviceDecoratorContainer = new LayoutContainer((Layout)new AbsoluteLayout());
            deviceDecoratorContainer.setBorders(false);
            int[] decoratorImageSize = this.activeChannel.getVariantDecoratorImageSize(variantIndex);
            if (decoratorImageSize.length == 0) {
                decoratorImageSize = new int[]{-1, -1};
            }
            deviceDecoratorContainer.setSize(decoratorImageSize[0], decoratorImageSize[1]);
            deviceDecoratorContainer.setStyleAttribute("margin-left", "auto");
            deviceDecoratorContainer.setStyleAttribute("margin-right", "auto");
            AbsoluteData deviceOuterData = new AbsoluteData(0, 0);
            deviceOuterData.setMargins(new Margins(0, 0, 0, 0));
            if (this.activeChannel.getVariantDecoratorImage(variantIndex) != null) {
                deviceDecoratorContainer.add((Widget)new Image(JahiaGWTParameters.getContextPath() + this.activeChannel.getVariantDecoratorImage(variantIndex)), (LayoutData)deviceOuterData);
            }
            int[] usableResolution = this.getUsableDeviceResolution(this.activeChannel, variantIndex);
            this.scrollContainer.setSize(usableResolution[0], usableResolution[1]);
            this.scrollContainer.setScrollMode(Style.Scroll.NONE);
            int[] screenPosition = null;
            screenPosition = this.activeChannel.getVariantDecoratorScreenPosition(variantIndex);
            if (screenPosition == null || screenPosition.length == 0) {
                screenPosition = new int[]{0, 0};
            }
            AbsoluteData deviceData = new AbsoluteData(screenPosition[0], screenPosition[1]);
            deviceData.setMargins(new Margins(0, 0, 0, 0));
            deviceDecoratorContainer.add((Widget)this.scrollContainer, (LayoutData)deviceData);
            this.center.setLayout((Layout)new FlowLayout());
            this.center.setScrollMode(Style.Scroll.AUTO);
            this.center.add((Widget)deviceDecoratorContainer);
        }
    }

    private int[] getUsableDeviceResolution(GWTJahiaChannel activeChannel, int activeChannelIndex) {
        int[] usableResolution;
        if (activeChannel != null) {
            usableResolution = activeChannel.getVariantUsableResolution(activeChannelIndex);
            if (usableResolution.length == 0) {
                usableResolution = new int[]{-1, -1};
            }
        } else {
            usableResolution = new int[]{this.getWidth(), this.getHeight() - (this.head != null ? this.head.getOffsetHeight() : 0)};
        }
        return usableResolution;
    }

    public void makeSelected() {
        if (this.selectable && !MainModule.isGlobalSelectionDisabled()) {
            this.editLinker.onModuleSelection(null);
        }
    }

    public EditLinker getEditLinker() {
        return this.editLinker;
    }

    public void refresh(Map<String, Object> data) {
        if (!this.config.isRefreshEnabled()) {
            return;
        }
        if (data != null && (data.containsKey("refreshAll") || data.containsKey("refreshMain") || this.needRefresh(data))) {
            GWTJahiaNode n;
            this.saveCurrentFramePosition();
            boolean forceCssRefresh = false;
            boolean forceJavascriptRefresh = false;
            String newPath = null;
            if (data.containsKey("node") && (n = (GWTJahiaNode)data.get("node")) != null) {
                newPath = n.getPath();
                forceCssRefresh = n.getNodeTypes().contains("jnt:cssFile");
                forceJavascriptRefresh = n.getNodeTypes().contains("jnt:javascriptFile");
            }
            boolean isMainDeleted = newPath != null && data.containsKey("mainDeleted") && (Boolean)data.get("mainDeleted") != false;
            String url = this.getUrl(isMainDeleted ? newPath : this.path, this.template, this.activeChannel != null ? this.activeChannel.getValue() : null, this.activeChannelVariant, true);
            this.goToUrl(url, data.containsKey("forceImageRefresh"), forceCssRefresh, forceJavascriptRefresh);
        }
    }

    public boolean needRefresh(Map<String, Object> data) {
        GWTJahiaNode node = (GWTJahiaNode)data.get("node");
        if (node != null && node.getPath().equals(this.path)) {
            return true;
        }
        if (data.containsKey("mainDeleted") && ((Boolean)data.get("mainDeleted")).booleanValue()) {
            return true;
        }
        List paths = (List)data.get("publishedNodes");
        if (paths != null) {
            for (String s : paths) {
                List<Module> modules = ModuleHelper.getModulesByPath().get(s);
                if (modules == null || modules.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void goToUrl(String url, boolean forceImageRefresh, boolean forceCssRefresh, boolean forceJavascriptRefresh) {
        this.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
        this.setChannelFromUrl(url);
        this.layoutChannel();
        this.frame.setForceImageRefresh(forceImageRefresh);
        this.frame.setForceCssRefresh(forceCssRefresh);
        this.frame.setForceJavascriptRefresh(forceJavascriptRefresh);
        this.frame.setUrl(url);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                MainModule.this.center.layout(true);
            }
        });
    }

    public void goToSettingsUrl(String url) {
        boolean onlyHashHasChanged = false;
        if (url.contains("#") && this.frame.url.contains("#")) {
            onlyHashHasChanged = (this.frame.url.contains("#") ? this.frame.url.substring(0, this.frame.url.indexOf(35)) : this.frame.url).equals(url.contains("#") ? url.substring(0, url.indexOf(35)) : url);
        }
        if (!onlyHashHasChanged) {
            this.goToUrl(url, false, false, false);
        } else {
            this.frame.setUrl(url);
        }
    }

    private void setChannelFromUrl(String url) {
        if (this.config.isSupportChannelsDisplay()) {
            this.activeChannel = this.editLinker.getActiveChannel();
            this.activeChannelVariant = this.editLinker.getActiveChannelVariant();
            Map<String, String> params = this.getParamsFromUrl(url);
            if (params.containsKey("channel")) {
                String channelName = params.get("channel");
                for (GWTJahiaChannel gwtJahiaChannel : JahiaGWTParameters.getChannels()) {
                    if (!gwtJahiaChannel.getValue().equals(channelName)) continue;
                    this.activeChannel = gwtJahiaChannel;
                    this.activeChannelVariant = null;
                    break;
                }
                if (params.containsKey("variant")) {
                    this.activeChannelVariant = params.get("variant");
                }
            }
        } else {
            this.activeChannel = null;
            this.activeChannelVariant = null;
        }
    }

    private Map<String, String> getParamsFromUrl(String url) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (url.contains("#")) {
            url = url.substring(0, url.indexOf(35));
        }
        if (url.contains("?")) {
            String[] params;
            for (String param : params = url.substring(url.indexOf(63) + 1).split("&")) {
                if (!param.contains("=")) continue;
                String[] v = param.split("=");
                m.put(v[0], v[1]);
            }
        }
        return m;
    }

    public static void waitingMask(String text) {
        MainModule.getInstance().mask(text, "x-mask-loading");
    }

    public static void hideMask() {
        MainModule.getInstance().unmask();
    }

    public static void createContent(String path, JsArrayString nodeTypes, boolean includeSubTypes, boolean skipRefreshOnSave) {
        GWTJahiaNode parent = new GWTJahiaNode();
        parent.setPath(path);
        ContentActions.showContentWizard((Linker)MainModule.getInstance().getEditLinker(), nodeTypes != null && nodeTypes.length() > 0 ? nodeTypes.join(" ") : "jmix:droppableContent", parent, includeSubTypes, skipRefreshOnSave);
    }

    public static void editContent(String path, String displayName, JsArrayString nodeTypes, JsArrayString inheritedNodeTypes, String uuid, boolean skipRefreshOnSave, EditEngineJSConfig jsConfig) {
        GWTJahiaNode node = MainModule.getGwtJahiaNode(uuid, path, displayName, nodeTypes, inheritedNodeTypes);
        if (node.getDisplayName() != null) {
            EditLinker.setSelectionOnBodyAttributes(node);
        }
        EngineLoader.showEditEngine(MainModule.getInstance().getEditLinker(), node, null, skipRefreshOnSave, jsConfig);
    }

    public static JavaScriptObject getEditTabs(String path, String uuid, String displayName, JsArrayString nodeTypes, JsArrayString inheritedNodeTypes, boolean hasOrderableChildNodes) {
        GWTJahiaNode node = MainModule.getGwtJahiaNode(uuid, path, displayName, nodeTypes, inheritedNodeTypes);
        JSONArray editTabs = new JSONArray();
        List<GWTEngineTab> gwtEngineTabs = EditContentEngine.resolveTabs(hasOrderableChildNodes, MainModule.getInstance().getEditLinker().getConfig().getEngineConfiguration(node), node);
        for (int idx = 0; idx < gwtEngineTabs.size(); ++idx) {
            JSONObject jsonTab = new JSONObject();
            GWTEngineTab gwtEngineTab = gwtEngineTabs.get(idx);
            jsonTab.put("id", (JSONValue)new JSONString(gwtEngineTab.getId()));
            jsonTab.put("title", (JSONValue)new JSONString(gwtEngineTab.getTitle()));
            editTabs.set(idx, (JSONValue)jsonTab);
        }
        return editTabs.getJavaScriptObject();
    }

    public static void deleteContent(String uuid, String path, String displayName, JsArrayString nodeTypes, JsArrayString inheritedNodeTypes, boolean skipRefreshOnDelete, boolean deletePermanently) {
        GWTJahiaNode node = MainModule.getGwtJahiaNode(uuid, path, displayName, nodeTypes, inheritedNodeTypes);
        if (node.getDisplayName() != null) {
            EditLinker.setSelectionOnBodyAttributes(node);
        }
        EditLinker editLinker = MainModule.getInstance().getEditLinker();
        LinkerSelectionContext selectionContext = editLinker.getSelectionContext();
        selectionContext.setMainNode(node);
        selectionContext.setSelectedNodes(Collections.singletonList(node));
        selectionContext.refresh(3);
        DeleteItemWindow window = new DeleteItemWindow(editLinker, selectionContext.getSelectedNodes(), deletePermanently, skipRefreshOnDelete, JahiaGWTParameters.getBaseEditUrl());
        window.show();
    }

    public static void deleteContents(JsArray objects, boolean skipRefreshOnDelete, boolean deletePermanently) {
        EditLinker editLinker = MainModule.getInstance().getEditLinker();
        LinkerSelectionContext selectionContext = editLinker.getSelectionContext();
        List<GWTJahiaNode> nodes = MainModule.getGwtJahiaNodes(objects);
        if (nodes.size() > 0) {
            selectionContext.setMainNode(nodes.get(0));
            selectionContext.setSelectedNodes(nodes);
            selectionContext.refresh(3);
            DeleteItemWindow window = new DeleteItemWindow(editLinker, selectionContext.getSelectedNodes(), deletePermanently, skipRefreshOnDelete, JahiaGWTParameters.getBaseEditUrl());
            window.show();
        }
    }

    public static void undeleteContent(final String uuid, final String path, String displayName, final String nodeName) {
        String message = Messages.getWithArgs("message.undelete.confirm", "Do you really want to undelete the selected resource {0}?", new String[]{displayName});
        MessageBox.confirm((String)Messages.get("label.information", "Information"), (String)message, (Listener)new Listener<MessageBoxEvent>(){

            public void handleEvent(MessageBoxEvent event) {
                if (event.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                    JahiaContentManagementService.App.getInstance().undeletePaths(Collections.singletonList(path), new BaseAsyncCallback<Object>(){

                        @Override
                        public void onApplicationFailure(Throwable throwable) {
                            Log.error((String)throwable.getMessage(), (Throwable)throwable);
                            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
                        }

                        public void onSuccess(Object result) {
                            ContentHelper.sendContentModificationEvent(uuid, path, nodeName, "update", null);
                        }
                    });
                }
            }
        });
    }

    public static void undeleteContents(JsArray objects) {
        final List<GWTJahiaNode> nodes = MainModule.getGwtJahiaNodes(objects);
        String message = Messages.getWithArgs("message.undelete.multiple.confirm", "Do you really want to undelete the {0} selected resources?", new String[]{String.valueOf(nodes.size())});
        final ArrayList<String> paths = new ArrayList<String>();
        for (GWTJahiaNode node : nodes) {
            paths.add(node.getPath());
        }
        MessageBox.confirm((String)Messages.get("label.information", "Information"), (String)message, (Listener)new Listener<MessageBoxEvent>(){

            public void handleEvent(MessageBoxEvent event) {
                if (event.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                    JahiaContentManagementService.App.getInstance().undeletePaths(paths, new BaseAsyncCallback<Object>(){

                        @Override
                        public void onApplicationFailure(Throwable throwable) {
                            Log.error((String)throwable.getMessage(), (Throwable)throwable);
                            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
                        }

                        public void onSuccess(Object result) {
                            for (GWTJahiaNode node : nodes) {
                                ContentHelper.sendContentModificationEvent(node.getUUID(), node.getPath(), node.getName(), "update", null);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void redrawSelection() {
        for (Selection selection : selections.values()) {
            selection.hide();
            selection.show();
        }
    }

    public static void translateContent(String path, final String sourceLang, final String destLang, final String saveCallback) {
        TranslateContentEngine.TranslateContentEngineSaveCallback translateContentEngineSaveCallback;
        Map<String, List<Module>> modulesByPath = ModuleHelper.getModulesByPath();
        List<Module> modules = modulesByPath != null ? modulesByPath.get(path) : null;
        TranslateContentEngine.TranslateContentEngineSaveCallback translateContentEngineSaveCallback2 = translateContentEngineSaveCallback = saveCallback != null ? new TranslateContentEngine.TranslateContentEngineSaveCallback(){

            @Override
            public void onSave() {
                MainModule.doCall(saveCallback);
            }
        } : null;
        if (modules != null && modules.size() > 0) {
            MainModule.displayTranslateEngine(modules.get(0).getNode(), sourceLang, destLang, translateContentEngineSaveCallback);
        } else {
            JahiaContentManagementService.App.getInstance().getNodes(Collections.singletonList(path), GWTJahiaNode.DEFAULT_FIELDS, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                public void onSuccess(List<GWTJahiaNode> gwtJahiaNodes) {
                    if (gwtJahiaNodes.size() > 0) {
                        MainModule.displayTranslateEngine(gwtJahiaNodes.get(0), sourceLang, destLang, translateContentEngineSaveCallback);
                    }
                }
            });
        }
    }

    private static void displayTranslateEngine(GWTJahiaNode node, String sourceLang, String destLang, TranslateContentEngine.TranslateContentEngineSaveCallback saveCallback) {
        TranslateContentEngine engine = new TranslateContentEngine(node, null, JahiaGWTParameters.getLanguage(sourceLang), JahiaGWTParameters.getLanguage(destLang));
        engine.setTranslateContentEngineSaveCallback(saveCallback);
        engine.show();
    }

    private static native void doCall(String var0);

    public static void displayAlert(String title, String message) {
        MessageBox.alert((String)title, (String)message, null);
    }

    public static void displayAlertInfo(String title, String message) {
        MessageBox.info((String)title, (String)message, null);
    }

    public static void displayInfo(String title, String message, int duration) {
        InfoConfig infoConfig = new InfoConfig(title, message);
        infoConfig.display = duration;
        Info.display((InfoConfig)infoConfig);
    }

    public static void openPublicationWorkflow(JsArrayString uuids, boolean allSubTree, boolean allLanguages, boolean checkForUnpublication) {
        PublicationWorkflow.openPublicationWorkflow(MainModule.convertArray(uuids), MainModule.getInstance().getEditLinker(), allSubTree, allLanguages, checkForUnpublication);
    }

    public static void openWorkflowDashboard() {
        new WorkflowDashboardEngine(MainModule.getInstance().getEditLinker()).show();
    }

    private static GWTJahiaNode getGwtJahiaNode(JavaScriptObject object) {
        JavaScripObjectWrapper obj = new JavaScripObjectWrapper(object);
        return MainModule.getGwtJahiaNode(obj.getString("uuid"), obj.getString("path"), obj.getString("displayName"), (JsArrayString)obj.get("nodeTypes"), (JsArrayString)obj.get("inheritedNodeTypes"));
    }

    public static GWTJahiaNode getGwtJahiaNode(String uuid, String path, String displayName, JsArrayString nodeTypes, JsArrayString inheritedNodeTypes) {
        if (displayName == null) {
            List<Module> modules = ModuleHelper.getModulesByPath().get(path);
            return modules.get(0).getNode();
        }
        return MainModule.getGwtJahiaNode(uuid, path, path.substring(path.lastIndexOf("/") + 1), displayName, nodeTypes, inheritedNodeTypes);
    }

    public static GWTJahiaNode getGwtJahiaNode(String uuid, String path, String name, String displayName, JsArrayString nodeTypes, JsArrayString inheritedNodeTypes) {
        List<String> types = MainModule.convertArray(nodeTypes);
        List<String> inheritedTypes = MainModule.convertArray(inheritedNodeTypes);
        GWTJahiaNode node = new GWTJahiaNode();
        node.setName(name);
        node.setDisplayName(displayName);
        node.setUUID(uuid);
        node.setPath(path);
        node.setNodeTypes(types);
        node.setInheritedNodeTypes(inheritedTypes);
        node.setFile(types.contains("nt:file") || inheritedTypes.contains("nt:file"));
        return node;
    }

    public static List<GWTJahiaNode> getGwtJahiaNodes(JsArray objects) {
        ArrayList<GWTJahiaNode> nodes = new ArrayList<GWTJahiaNode>();
        for (int i = 0; i < objects.length(); ++i) {
            nodes.add(MainModule.getGwtJahiaNode(objects.get(i)));
        }
        return nodes;
    }

    public static List<String> convertArray(JsArrayString jsArrayString) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < jsArrayString.length(); ++i) {
            l.add(jsArrayString.get(i));
        }
        return l;
    }

    public static void switchLanguage(String lang) {
        if (lang.equals(JahiaGWTParameters.getLanguage())) {
            return;
        }
        MainModule.validateSiteLanguage(JahiaGWTParameters.getSiteNode(), lang);
        MainModule.getInstance().getEditLinker().setLocale(JahiaGWTParameters.getLanguage(lang));
    }

    public static void switchSite(String siteKey, final String lang) {
        if (siteKey.equals(JahiaGWTParameters.getSiteKey()) && lang.equals(JahiaGWTParameters.getLanguage())) {
            return;
        }
        JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList("/sites/" + siteKey), GWTJahiaNode.DEFAULT_SITE_FIELDS, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            public void onSuccess(List<GWTJahiaNode> result) {
                GWTJahiaNode siteNode = result.get(0);
                MainModule.validateSiteLanguage(siteNode, lang);
                JahiaGWTParameters.setSiteNode(siteNode);
                MainModule.getInstance().getEditLinker().setLocale(JahiaGWTParameters.getLanguage(lang));
            }
        });
    }

    private static void validateSiteLanguage(GWTJahiaNode siteNode, String lang) {
        List langs = (List)siteNode.get("j:languages");
        if (!langs.contains(lang)) {
            throw new RuntimeException("Language '" + lang + "' is not a valid '" + siteNode.getName() + "' site language");
        }
    }

    public String getUrl(String path, String template, String channel, String variant) {
        return this.getUrl(path, template, channel, variant, false);
    }

    public String getUrl(String path, String template, String channel, String variant, boolean preserveQueryString) {
        if (template != null && "default".equals(template)) {
            template = null;
        }
        StringBuilder url = new StringBuilder(this.getBaseUrl() + URL.encodePathSegment((String)path).replaceAll("%2F", "/") + (template != null && !template.equals("") ? "." + template : "") + ".html");
        if (channel != null && channel.equals("generic") && (this.editLinker.getActiveChannel() == null || this.editLinker.getActiveChannel().getValue().equals("generic"))) {
            channel = null;
            variant = null;
        } else if (channel == null && this.editLinker.getActiveChannel() != null && !this.editLinker.getActiveChannel().getValue().equals("generic")) {
            channel = this.editLinker.getActiveChannel().getValue();
            variant = this.editLinker.getActiveChannelVariant();
        }
        if (channel != null && channel.length() > 0) {
            url.append("?channel=").append(channel);
            if (variant != null && variant.length() > 0) {
                url.append("&variant=").append(variant);
            }
        }
        if (preserveQueryString) {
            MainModule.appendQueryString(url);
        }
        return url.toString();
    }

    private static void appendQueryString(StringBuilder url) {
        List<String[]> paramsToPreserve = MainModule.getQueryStringParametersToPreserve(RESERVED_REQUESTPARAMETERS);
        if (paramsToPreserve == null || paramsToPreserve.isEmpty()) {
            return;
        }
        url.append(url.indexOf("?") == -1 ? (char)'?' : '&');
        boolean first = true;
        for (String[] p : paramsToPreserve) {
            if (!first) {
                url.append('&');
            } else {
                first = false;
            }
            url.append(p[0]).append('=').append(URL.encodeQueryString((String)p[1]));
        }
    }

    private static List<String[]> getQueryStringParametersToPreserve(String ... reservedParameters) {
        String queryString = Window.Location.getQueryString();
        if (queryString == null || queryString.length() == 0 || queryString.equals("?")) {
            return null;
        }
        HashMap params = Window.Location.getParameterMap();
        if (params.isEmpty()) {
            return null;
        }
        if (reservedParameters != null && reservedParameters.length > 0) {
            params = new HashMap(params);
            for (String reserved : reservedParameters) {
                params.remove(reserved);
            }
        }
        if (params.isEmpty()) {
            return null;
        }
        ArrayList<String[]> toAppend = new ArrayList<String[]>();
        for (Map.Entry p : params.entrySet()) {
            for (String v : (List)p.getValue()) {
                toAppend.add(new String[]{(String)p.getKey(), v});
            }
        }
        return toAppend;
    }

    public String getBaseUrl() {
        String baseUrl = JahiaGWTParameters.getBaseUrl();
        baseUrl = baseUrl.substring(0, baseUrl.indexOf("/" + JahiaGWTParameters.getWorkspace() + "/"));
        baseUrl = baseUrl + "frame/" + JahiaGWTParameters.getWorkspace();
        baseUrl = baseUrl + "/" + (this.editLinker.getLocale() == null ? JahiaGWTParameters.getLanguage() : this.editLinker.getLocale());
        return baseUrl;
    }

    @Override
    public com.google.gwt.user.client.Element getInnerElement() {
        if (this.frame != null) {
            IFrameElement iframe = IFrameElement.as((Element)this.frame.getElement());
            Element body = (Element)iframe.getContentDocument().getElementsByTagName("body").getItem(0);
            return (com.google.gwt.user.client.Element)body;
        }
        return super.getInnerElement();
    }

    public static native void setDocumentTitle(String var0);

    private void refreshImages(com.google.gwt.user.client.Element element) {
        NodeList elementsByTagName = element.getElementsByTagName("img");
        if (elementsByTagName == null) {
            return;
        }
        String base = JahiaGWTParameters.getContextPath() + "/files/default/";
        String suffix = "tst=" + System.currentTimeMillis();
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element el = (Element)elementsByTagName.getItem(i);
            String url = el.getAttribute("src");
            if (url == null || !url.startsWith(base)) continue;
            el.setAttribute("src", url + (url.indexOf(63) == -1 ? "?" : "&") + suffix);
        }
    }

    private void refreshCSS(com.google.gwt.user.client.Element element) {
        NodeList elementsByTagName = element.getElementsByTagName("link");
        if (elementsByTagName == null) {
            return;
        }
        String base = JahiaGWTParameters.getContextPath() + "/modules/";
        String suffix = "tst=" + System.currentTimeMillis();
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element el = (Element)elementsByTagName.getItem(i);
            String url = el.getAttribute("href");
            String type = el.getAttribute("type");
            if (type == null || !type.equals("text/css") || url == null || !url.startsWith(base)) continue;
            el.setAttribute("href", url + (url.indexOf(63) == -1 ? "?" : "&") + suffix);
        }
    }

    private void refreshScripts(com.google.gwt.user.client.Element element) {
        NodeList elementsByTagName = element.getElementsByTagName("script");
        if (elementsByTagName == null) {
            return;
        }
        String base = JahiaGWTParameters.getContextPath() + "/modules/";
        String suffix = "tst=" + System.currentTimeMillis();
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element el = (Element)elementsByTagName.getItem(i);
            String url = el.getAttribute("src");
            String type = el.getAttribute("type");
            if (type == null || !type.equals("text/javascript") || url == null || !url.startsWith(base)) continue;
            el.setAttribute("src", url + (url.indexOf(63) == -1 ? "?" : "&") + suffix);
        }
    }

    protected void onAfterLayout() {
        super.onAfterLayout();
        if (this.needParseAfterLayout) {
            if (this.moduleMap != null) {
                ModuleHelper.move(this.moduleMap);
            }
            this.scrollContainer.setHeight(this.getHeight() - (this.head != null ? this.head.getOffsetHeight() : 0));
            this.scrollContainer.setWidth(this.getWidth());
            if (this.activeChannel != null && !"default".equals(this.activeChannel.getValue())) {
                int[] usableResolution = this.getUsableDeviceResolution(this.activeChannel, this.editLinker.getActiveChannelVariantIndex());
                this.scrollContainer.setSize(usableResolution[0], usableResolution[1]);
            }
            this.needParseAfterLayout = false;
        }
    }

    protected void onResize(int width, int height) {
        super.onResize(width, height);
        this.scrollContainer.setHeight(this.getHeight() - (this.head != null ? this.head.getOffsetHeight() : 0));
        this.scrollContainer.setWidth(this.getWidth());
        if (this.activeChannel != null && !"default".equals(this.activeChannel.getValue())) {
            int[] usableResolution = this.getUsableDeviceResolution(this.activeChannel, this.editLinker.getActiveChannelVariantIndex());
            this.scrollContainer.setSize(usableResolution[0], usableResolution[1]);
        }
        if (this.editLinker.getSelectedModule() != null) {
            MainModule.redrawSelection();
        }
    }

    @Override
    public LayoutContainer getContainer() {
        return this.scrollContainer;
    }

    public boolean isCtrlActive() {
        return this.ctrlActive;
    }

    public void setCtrlActive(DomEvent event) {
        this.ctrlActive = Window.Navigator.getPlatform().toLowerCase().contains("mac") ? DOM.eventGetMetaKey((Event)event.getEvent()) : event.isControlKey();
    }

    public void parse(List<com.google.gwt.user.client.Element> el) {
        if (this.moduleMap != null) {
            ModuleHelper.deleteAll(this.moduleMap);
            ArrayList l = new ArrayList(this.scrollContainer.getItems());
            for (Component component : l) {
                if (!(component instanceof Module)) continue;
                component.removeFromParent();
            }
        }
        this.moduleMap = ModuleHelper.parse(this, null, el);
    }

    @Override
    public String getModuleId() {
        return "main";
    }

    public static void staticGoTo(String path, String template) {
        module.goTo(path, template, null, null);
    }

    public static void staticGoTo(String path, String template, String channel, String variant) {
        module.goTo(path, template, channel, variant);
    }

    public static void staticGoToUrl(String path) {
        module.resetFramePosition();
        module.goToUrl(path, false, false, false);
    }

    public static void popState(String location, String config) {
        MainModule m = MainModule.getInstance();
        if (!config.equals(m.getConfig().getName())) {
            m.getEditLinker().switchConfig(m.configs.get(config), location + "##", true, true, null);
        } else {
            module.resetFramePosition();
            m.goToUrl(location + "##", false, false, false);
            MainModule.sendMessage("edit frame history updated", location);
        }
    }

    public void goTo(String path, String template, String channel, String variant) {
        this.resetFramePosition();
        this.goToUrl(this.getUrl(path, template, channel, variant), false, false, false);
    }

    private void updateUrlBar(String path) {
        String currentHref = Window.Location.getHref();
        if (currentHref.endsWith(path)) {
            return;
        }
        if (this.supportPushState()) {
            if (!path.endsWith("##")) {
                String pathWithoutFrame = path.replaceFirst("frame/", "/");
                if (Window.Location.getQueryString().contains("gwt.codesvr") && !pathWithoutFrame.contains("gwt.codesvr")) {
                    Map<String, String> m = this.getParamsFromUrl(Window.Location.getQueryString());
                    pathWithoutFrame = pathWithoutFrame + (pathWithoutFrame.contains("?") ? (char)'&' : '?') + "gwt.codesvr=" + m.get("gwt.codesvr");
                }
                if (!pathWithoutFrame.equals(currentHref) || this.firstLoad) {
                    this.firstLoad = false;
                    this.pushState(pathWithoutFrame, path, this.config.getName());
                }
            }
        } else {
            int hashPosition = currentHref.indexOf(35);
            if (hashPosition > 0) {
                currentHref = currentHref.substring(0, hashPosition);
            }
            Window.Location.assign((String)(currentHref + "#" + MainModule.getInstance().getConfig().getName() + "|" + URL.encode((String)path)));
        }
        path = path.substring(path.indexOf(JahiaGWTParameters.getContextPath() + JahiaGWTParameters.getServletPath()));
        if (this.storage != null) {
            String storedPath = path;
            if (storedPath.endsWith("##")) {
                storedPath = storedPath.substring(0, storedPath.length() - 2);
            }
            this.storage.setItem(MainModule.getInstance().getConfig().getName() + "_path", storedPath);
        }
    }

    public void switchLanguage(GWTJahiaLanguage language) {
        if (!language.getLanguage().equals(JahiaGWTParameters.getLanguage())) {
            this.editLinker.setLocale(language);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("refreshMain", true);
            data.put("event", "languageChanged");
            this.editLinker.refresh(data);
        }
    }

    public void switchChannel(GWTJahiaChannel channel, String variant) {
        this.editLinker.setActiveChannelVariant(variant);
        this.editLinker.setActiveChannel(channel);
        if (!this.editLinker.isInSettingsPage()) {
            this.goTo(this.path, this.template, channel.getValue(), variant);
        }
    }

    public void setNodeTypes(String nodeTypes) {
        this.nodeTypes = nodeTypes;
    }

    public void setReferenceTypes(String referenceTypes) {
        this.referenceTypes = referenceTypes;
    }

    public void setMainModuleElement(com.google.gwt.user.client.Element mainModuleElement) {
        this.mainModuleElement = mainModuleElement;
    }

    @Override
    public void setNode(GWTJahiaNode node) {
        this.mainModule = this;
        super.setNode(node);
        if (node.isMarkedForDeletion()) {
            this.overlayLabel = new HTML(Messages.get("label.deleted", "Deleted"));
            this.overlayLabel.setStyleName("deleted-overlay");
            this.overlayColorText = "#f00";
            this.opacity = "0.4";
        }
        if (node.isShared()) {
            this.setToolTip(new ToolTipConfig(Messages.get("info_important", "Important"), Messages.get("info_sharednode", "This is a shared node")));
        }
        List<String> types = node.getNodeTypes();
        List<String> inheritedTypes = node.getInheritedNodeTypes();
        this.editLinker.setInSettingsPage(!types.contains("jnt:page") && !types.contains("jnt:template") && !types.contains("jnt:content") && !inheritedTypes.contains("jnt:page") && !inheritedTypes.contains("jnt:template") && !inheritedTypes.contains("jnt:content"));
        MainModule.setDocumentTitle(Messages.get("label." + this.config.getName().substring(0, this.config.getName().length() - 4), this.config.getName()) + " - " + node.getDisplayName());
        if (this.head != null) {
            ((ToolbarHeader)this.head).handleNewMainNodeLoaded(node);
        }
        this.editLinker.handleNewMainNodeLoaded();
        if (this.head != null && this.head instanceof ToolbarHeader) {
            ((ToolbarHeader)this.head).handleNewMainNodeLoaded(node);
        }
        if (this.overlayLabel != null) {
            DOM.setStyleAttribute((Element)this.mainModuleElement, (String)"position", (String)"relative");
            this.mainModuleElement.getParentElement().insertFirst((Node)this.overlayLabel.getElement());
            this.overlayLabel.setHeight("100%");
            this.overlayLabel.setWidth("100%");
            DOM.setStyleAttribute((Element)this.mainModuleElement, (String)"opacity", (String)this.opacity);
            this.layout();
        }
    }

    public GWTEditConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(GWTEditConfiguration config, String newPath) {
        JahiaGWTParameters.changeServletMapping(this.config.getDefaultUrlMapping(), config.getDefaultUrlMapping());
        this.activeChannel = null;
        this.activeChannelVariant = null;
        String currentFrameUrl = this.frame.getCurrentFrameUrl();
        String urlPart = "frame/" + JahiaGWTParameters.getWorkspace() + "/" + (this.editLinker.getLocale() == null ? JahiaGWTParameters.getLanguage() : this.editLinker.getLocale());
        boolean canSwitchConfig = currentFrameUrl.contains(this.config.getDefaultUrlMapping() + urlPart);
        if (newPath != null) {
            this.newLocation = newPath;
        } else if (canSwitchConfig) {
            this.newLocation = currentFrameUrl.replaceFirst(this.config.getDefaultUrlMapping(), config.getDefaultUrlMapping());
        } else {
            String path = JahiaGWTParameters.getSiteNode().getSiteKey().equals("systemsite") ? config.getDefaultLocation() : JahiaGWTParameters.getSiteNode().get("homepage-path") + ".html";
            this.newLocation = currentFrameUrl.substring(0, currentFrameUrl.indexOf(this.config.getDefaultUrlMapping())) + config.getDefaultUrlMapping() + urlPart + path;
        }
        this.config = config;
        this.configs.put(this.config.getName(), this.config);
    }

    public void handleNewModuleSelection(Module selectedModule) {
        Selection l = new Selection(selectedModule);
        if (!this.ctrlActive || selectedModule == null) {
            for (Selection s : selections.values()) {
                s.hide();
            }
            selections.clear();
        }
        if (selectedModule != null && !(selectedModule instanceof MainModule)) {
            selections.put(selectedModule, l);
            l.select();
            l.show();
        }
        if (this.head != null) {
            ((ToolbarHeader)this.head).handleNewLinkerSelection();
        }
        l.layout();
    }

    public void handleNewMainSelection(String path, String template) {
        if (this.storage != null) {
            this.storage.setItem(MainModule.getInstance().getConfig().getName() + "_nodePath", path);
        }
        Object params = null;
        if ((this.path != null ? this.path.equals(path) : path == null) && (this.template != null ? this.template.equals(template) : template == null) && (this.moduleParams != null ? this.moduleParams.equals(params) : params == null)) {
            return;
        }
        this.path = path;
        this.template = template;
        this.moduleParams = params;
        if (this.head != null) {
            ((ToolbarHeader)this.head).handleNewLinkerSelection();
        }
    }

    public void setInfoLayer(String key, boolean value) {
        if (value) {
            this.activeLayers.put(key, value);
        } else {
            this.activeLayers.remove(key);
        }
        this.refreshInfoLayer();
    }

    public static void setGlobalSelectionDisabled(boolean globalSelectionDisabled) {
        MainModule.globalSelectionDisabled = globalSelectionDisabled;
    }

    public void refreshInfoLayer() {
        this.infoLayers.removeAll();
        this.handleTranslateStatus();
        if (!this.activeLayers.isEmpty()) {
            this.infoLayers.setMainModule(this);
            List<Module> modules = ModuleHelper.getModules();
            String lastUnpublished = null;
            if (modules != null) {
                for (Module m : modules) {
                    Map<GWTJahiaNode, ModelData> visibility;
                    LayoutContainer layoutContainer;
                    AbstractImagePrototype icon;
                    GWTJahiaNode currentNode;
                    if (!(m instanceof AreaModule) && m.getPath().endsWith("*") || (currentNode = m.getNode()) == null) continue;
                    ArrayList<LayoutContainer> images = new ArrayList<LayoutContainer>();
                    if (this.activeLayers.containsKey("acl") && currentNode.isHasAcl().booleanValue()) {
                        AbstractImagePrototype icon2 = ToolbarIconProvider.getInstance().getIcon("viewACLStatus");
                        LayoutContainer layoutContainer2 = new LayoutContainer((Layout)new CenterLayout());
                        layoutContainer2.add((Widget)icon2.createImage());
                        images.add(layoutContainer2);
                    }
                    if (this.activeLayers.containsKey("publication")) {
                        GWTJahiaPublicationInfo info = currentNode.getAggregatedPublicationInfo();
                        if (lastUnpublished == null || !currentNode.getPath().startsWith(lastUnpublished)) {
                            if (info.isLocked().booleanValue()) {
                                icon = ToolbarIconProvider.getInstance().getIcon("publication/locked");
                                layoutContainer = new LayoutContainer((Layout)new CenterLayout());
                                layoutContainer.add((Widget)icon.createImage());
                                images.add(layoutContainer);
                            }
                            if (info.getStatus() == 4 || info.getStatus() == 5) {
                                lastUnpublished = currentNode.getPath();
                                if (info.getStatus() == 5) {
                                    icon = ToolbarIconProvider.getInstance().getIcon("publication/unpublished");
                                    layoutContainer = new LayoutContainer((Layout)new CenterLayout());
                                    layoutContainer.add((Widget)icon.createImage());
                                    images.add(layoutContainer);
                                } else {
                                    icon = ToolbarIconProvider.getInstance().getIcon("publication/notpublished");
                                    layoutContainer = new LayoutContainer((Layout)new CenterLayout());
                                    layoutContainer.add((Widget)icon.createImage());
                                    images.add(layoutContainer);
                                }
                            } else if (info.getStatus() == 3) {
                                icon = ToolbarIconProvider.getInstance().getIcon("publication/modified");
                                layoutContainer = new LayoutContainer((Layout)new CenterLayout());
                                layoutContainer.add((Widget)icon.createImage());
                                images.add(layoutContainer);
                            } else if (info.getStatus() == 6) {
                                icon = ToolbarIconProvider.getInstance().getIcon("publication/mandatorylanguageunpublishable");
                                layoutContainer = new LayoutContainer((Layout)new CenterLayout());
                                layoutContainer.add((Widget)icon.createImage());
                                images.add(layoutContainer);
                            } else if (info.getStatus() == 10) {
                                icon = ToolbarIconProvider.getInstance().getIcon("publication/mandatorylanguagevalid");
                                layoutContainer = new LayoutContainer((Layout)new CenterLayout());
                                layoutContainer.add((Widget)icon.createImage());
                                images.add(layoutContainer);
                            }
                        }
                    }
                    if (this.activeLayers.containsKey("visibility") && !(visibility = currentNode.getVisibilityInfo()).isEmpty()) {
                        if (currentNode.isVisible().booleanValue()) {
                            icon = ToolbarIconProvider.getInstance().getIcon("visibilityStatusGreen");
                            Image image = icon.createImage();
                            LayoutContainer layoutContainer3 = new LayoutContainer((Layout)new CenterLayout());
                            layoutContainer3.add((Widget)image);
                            Set<Map.Entry<GWTJahiaNode, ModelData>> entries = visibility.entrySet();
                            StringBuilder toolTip = new StringBuilder();
                            for (Map.Entry<GWTJahiaNode, ModelData> entry : entries) {
                                if (toolTip.length() > 0) {
                                    toolTip.append("<br/>");
                                }
                                XTemplate tpl = XTemplate.create((String)((String)entry.getValue().get("xtemplate")));
                                toolTip.append(tpl.applyTemplate(Util.getJsObject((ModelData)((ModelData)entry.getKey()))));
                            }
                            layoutContainer3.setToolTip(toolTip.toString());
                            images.add(layoutContainer3);
                        } else {
                            icon = ToolbarIconProvider.getInstance().getIcon("visibilityStatusRed");
                            layoutContainer = new LayoutContainer((Layout)new CenterLayout());
                            layoutContainer.add((Widget)icon.createImage());
                            Set<Map.Entry<GWTJahiaNode, ModelData>> entries = visibility.entrySet();
                            StringBuilder toolTip = new StringBuilder();
                            for (Map.Entry<GWTJahiaNode, ModelData> entry : entries) {
                                if (toolTip.length() > 0) {
                                    toolTip.append("<br/>");
                                }
                                XTemplate tpl = XTemplate.create((String)((String)entry.getValue().get("xtemplate")));
                                toolTip.append(tpl.applyTemplate(Util.getJsObject((ModelData)((ModelData)entry.getKey()))));
                            }
                            layoutContainer.setToolTip(toolTip.toString());
                            images.add(layoutContainer);
                        }
                    }
                    if (images.isEmpty()) continue;
                    this.infoLayers.addInfoLayer(m, images, null, true, "1");
                }
            }
        }
    }

    private void handleTranslateStatus() {
        List<Module> modules = ModuleHelper.getModules();
        if (modules != null) {
            for (Module m : modules) {
                if (!(m instanceof SimpleModule)) continue;
                if (this.activeLayers.containsKey("translate")) {
                    ((SimpleModule)m).showTranslatableModule();
                    continue;
                }
                ((SimpleModule)m).hideTranslatableModule();
            }
        }
    }

    @Override
    public boolean isDraggable() {
        return false;
    }

    public static MainModule getInstance() {
        return module;
    }

    public static native void exportStaticMethod();

    public static native void exposeTopStaticMethod();

    public static native void removeTopStaticMethod();

    public InfoLayers getInfoLayers() {
        return this.infoLayers;
    }

    private native boolean supportPushState();

    private native boolean pushState(String var1, String var2, String var3);

    private static native boolean sendMessage(String var0, String var1);

    public static void refreshContent() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("refreshAll", true);
        MainModule.getInstance().getEditLinker().refresh(data);
    }

    public void goToExternalUrl(String url) {
        this.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
        this.frame.setExternalUrl(url);
    }

    private void parseFrameContent(boolean forceImageRefresh, boolean forceCssRefresh, boolean forceJavascriptRefresh) {
        try {
            this.frameError = null;
            IFrameElement iframe = IFrameElement.as((Element)this.frame.getElement());
            Document contentDocument = iframe.getContentDocument();
            com.google.gwt.user.client.Element body = (com.google.gwt.user.client.Element)contentDocument.getElementsByTagName("body").getItem(0);
            com.google.gwt.user.client.Element head = (com.google.gwt.user.client.Element)contentDocument.getElementsByTagName("head").getItem(0);
            if (forceImageRefresh) {
                this.refreshImages(body);
            }
            if (head != null) {
                if (forceCssRefresh) {
                    this.refreshCSS(head);
                }
                if (forceJavascriptRefresh) {
                    this.refreshScripts(head);
                }
            }
            Hover.getInstance().removeAll();
            List<com.google.gwt.user.client.Element> el = null;
            List<com.google.gwt.user.client.Element> elBody = null;
            if ("true".equals(body.getAttribute("jahia-parse-html"))) {
                com.google.gwt.user.client.Element innerElement = this.getInnerElement();
                elBody = ModuleHelper.getAllJahiaTypedElementsRec(body);
                el = body.equals((Object)innerElement) ? elBody : ModuleHelper.getAllJahiaTypedElementsRec(this.getInnerElement());
            } else if (body.getAttribute("jahia-error-code") != null && !"".equals(body.getAttribute("jahia-error-code"))) {
                this.frameError = body.getAttribute("jahia-error-code");
            } else {
                NodeList el1 = body.getElementsByTagName("div");
                com.google.gwt.user.client.Element e = null;
                for (int i = 0; i < el1.getLength(); ++i) {
                    e = (com.google.gwt.user.client.Element)el1.getItem(i);
                    if (!"mainmodule".equals(e.getAttribute("jahiatype"))) continue;
                    el = Arrays.asList(e);
                    elBody = Arrays.asList(e);
                    break;
                }
            }
            if (this.contextMenu != null) {
                this.contextMenu.hide();
            }
            if (el != null && elBody != null) {
                ModuleHelper.tranformLinks((com.google.gwt.user.client.Element)contentDocument.getDocumentElement());
                ModuleHelper.initAllModules(this, body, el, elBody, this.config);
                this.editLinker.getSidePanel().enable();
            } else {
                this.path = "";
                this.editLinker.getSidePanel().disable();
            }
            this.editLinker.getMainModule().unmask();
            this.needParseAfterLayout = true;
            this.layout();
        }
        catch (Exception e) {
            Log.error((String)("Error in EditFrame: " + e.getMessage()), (Throwable)e);
        }
    }

    public void resetFramePosition() {
        this.framePosition = new Point(0, 0);
    }

    public Point saveCurrentFramePosition() {
        if (!GXT.isIE10) {
            this.framePosition.x = WindowUtil.getScrollLeft(this.getInnerElement());
            this.framePosition.y = WindowUtil.getScrollTop(this.getInnerElement());
        } else {
            this.framePosition.x = this.getIE10FrameLeft();
            this.framePosition.y = this.getIE10FrameTop();
        }
        return this.framePosition;
    }

    private String getPathFromUrl(String url) {
        if (url.contains("://")) {
            url = url.substring(url.indexOf("://") + 3);
            url = url.substring(url.indexOf(47));
        }
        return url;
    }

    public String getTemplate() {
        return this.template;
    }

    public final int getIE10FrameTop() {
        return this.getIE10FrameTop(IFrameElement.as((Element)this.frame.getElement()));
    }

    public final int getIE10FrameLeft() {
        return this.getIE10FrameLeft(IFrameElement.as((Element)this.frame.getElement()));
    }

    public final void moveToSavePosition() {
        this.scrollTo(IFrameElement.as((Element)this.frame.getElement()), this.framePosition.x, this.framePosition.y);
    }

    public final native int getIE10FrameTop(IFrameElement var1);

    public final native int getIE10FrameLeft(IFrameElement var1);

    public final native void scrollTo(IFrameElement var1, int var2, int var3);

    static {
        selections = new HashMap<Module, Selection>();
        globalSelectionDisabled = false;
    }

    private class EditFrame
    extends Frame {
        private String url = null;
        private boolean forceImageRefresh = false;
        private boolean forceCssRefresh = false;
        private boolean forceJavascriptRefresh = false;

        private EditFrame() {
            super.addStyleName("window-iframe");
        }

        public void onBrowserEvent(Event event) {
            try {
                if (event.getTypeInt() == 32768) {
                    this.sendEventOnParent(IFrameElement.as((Element)MainModule.this.frame.getElement()));
                    if (MainModule.this.isValidUrl(this.url) && MainModule.this.config.isNeedFrameParsing()) {
                        final IFrameElement iframe = IFrameElement.as((Element)MainModule.this.frame.getElement());
                        Document contentDocument = iframe.getContentDocument();
                        MainModule.this.parseFrameContent(this.forceImageRefresh, this.forceCssRefresh, this.forceJavascriptRefresh);
                        GWTJahiaLanguage language = JahiaGWTParameters.getLanguage(MainModule.this.mainModuleElement.getAttribute("locale"));
                        if (language != null && !language.getLanguage().equals(JahiaGWTParameters.getLanguage())) {
                            JahiaGWTParameters.setLanguage(language);
                            MainModule.this.editLinker.setLocale(language);
                            LanguageSwitcherActionItem.setLanguage(language);
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("refreshAll", true);
                            MainModule.this.editLinker.getSidePanel().refresh(data);
                        }
                        DOM.sinkEvents((Element)((com.google.gwt.user.client.Element)contentDocument.getDocumentElement()), (int)262221);
                        DOM.setEventListener((Element)((com.google.gwt.user.client.Element)contentDocument.getDocumentElement()), (EventListener)new EventListener(){

                            public void onBrowserEvent(Event event) {
                                if (event.getTypeInt() == 64 || event.getTypeInt() == 8 || event.getTypeInt() == 4) {
                                    MainModule.this.inframe = true;
                                    Event.fireNativePreviewEvent((NativeEvent)event);
                                    MainModule.this.inframe = false;
                                } else {
                                    GWT.log((String)("event:" + event.getTypeInt()));
                                    MainModule.this.scrollContainer.onBrowserEvent(event);
                                }
                            }
                        });
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                if (MainModule.this.frameError != null && !MainModule.this.frameErrorRedirect) {
                                    MainModule.this.frameErrorRedirect = true;
                                    if (MainModule.this.frameError.equals("503")) {
                                        this.handleError503();
                                    }
                                    String currentPath = MainModule.this.node.getPath();
                                    JahiaContentManagementService.App.getInstance().getDisplayableNodePath(currentPath.substring(0, currentPath.lastIndexOf("/")), true, new AsyncCallback<String>(){

                                        public void onFailure(Throwable throwable) {
                                            EditFrame.this.setUrl(MainModule.this.getBaseUrl() + MainModule.this.config.getDefaultLocation());
                                        }

                                        public void onSuccess(String path) {
                                            if (path != null) {
                                                MainModule.staticGoTo(path, null);
                                            } else {
                                                EditFrame.this.setUrl(MainModule.this.getBaseUrl() + MainModule.this.config.getDefaultLocation());
                                            }
                                        }
                                    });
                                } else {
                                    MainModule.this.frameErrorRedirect = false;
                                    EditFrame.this.onGWTFrameReady(iframe);
                                    MainModule.this.moveToSavePosition();
                                    MainModule.this.resetFramePosition();
                                }
                            }

                            private void handleError503() {
                                MessageBox.alert((String)Messages.get("label.error.503.title", "503 - Service temporary unavailable"), (String)(Messages.get("label.error.503.description", "The server is temporarily unable to service your request due to maintenance downtime or capacity problems.") + "<br>" + Messages.get("label.error.maintenance.description", "We are sorry for the inconvenience. Please check back later.")), null);
                            }
                        });
                    } else {
                        MainModule.this.editLinker.getMainModule().unmask();
                    }
                    MainModule.this.updateUrlBar(MainModule.this.frame.getCurrentFrameUrl());
                }
            }
            catch (Exception e) {
                Log.error((String)("Error in EditFrame: " + e.getMessage()), (Throwable)e);
            }
        }

        private String getCurrentFrameUrl() {
            return this.getFrameUrl(IFrameElement.as((Element)MainModule.this.frame.getElement()));
        }

        public void setUrl(String url) {
            if (MainModule.this.isValidUrl(url = MainModule.this.getPathFromUrl(url))) {
                if (this.getElement() != null) {
                    this.url = url;
                    super.setUrl(url);
                } else {
                    this.url = url;
                }
            }
        }

        public void setExternalUrl(String url) {
            if (this.isAttached()) {
                this.url = url;
                super.setUrl(url);
            } else {
                this.url = url;
            }
        }

        public void setForceImageRefresh(boolean forceImageRefresh) {
            this.forceImageRefresh = forceImageRefresh;
        }

        public void setForceCssRefresh(boolean forceCssRefresh) {
            this.forceCssRefresh = forceCssRefresh;
        }

        public void setForceJavascriptRefresh(boolean forceJavascriptRefresh) {
            this.forceJavascriptRefresh = forceJavascriptRefresh;
        }

        protected void onAttach() {
            super.onAttach();
            IFrameElement iframe = IFrameElement.as((Element)MainModule.this.frame.getElement());
            iframe.setAttribute("frameborder", "0");
            if (this.url != null && !super.getUrl().endsWith(URL.encode((String)this.url))) {
                super.setUrl(this.url);
            }
        }

        public final native String sendEventOnParent(IFrameElement var1);

        public final native String getFrameUrl(IFrameElement var1);

        public final native String setFrameUrl(IFrameElement var1);

        public final native String onGWTFrameReady(IFrameElement var1);
    }
}

