/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.AreaModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ListModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.PlaceholderModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.SimpleModule;

public class ModuleHelper {
    private static final List<String> FIELDS = Arrays.asList("locksInfo", "permissions", "workflowInfo", "visibilityInfo", "subnodesConstraintsInfo");
    private static final List<String> FIELDS_FULL_INFO = Arrays.asList("locksInfo", "permissions", "publicationInfo", "workflowInfo", "visibilityInfo", "subnodesConstraintsInfo");
    public static final String JAHIA_TYPE = "jahiatype";
    private static final int AREA_CREATED_NOTIFICATION_DELAY_MS = 10000;
    private static List<Module> modules;
    private static String mainPath;
    private static Map<String, List<Module>> modulesByPath;
    private static Map<String, Module> modulesById;
    private static Map<String, List<String>> children;
    private static Map<String, GWTJahiaNodeType> nodeTypes;
    private static Map<String, List<String>> linkedContentInfo;
    private static Map<String, String> linkedContentInfoType;
    private static Map<String, List<SimpleModule>> simpleModules;
    private static boolean parsed;
    private static Map<String, List<? extends ModelData>> nodesAndTypes;

    public static List<com.google.gwt.user.client.Element> getAllJahiaTypedElementsRec(com.google.gwt.user.client.Element parent) {
        ArrayList<com.google.gwt.user.client.Element> list = new ArrayList<com.google.gwt.user.client.Element>();
        int nb = DOM.getChildCount((Element)parent);
        String type = DOM.getElementAttribute((Element)parent, (String)JAHIA_TYPE);
        if (type != null && type.length() > 0) {
            list.add(parent);
        }
        for (int i = 0; i < nb; ++i) {
            list.addAll(ModuleHelper.getAllJahiaTypedElementsRec(DOM.getChild((Element)parent, (int)i)));
        }
        return list;
    }

    public static void initAllModules(final MainModule mainModule, com.google.gwt.user.client.Element htmlElement, List<com.google.gwt.user.client.Element> el, List<com.google.gwt.user.client.Element> elBody, GWTEditConfiguration editModeConfig) {
        BaseModelData modelData1;
        long start = System.currentTimeMillis();
        modules = new ArrayList<Module>();
        modulesById = new HashMap<String, Module>();
        modulesByPath = new HashMap<String, List<Module>>();
        modules.add(mainModule);
        modulesById.put(mainModule.getModuleId(), mainModule);
        linkedContentInfo = new HashMap<String, List<String>>();
        linkedContentInfoType = new HashMap<String, String>();
        mainPath = null;
        String mainTemplate = null;
        HashSet<String> allNodetypes = new HashSet<String>();
        for (com.google.gwt.user.client.Element element : elBody) {
            String jahiatype = DOM.getElementAttribute((Element)element, (String)JAHIA_TYPE);
            if ("module".equals(jahiatype)) {
                List<String> moduleNodetypes;
                String id = DOM.getElementAttribute((Element)element, (String)"id");
                String type = DOM.getElementAttribute((Element)element, (String)"type");
                String path = DOM.getElementAttribute((Element)element, (String)"path");
                String nodetypes = DOM.getElementAttribute((Element)element, (String)"nodetypes");
                Module module = null;
                if (!type.equals("main")) {
                    if (type.equals("area") || type.equals("absoluteArea")) {
                        module = new AreaModule(id, path, element, type, mainModule);
                    } else if (type.equals("list")) {
                        module = new ListModule(id, path, element, mainModule);
                    } else if (type.equals("existingNode")) {
                        module = new SimpleModule(id, path, element, mainModule, false);
                        ModuleHelper.addSimpleModule(simpleModules, path, module);
                    } else if (type.equals("existingNodeWithHeader")) {
                        module = new SimpleModule(id, path, element, mainModule, true);
                        ModuleHelper.addSimpleModule(simpleModules, path, module);
                    } else if (type.equals("placeholder")) {
                        module = new PlaceholderModule(id, path, element, mainModule);
                    }
                }
                if (ModuleHelper.shouldDisplayAnyContentButton(mainModule, (moduleNodetypes = Arrays.asList(nodetypes.split(" "))).size())) {
                    allNodetypes.add("jmix:droppableContent");
                } else {
                    allNodetypes.addAll(moduleNodetypes);
                }
                if (module == null) continue;
                if (!modulesByPath.containsKey(path)) {
                    modulesByPath.put(path, new ArrayList());
                }
                modules.add(module);
                modulesByPath.get(path).add(module);
                modulesById.put(id, module);
                continue;
            }
            if ("mainmodule".equals(jahiatype)) {
                mainPath = element.getAttribute("path");
                mainTemplate = element.getAttribute("template");
                modulesByPath.put(mainPath, new ArrayList());
                modulesByPath.get(mainPath).add(mainModule);
                String nodetypes = DOM.getElementAttribute((Element)element, (String)"nodetypes");
                allNodetypes.addAll(Arrays.asList(nodetypes.split(" ")));
                mainModule.setNodeTypes(nodetypes);
                mainModule.setReferenceTypes(DOM.getElementAttribute((Element)element, (String)"referencetypes"));
                mainModule.setMainModuleElement(element);
                continue;
            }
            if (!"linkedContentInfo".equals(jahiatype)) continue;
            String linkedNode = DOM.getElementAttribute((Element)element, (String)"linkedNode");
            String node = DOM.getElementAttribute((Element)element, (String)"node");
            String type = DOM.getElementAttribute((Element)element, (String)"type");
            if (!linkedContentInfo.containsKey(linkedNode)) {
                linkedContentInfo.put(linkedNode, new ArrayList());
            }
            linkedContentInfo.get(linkedNode).add(node);
            linkedContentInfoType.put(node, type);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : modulesByPath.keySet()) {
            if (s.endsWith("*")) continue;
            list.add(s);
        }
        if (Log.isDebugEnabled()) {
            GWT.log((String)("all pathes " + list));
        }
        final String string = mainPath;
        final String fmainTemplate = mainTemplate;
        ArrayList<ModelData> params = new ArrayList<ModelData>();
        if (editModeConfig.isUseFullPublicationInfoInMainAreaModules()) {
            modelData1 = new BaseModelData();
            modelData1.set("paths", list);
            modelData1.set("fields", FIELDS_FULL_INFO);
            params.add((ModelData)modelData1);
        } else {
            list.remove(mainPath);
            modelData1 = new BaseModelData();
            modelData1.set("paths", list);
            modelData1.set("fields", FIELDS);
            params.add((ModelData)modelData1);
            BaseModelData modelData2 = new BaseModelData();
            modelData2.set("paths", Arrays.asList(mainPath));
            modelData2.set("fields", FIELDS_FULL_INFO);
            params.add((ModelData)modelData2);
        }
        parsed = false;
        nodesAndTypes = null;
        MainModule.setGlobalSelectionDisabled(true);
        JahiaContentManagementService.App.getInstance().getNodesAndTypes(params, new ArrayList<String>(allNodetypes), (AsyncCallback<Map<String, List<? extends ModelData>>>)new BaseAsyncCallback<Map<String, List<? extends ModelData>>>(){

            public void onSuccess(Map<String, List<? extends ModelData>> result) {
                if (mainPath.equals(string)) {
                    nodesAndTypes = result;
                    if (parsed) {
                        ModuleHelper.handleNodesAndTypesResult(result, mainModule, string, fmainTemplate);
                    }
                }
                MainModule.setGlobalSelectionDisabled(false);
                mainModule.getInnerElement().addClassName("nodesAndTypesLoaded");
            }

            @Override
            public void onApplicationFailure(Throwable caught) {
                Log.error((String)"Unable to get node with publication info due to:", (Throwable)caught);
            }
        });
        ModuleHelper.buildTree(mainModule, el);
        mainModule.parse(el);
        if (nodesAndTypes != null) {
            ModuleHelper.handleNodesAndTypesResult(nodesAndTypes, mainModule, string, fmainTemplate);
            MainModule.setGlobalSelectionDisabled(false);
            mainModule.getInnerElement().addClassName("nodesAndTypesLoaded");
        } else {
            parsed = true;
        }
        GWT.log((String)("Parsing : " + (System.currentTimeMillis() - start) + " ms"));
    }

    public static boolean shouldDisplayAnyContentButton(MainModule mainModule, int currentNodeTypeButtonsSize) {
        int maxNtDisplayed = mainModule.getConfig().getCreateChildrenDirectButtonsLimit() < 1 ? 5 : mainModule.getConfig().getCreateChildrenDirectButtonsLimit();
        return currentNodeTypeButtonsSize > maxNtDisplayed;
    }

    private static void handleNodesAndTypesResult(Map<String, List<? extends ModelData>> nodesAndTypes, MainModule mainModule, String fmainPath, String fmainTemplate) {
        List<? extends ModelData> types = nodesAndTypes.get("types");
        for (GWTJahiaNodeType gWTJahiaNodeType : types) {
            if (gWTJahiaNodeType == null) continue;
            nodeTypes.put(gWTJahiaNodeType.getName(), gWTJahiaNodeType);
        }
        List<? extends ModelData> nodes = nodesAndTypes.get("nodes");
        for (GWTJahiaNode gWTJahiaNode : nodes) {
            ModuleHelper.setNodeForModule(gWTJahiaNode);
        }
        for (Map.Entry<String, List<SimpleModule>> entry : simpleModules.entrySet()) {
            for (SimpleModule simpleModule : entry.getValue()) {
                simpleModule.removeAll();
            }
        }
        for (Module module : modules) {
            module.onNodeTypesLoaded();
        }
        mainModule.getEditLinker().onMainSelection(fmainPath, fmainTemplate);
        mainModule.getEditLinker().handleNewMainSelection();
        mainModule.refreshInfoLayer();
    }

    public static void setNodeForModule(GWTJahiaNode gwtJahiaNode) {
        List<Module> moduleList = modulesByPath.get(gwtJahiaNode.getPath());
        simpleModules.remove(gwtJahiaNode.getPath());
        if (moduleList != null) {
            for (Module module : moduleList) {
                module.setNode(gwtJahiaNode);
            }
        }
    }

    public static void buildTree(Module module, List<com.google.gwt.user.client.Element> el) {
        long start = System.currentTimeMillis();
        String rootId = module.getModuleId();
        com.google.gwt.user.client.Element element = module.getInnerElement();
        children = new HashMap<String, List<String>>();
        Iterator<com.google.gwt.user.client.Element> iterator = el.iterator();
        block0: while (iterator.hasNext()) {
            com.google.gwt.user.client.Element divElement;
            com.google.gwt.user.client.Element currentEl = divElement = iterator.next();
            while (currentEl != null) {
                if ((currentEl = DOM.getParent((Element)currentEl)) == element) {
                    if (!children.containsKey(rootId)) {
                        children.put(rootId, new ArrayList());
                    }
                    children.get(rootId).add(divElement.getAttribute("id"));
                    continue block0;
                }
                if (!"module".equals(currentEl.getAttribute(JAHIA_TYPE))) continue;
                String id = currentEl.getAttribute("id");
                if (!children.containsKey(id)) {
                    children.put(id, new ArrayList());
                }
                children.get(id).add(divElement.getAttribute("id"));
                continue block0;
            }
        }
        GWT.log((String)("Build tree : " + (System.currentTimeMillis() - start) + " ms"));
    }

    public static Map<com.google.gwt.user.client.Element, Module> parse(Module module, Module parent, List<com.google.gwt.user.client.Element> el) {
        HashMap<com.google.gwt.user.client.Element, Module> m = new HashMap<com.google.gwt.user.client.Element, Module>();
        GWT.log((String)("size : " + el.size()));
        for (com.google.gwt.user.client.Element divElement : el) {
            Module subModule;
            String jahiatype = DOM.getElementAttribute((Element)divElement, (String)JAHIA_TYPE);
            if (!"module".equals(jahiatype)) continue;
            String id = DOM.getElementAttribute((Element)divElement, (String)"id");
            if (!children.get(module.getModuleId()).contains(id) || (subModule = modulesById.get(id)) == null) continue;
            subModule.setDepth(module.getDepth() + 1);
            m.putAll(ModuleHelper.parse(subModule, module, ModuleHelper.getAllJahiaTypedElementsRec(subModule.getInnerElement())));
            m.put(divElement, subModule);
            divElement.setInnerHTML("");
            module.getContainer().add((Widget)subModule.getContainer());
        }
        module.setParentModule(parent);
        module.onParsed();
        return m;
    }

    public static void move(Map<com.google.gwt.user.client.Element, Module> m) {
        long start = System.currentTimeMillis();
        for (com.google.gwt.user.client.Element divElement : m.keySet()) {
            com.google.gwt.user.client.Element moduleElement = m.get(divElement).getContainer().getElement();
            divElement.setInnerHTML("");
            DOM.appendChild((Element)divElement, (Element)moduleElement);
        }
        GWT.log((String)("Move : " + (System.currentTimeMillis() - start) + " ms"));
    }

    public static void deleteAll(Map<com.google.gwt.user.client.Element, Module> m) {
        for (com.google.gwt.user.client.Element element : m.keySet()) {
            element.removeFromParent();
        }
    }

    public static List<Module> getModules() {
        return modules;
    }

    public static Map<String, List<Module>> getModulesByPath() {
        return modulesByPath;
    }

    public static Map<String, Module> getModulesById() {
        return modulesById;
    }

    public static void tranformLinks(com.google.gwt.user.client.Element htmlElement) {
        long start = System.currentTimeMillis();
        String baseUrl = JahiaGWTParameters.getBaseUrl();
        String mode = baseUrl.substring(baseUrl.indexOf("/cms/") + 5);
        String path = mode.substring(mode.indexOf("/"));
        mode = mode.substring(0, mode.indexOf("/"));
        baseUrl = JahiaGWTParameters.getContextPath() + "/cms/" + mode + "frame" + path;
        List<com.google.gwt.user.client.Element> el = ModuleHelper.getAllLinks(htmlElement);
        for (com.google.gwt.user.client.Element element : el) {
            String link = DOM.getElementAttribute((Element)element, (String)"href");
            if (!link.startsWith(baseUrl)) continue;
            DOM.setElementAttribute((Element)element, (String)"href", (String)("#" + link));
            DOM.setElementAttribute((Element)element, (String)"onclick", (String)("window.parent.goToUrl('" + link + "'); return false;"));
        }
        GWT.log((String)("Transform links : " + (System.currentTimeMillis() - start) + " ms"));
    }

    public static List<com.google.gwt.user.client.Element> getAllLinks(com.google.gwt.user.client.Element parent) {
        int nb;
        ArrayList<com.google.gwt.user.client.Element> list;
        block5: {
            list = new ArrayList<com.google.gwt.user.client.Element>();
            nb = DOM.getChildCount((Element)parent);
            if (parent.getNodeName().toUpperCase().equals("A")) {
                try {
                    String link = DOM.getElementAttribute((Element)parent, (String)"href");
                    if (link != null && link.length() > 0) {
                        list.add(parent);
                    }
                }
                catch (Exception e) {
                    if (e == null) break block5;
                    Log.error((String)e.getMessage(), (Throwable)e);
                }
            }
        }
        for (int i = 0; i < nb; ++i) {
            list.addAll(ModuleHelper.getAllLinks(DOM.getChild((Element)parent, (int)i)));
        }
        return list;
    }

    public static Map<String, List<String>> getLinkedContentInfo() {
        return linkedContentInfo;
    }

    public static Map<String, String> getLinkedContentInfoType() {
        return linkedContentInfoType;
    }

    public static GWTJahiaNodeType getNodeType(String nodeType) {
        return nodeTypes.get(nodeType);
    }

    private static void addSimpleModule(Map<String, List<SimpleModule>> simpleModules, String path, SimpleModule simpleModule) {
        if (!simpleModules.containsKey(path)) {
            simpleModules.put(path, new ArrayList());
        }
        simpleModules.get(path).add(simpleModule);
    }

    public static boolean canUseComponentForEdit(GWTJahiaNodeType nodeType) {
        Object value = nodeType.get("canUseComponentForEdit");
        return value == null || Boolean.TRUE.equals(value);
    }

    public static void checkCanUseComponentForEdit(String nodeTypeName, final CanUseComponentForEditCallback callback) {
        GWTJahiaNodeType nodeType = ModuleHelper.getNodeType(nodeTypeName);
        if (nodeType != null) {
            callback.handle(ModuleHelper.canUseComponentForEdit(nodeType));
        } else {
            JahiaContentManagementService.App.getInstance().getNodeType(nodeTypeName, (AsyncCallback<GWTJahiaNodeType>)new BaseAsyncCallback<GWTJahiaNodeType>(){

                @Override
                public void onApplicationFailure(Throwable caught) {
                    super.onApplicationFailure(caught);
                    callback.handle(false);
                }

                public void onSuccess(GWTJahiaNodeType result) {
                    if (result != null) {
                        nodeTypes.put(result.getName(), result);
                        callback.handle(ModuleHelper.canUseComponentForEdit(result));
                    } else {
                        callback.handle(false);
                    }
                }
            });
        }
    }

    static {
        nodeTypes = new HashMap<String, GWTJahiaNodeType>();
        simpleModules = new HashMap<String, List<SimpleModule>>();
    }

    public static interface CanUseComponentForEditCallback {
        public void handle(boolean var1);
    }
}

