/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import java.util.ArrayList;
import java.util.HashSet;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.edit.EditModeDragSource;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Selection;

public class SimpleModuleDragSource
extends EditModeDragSource {
    private Module module;

    public SimpleModuleDragSource(Module target) {
        super((Component)target.getContainer());
        this.module = target;
    }

    public Module getModule() {
        return this.module;
    }

    @Override
    protected void onDragEnd(DNDEvent e) {
        if (e.getStatus().getData("operationCalled") == null) {
            DOM.setStyleAttribute((Element)this.module.getHtml().getElement(), (String)"display", (String)"block");
        }
        super.onDragEnd(e);
    }

    @Override
    protected void onDragCancelled(DNDEvent dndEvent) {
        DOM.setStyleAttribute((Element)this.module.getHtml().getElement(), (String)"display", (String)"block");
        super.onDragCancelled(dndEvent);
    }

    protected void onDragStart(DNDEvent e) {
        super.onDragStart(e);
        ArrayList<GWTJahiaNode> l = new ArrayList<GWTJahiaNode>();
        MainModule mainModule = this.getModule().getMainModule();
        HashSet<Module> moduleSet = new HashSet<Module>();
        if (e.isControlKey() || mainModule.getSelections().containsKey((Object)this.module)) {
            moduleSet.addAll(mainModule.getSelections().keySet());
        }
        moduleSet.add(this.module);
        for (Module m : moduleSet) {
            Selection selection;
            if (!m.isDraggable()) continue;
            if (PermissionsUtils.isPermitted("jcr:removeNode", m.getNode()) && !m.getNode().isLocked().booleanValue()) {
                e.setCancelled(false);
                e.setData((Object)this);
                e.setOperation(DND.Operation.COPY);
                if (this.getStatusText() == null) {
                    e.getStatus().update(DOM.clone((Element)m.getHtml().getElement(), (boolean)true));
                    e.getStatus().setData("element", (Object)m.getHtml().getElement());
                    DOM.setStyleAttribute((Element)m.getHtml().getElement(), (String)"display", (String)"none");
                }
            } else {
                e.setCancelled(true);
            }
            if ((selection = mainModule.getSelections().get((Object)m)) != null) {
                selection.hide();
            }
            l.add(m.getNode());
        }
        if (!l.isEmpty()) {
            e.getStatus().setData("sourceType", (Object)"simpleModule");
            e.getStatus().setData("sourceModules", moduleSet);
            e.getStatus().setData("sourceNodes", l);
        }
    }
}

