/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.ListLoadResult;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.dnd.DragSource;
import com.extjs.gxt.ui.client.event.DNDListener;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.ListViewEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.content.ThumbsListView;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.BrowseTabItem;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.DisplayGridDragSource;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.ImageDragSource;

class ContentBrowseTabItem
extends BrowseTabItem {
    protected transient LayoutContainer contentContainer;
    protected transient ListLoader<ListLoadResult<GWTJahiaNode>> listLoader;
    protected transient ListStore<GWTJahiaNode> contentStore;
    protected transient DragSource displayGridSource;
    protected transient Grid<GWTJahiaNode> grid;
    protected transient ThumbsListView listView;
    private List<String> displayGridForTypes;

    ContentBrowseTabItem() {
    }

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.contentContainer = new LayoutContainer();
        this.contentContainer.setBorders(true);
        this.contentContainer.setScrollMode(Style.Scroll.AUTO);
        this.contentContainer.setLayout((Layout)new FitLayout());
        ArrayList<String> loadedNodeTypes = new ArrayList<String>();
        loadedNodeTypes.addAll(JCRClientUtils.FILE_NODETYPES);
        loadedNodeTypes.addAll(JCRClientUtils.CONTENT_NODETYPES);
        RpcProxy<PagingLoadResult<GWTJahiaNode>> listProxy = this.getPagingLoadResultRpcProxy(config, loadedNodeTypes);
        this.listLoader = new BaseListLoader(listProxy);
        this.listLoader.addLoadListener(new LoadListener(){

            public void loaderLoad(LoadEvent le) {
                if (!le.isCancelled()) {
                    ContentBrowseTabItem.this.contentContainer.unmask();
                }
            }
        });
        this.contentStore = new ListStore(this.listLoader);
        this.contentStore.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        }));
        this.addSelectionChangedListener();
        this.tree.setContextMenu(this.createContextMenu(config.getTreeContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.tree.getSelectionModel()));
        VBoxLayoutData contentVBoxData = new VBoxLayoutData();
        contentVBoxData.setFlex(2.0);
        if (config.getTableColumns().size() == 1) {
            this.listView = new ThumbsListView(true);
            this.listView.setStyleAttribute("overflow-x", "hidden");
            this.listView.setStore(this.contentStore);
            this.contentStore.setSortField("display");
            this.listView.addListener(Events.DoubleClick, (Listener)new Listener<ListViewEvent<GWTJahiaNode>>(){

                public void handleEvent(ListViewEvent<GWTJahiaNode> be) {
                    Window w = new Window();
                    w.addStyleName("content-browse-preview");
                    GWTJahiaNode node = (GWTJahiaNode)ContentBrowseTabItem.this.listView.getSelectionModel().getSelectedItem();
                    String text = "Preview of " + node.getDisplayName();
                    w.setHeadingHtml(text);
                    w.setScrollMode(Style.Scroll.AUTO);
                    w.setModal(true);
                    w.setClosable(true);
                    w.setMaximizable(true);
                    w.setSize(Math.max(Integer.parseInt((String)node.get("j:width")) + 60, 400), Math.max(Integer.parseInt((String)node.get("j:height")) + 80, 50));
                    w.setBlinkModal(true);
                    w.setPlain(true);
                    w.setToolTip(text);
                    w.setLayout((Layout)new CenterLayout());
                    w.add((Widget)new Image(((GWTJahiaNode)ContentBrowseTabItem.this.listView.getSelectionModel().getSelectedItem()).getUrl()));
                    w.show();
                }
            });
            this.listView.setContextMenu(this.createContextMenu(config.getTableContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.listView.getSelectionModel()));
            this.contentContainer.add((Widget)this.listView);
        } else {
            NodeColumnConfigList displayColumns = new NodeColumnConfigList(config.getTableColumns(), true);
            this.grid = new Grid(this.contentStore, new ColumnModel((List)displayColumns));
            this.grid.setAutoExpandColumn(displayColumns.getAutoExpand());
            this.contentContainer.add(this.grid);
            this.grid.setContextMenu(this.createContextMenu(config.getTableContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.grid.getSelectionModel()));
        }
        contentVBoxData = new VBoxLayoutData();
        contentVBoxData.setFlex(2.0);
        this.tab.add((Widget)this.contentContainer, (LayoutData)contentVBoxData);
        this.tab.setId("JahiaGxtContentBrowseTab");
        return this.tab;
    }

    private void addSelectionChangedListener() {
        this.tree.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                GWTJahiaNode node = (GWTJahiaNode)event.getSelectedItem();
                if (node != null) {
                    boolean displayGrid;
                    boolean bl = displayGrid = ContentBrowseTabItem.this.displayGridForTypes == null || node.getInheritedNodeTypes().stream().anyMatch(type -> ContentBrowseTabItem.this.displayGridForTypes.contains(type));
                    if (displayGrid) {
                        ContentBrowseTabItem.this.listLoader.load((Object)node);
                        ContentBrowseTabItem.this.contentContainer.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
                    } else {
                        ContentBrowseTabItem.this.contentStore.removeAll();
                    }
                    if (!node.getPath().equals(ContentBrowseTabItem.this.editLinker.getMainModule().getPath()) && node.getNodeTypes().contains("jnt:page") && ContentBrowseTabItem.this.hasPermission()) {
                        MainModule.staticGoTo(node.getPath(), null);
                    }
                } else {
                    ContentBrowseTabItem.this.contentStore.removeAll();
                }
            }
        });
    }

    private boolean hasPermission() {
        return PermissionsUtils.isPermitted("pageComposerAccess", JahiaGWTParameters.getSiteNode()) || PermissionsUtils.isPermitted("jContentAccess", JahiaGWTParameters.getSiteNode()) || PermissionsUtils.isPermitted("studioModeAccess", JahiaGWTParameters.getSiteNode());
    }

    private RpcProxy<PagingLoadResult<GWTJahiaNode>> getPagingLoadResultRpcProxy(final GWTSidePanelTab config, final List<String> loadedNodeTypes) {
        return new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object gwtJahiaFolder, AsyncCallback<PagingLoadResult<GWTJahiaNode>> listAsyncCallback) {
                if (gwtJahiaFolder != null) {
                    String path = ((GWTJahiaNode)gwtJahiaFolder).getPath();
                    Log.debug((String)("retrieving children of " + path));
                    ArrayList<String> tableColumnKeys = new ArrayList<String>(config.getTableColumnKeys());
                    tableColumnKeys.addAll(Arrays.asList("permissions", "icon", "lockable", "locked", "locksInfo"));
                    JahiaContentManagementService.App.getInstance().lsLoad(path, loadedNodeTypes, null, null, tableColumnKeys, false, -1, -1, false, null, null, false, false, listAsyncCallback);
                } else {
                    ContentBrowseTabItem.this.contentContainer.unmask();
                }
            }
        };
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        if (linker.getConfig().isDragAndDropEnabled()) {
            if (this.grid != null) {
                this.displayGridSource = new DisplayGridDragSource(this.grid);
            }
            if (this.listView != null) {
                this.displayGridSource = new ImageDragSource(this.listView);
            }
            this.displayGridSource.addDNDListener((DNDListener)this.editLinker.getDndListener());
        }
    }

    @Override
    protected boolean acceptNode(GWTJahiaNode node) {
        return node.getInheritedNodeTypes().contains("jnt:content");
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        GWTJahiaNode node;
        data.put("refreshMain", false);
        if (data.containsKey("node") && ((node = (GWTJahiaNode)data.get("node")).getNodeTypes().contains("jnt:contentFolder") || node.getInheritedNodeTypes().contains("jmix:droppableContent"))) {
            return true;
        }
        return super.needRefresh(data);
    }

    public void setDisplayGridForTypes(List<String> displayGridForTypes) {
        this.displayGridForTypes = displayGridForTypes;
    }
}

