/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.widget.edit.ContentTypeTree;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.CreateGridDragSource;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;

class CreateContentTabItem
extends SidePanelTabItem {
    private transient ContentTypeTree contentTypeTree;
    private transient CreateGridDragSource gridDragSource;
    private List<String> baseTypes = null;
    private List<String> excludedNodeTypes = null;
    private List<String> paths;

    CreateContentTabItem() {
    }

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.tab.setLayout((Layout)new FitLayout());
        this.contentTypeTree = new ContentTypeTree(config.getTreeColumns());
        this.tab.add((Widget)this.contentTypeTree);
        this.tab.setId("JahiaGxtCreateContentTab");
        return this.tab;
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        this.initExcludedNodeTypes(linker);
        this.contentTypeTree.fillStore(this.baseTypes, this.excludedNodeTypes, true);
        if (linker.getConfig().isDragAndDropEnabled()) {
            this.gridDragSource = new CreateGridDragSource((Grid<GWTJahiaNodeType>)this.contentTypeTree.getTreeGrid());
            this.gridDragSource.addDNDListener(linker.getDndListener());
        }
    }

    private void initExcludedNodeTypes(EditLinker linker) {
        this.excludedNodeTypes = new ArrayList<String>();
        if (linker.getConfig().getNonEditableTypes() != null) {
            this.excludedNodeTypes.addAll(linker.getConfig().getNonEditableTypes());
        }
        if (linker.getConfig().getNonVisibleTypes() != null) {
            this.excludedNodeTypes.addAll(linker.getConfig().getNonVisibleTypes());
        }
        if (linker.getConfig().getExcludedNodeTypes() != null) {
            this.excludedNodeTypes.addAll(linker.getConfig().getExcludedNodeTypes());
        }
    }

    public void setBaseType(String baseType) {
        this.baseTypes = Arrays.asList(baseType);
    }

    public void setBaseTypes(List<String> baseTypes) {
        this.baseTypes = baseTypes;
    }

    public void setExcludedNodeTypes(List<String> excludedNodeTypes) {
        this.excludedNodeTypes = excludedNodeTypes;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        return data.containsKey("event") && "nonEditableTypesChanged".equals(data.get("event"));
    }

    @Override
    public void doRefresh() {
        this.initExcludedNodeTypes(this.editLinker);
        this.contentTypeTree.fillStore(this.baseTypes, this.excludedNodeTypes, true);
    }
}

