/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.TreeGridEvent;
import com.extjs.gxt.ui.client.event.TreePanelEvent;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;

public class PathStorage {
    private Storage storage;
    private String storageName;
    private transient List<String> selectedPath = new ArrayList<String>();
    private transient List<String> openPath = new ArrayList<String>();

    public PathStorage(String storageName) {
        this.storage = Storage.getSessionStorageIfSupported();
        this.storageName = storageName;
        if (this.storage != null && this.storage.getItem("openPath-" + storageName) != null) {
            String openPaths = this.storage.getItem("openPath-" + storageName);
            this.openPath = new ArrayList<String>(Arrays.asList(openPaths.split("\\|")));
        }
    }

    public List<String> getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath.add(selectedPath);
    }

    public void setSelectedPath(List<String> selectedPath) {
        this.selectedPath = selectedPath;
    }

    public List<String> getOpenPath() {
        return this.openPath;
    }

    public void setOpenPath(String openPath) {
        this.openPath.add(openPath);
    }

    public void setOpenPath(List<String> openPath) {
        this.openPath = openPath;
    }

    public void addStorageListener(final TreePanel widget) {
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                widget.addListener(Events.Expand, (Listener)new Listener<TreePanelEvent>(){

                    public void handleEvent(TreePanelEvent le) {
                        GWTJahiaNode gwtJahiaNode = (GWTJahiaNode)le.getItem();
                        PathStorage.this.expand(gwtJahiaNode);
                    }
                });
                widget.addListener(Events.Collapse, (Listener)new Listener<TreePanelEvent>(){

                    public void handleEvent(TreePanelEvent el) {
                        GWTJahiaNode gwtJahiaNode = (GWTJahiaNode)el.getItem();
                        PathStorage.this.collapse(gwtJahiaNode);
                    }
                });
                widget.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

                    public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> selectionChangedEvent) {
                        if (selectionChangedEvent.getSelectedItem() != null) {
                            PathStorage.this.selectedPath = Arrays.asList(((GWTJahiaNode)selectionChangedEvent.getSelectedItem()).getPath());
                        } else {
                            PathStorage.this.selectedPath = new ArrayList();
                        }
                    }
                });
            }
        });
    }

    public void addStorageListener(final TreeGrid widget) {
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                widget.addListener(Events.Expand, (Listener)new Listener<TreeGridEvent>(){

                    public void handleEvent(TreeGridEvent le) {
                        GWTJahiaNode gwtJahiaNode = (GWTJahiaNode)le.getModel();
                        PathStorage.this.expand(gwtJahiaNode);
                    }
                });
                widget.addListener(Events.Collapse, (Listener)new Listener<TreeGridEvent>(){

                    public void handleEvent(TreeGridEvent el) {
                        GWTJahiaNode gwtJahiaNode = (GWTJahiaNode)el.getModel();
                        PathStorage.this.collapse(gwtJahiaNode);
                    }
                });
                widget.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

                    public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> selectionChangedEvent) {
                        if (selectionChangedEvent.getSelectedItem() != null) {
                            PathStorage.this.selectedPath = Arrays.asList(((GWTJahiaNode)selectionChangedEvent.getSelectedItem()).getPath());
                        } else {
                            PathStorage.this.selectedPath = new ArrayList();
                        }
                    }
                });
            }
        });
    }

    private void collapse(GWTJahiaNode gwtJahiaNode) {
        String path = gwtJahiaNode.getPath();
        this.collapsePath(path);
        if (gwtJahiaNode.get("alternativePath") != null) {
            for (String alternativePath : (List)gwtJahiaNode.get("alternativePath")) {
                this.collapsePath(alternativePath);
            }
            this.openPath.removeAll((List)gwtJahiaNode.get("alternativePath"));
        }
        Log.debug((String)("Save Path on collapse " + this.openPath));
        gwtJahiaNode.setExpandOnLoad(false);
        this.savePaths();
    }

    private void collapsePath(String path) {
        this.openPath.remove(path);
        for (String subPath : new ArrayList<String>(this.openPath)) {
            if (!subPath.startsWith(path + "/")) continue;
            this.openPath.remove(subPath);
        }
    }

    private void expand(GWTJahiaNode gwtJahiaNode) {
        String path = gwtJahiaNode.getPath();
        if (!this.openPath.contains(path)) {
            this.openPath.add(path);
        }
        if (gwtJahiaNode.get("alternativePath") != null) {
            this.openPath.addAll((List)gwtJahiaNode.get("alternativePath"));
        }
        Log.debug((String)("Save Path on expand " + this.openPath));
        gwtJahiaNode.setExpandOnLoad(true);
        this.savePaths();
    }

    public void savePaths() {
        if (this.storage != null) {
            StringBuilder openPaths = new StringBuilder();
            for (String s : this.openPath) {
                openPaths.append(s).append("|");
            }
            this.storage.setItem("openPath-" + this.storageName, openPaths.toString());
        }
    }
}

