/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.TreeGridEvent;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;

class SelectMainNodeTreeLoadListener
extends LoadListener {
    protected transient Map<String, GWTJahiaNode> nodesByPath = new HashMap<String, GWTJahiaNode>();
    protected TreeGrid<GWTJahiaNode> tree;
    protected String selectedPath = null;

    SelectMainNodeTreeLoadListener(final TreeGrid<GWTJahiaNode> tree) {
        this.tree = tree;
        tree.getTreeStore().getLoader().addLoadListener(new LoadListener(){

            public void loaderLoad(LoadEvent le) {
                this.addRecursively((List)le.getData());
                if (SelectMainNodeTreeLoadListener.this.selectedPath != null && tree.getSelectionModel().getSelectedItem() == null && SelectMainNodeTreeLoadListener.this.nodesByPath.containsKey(SelectMainNodeTreeLoadListener.this.selectedPath)) {
                    tree.getSelectionModel().setSelection(Arrays.asList(SelectMainNodeTreeLoadListener.this.nodesByPath.get(SelectMainNodeTreeLoadListener.this.selectedPath)));
                }
            }

            private void addRecursively(List<ModelData> data) {
                for (ModelData model : data) {
                    GWTJahiaNode node = (GWTJahiaNode)model;
                    SelectMainNodeTreeLoadListener.this.nodesByPath.put(node.getPath(), node);
                    this.addRecursively(node.getChildren());
                }
            }
        });
        tree.addListener(Events.Expand, (Listener)new Listener<TreeGridEvent>(){

            public void handleEvent(TreeGridEvent le) {
                if (SelectMainNodeTreeLoadListener.this.selectedPath != null && tree.getSelectionModel().getSelectedItem() == null && SelectMainNodeTreeLoadListener.this.nodesByPath.containsKey(SelectMainNodeTreeLoadListener.this.selectedPath) && tree.getStore().contains((ModelData)SelectMainNodeTreeLoadListener.this.nodesByPath.get(SelectMainNodeTreeLoadListener.this.selectedPath))) {
                    SelectMainNodeTreeLoadListener.this.tree.getSelectionModel().setSelection(Arrays.asList(SelectMainNodeTreeLoadListener.this.nodesByPath.get(SelectMainNodeTreeLoadListener.this.selectedPath)));
                }
            }
        });
    }

    public void handleNewMainSelection(String path) {
        this.selectedPath = path;
        if (!(this.tree == null || this.tree.getSelectionModel().getSelectedItem() != null && path.equals(((GWTJahiaNode)this.tree.getSelectionModel().getSelectedItem()).getPath()))) {
            if (this.nodesByPath.containsKey(path) && this.tree.getStore().contains((ModelData)this.nodesByPath.get(path))) {
                this.tree.getSelectionModel().setSelection(Arrays.asList(this.nodesByPath.get(path)));
            } else {
                this.tree.getSelectionModel().deselectAll();
            }
        }
    }
}

