/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbar;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.TreeGridClickSelectionModel;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionContextMenu;

public class SidePanelTabItem
implements Serializable {
    protected GWTSidePanelTab config;
    protected transient TabItem tab;
    protected transient EditLinker editLinker;
    protected transient Map<String, Object> autoRefreshData;
    protected transient boolean needManualRefresh;
    private transient Menu contextMenu = null;

    public TabItem create(GWTSidePanelTab sidePanelTab) {
        this.config = sidePanelTab;
        this.tab = new TabItem();
        this.tab.addStyleName("tab_" + sidePanelTab.getName());
        this.tab.setHtml("&nbsp;");
        this.tab.setIcon(ToolbarIconProvider.getInstance().getIcon(this.config.getIcon()));
        this.tab.getHeader().setToolTip(this.config.getTooltip());
        this.tab.getHeader().addStyleName("x-tab-strip-iconOnly");
        this.tab.setBorders(false);
        this.tab.setData("tabItem", (Object)this);
        return this.tab;
    }

    public void initWithLinker(EditLinker linker) {
        this.editLinker = linker;
    }

    public void markForManualRefresh(Map<String, Object> data) {
        if (data.containsKey("refreshAll") || this.needRefresh(data)) {
            this.needManualRefresh = true;
        }
    }

    public void markForAutoRefresh(Map<String, Object> data) {
        if (this.autoRefreshData == null) {
            this.autoRefreshData = new HashMap<String, Object>();
        }
        this.autoRefreshData.putAll(data);
    }

    public void refresh(Map<String, Object> data) {
        if (this.contextMenu != null) {
            this.contextMenu.hide();
        }
        if (this.editLinker != null && data != null && (data.containsKey("refreshAll") || this.needRefresh(data))) {
            this.doRefresh();
            this.autoRefreshData = null;
            this.needManualRefresh = false;
        }
    }

    public boolean needRefresh(Map<String, Object> data) {
        return false;
    }

    public void doRefresh() {
    }

    public Map<String, Object> getAutoRefreshData() {
        return this.autoRefreshData;
    }

    public boolean isNeedManualRefresh() {
        return this.needManualRefresh;
    }

    public void handleNewModuleSelection(Module selectedModule) {
    }

    public void handleNewMainSelection(String path) {
    }

    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        this.tab.setEnabled(this.config.getRequiredPermission() == null || PermissionsUtils.isPermitted(this.config.getRequiredPermission(), JahiaGWTParameters.getSiteNode()));
    }

    protected final Menu createContextMenu(GWTJahiaToolbar toolbarBean, AbstractStoreSelectionModel<GWTJahiaNode> selectionModel) {
        if (toolbarBean != null) {
            if (selectionModel instanceof TreeGridClickSelectionModel) {
                selectionModel = ((TreeGridClickSelectionModel)selectionModel).getRightClickSelectionModel();
            }
            SidePanelLinker linker = new SidePanelLinker(selectionModel);
            this.contextMenu = new ActionContextMenu(toolbarBean, linker);
            return this.contextMenu;
        }
        return null;
    }

    public void disable() {
        this.tab.disable();
    }

    public void enable() {
        this.tab.enable();
    }

    public class SidePanelLinker
    implements Linker {
        private AbstractStoreSelectionModel<GWTJahiaNode> selectionModel;
        private LinkerSelectionContext ctx;

        public SidePanelLinker(AbstractStoreSelectionModel<GWTJahiaNode> selectionModel) {
            this.selectionModel = selectionModel;
            this.ctx = new LinkerSelectionContext();
            selectionModel.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

                public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                    SidePanelLinker.this.syncSelectionContext(1);
                }
            });
            this.select(null);
        }

        @Override
        public LinkerSelectionContext getSelectionContext() {
            return this.ctx;
        }

        @Override
        public void loaded() {
            SidePanelTabItem.this.tab.unmask();
            SidePanelTabItem.this.editLinker.loaded();
        }

        @Override
        public void loading(String resource) {
            SidePanelTabItem.this.tab.mask(resource, "x-mask-loading");
            SidePanelTabItem.this.editLinker.loading(resource);
        }

        @Override
        public void refresh(Map<String, Object> data) {
            SidePanelTabItem.this.editLinker.refresh(data);
        }

        @Override
        public void select(Object o) {
        }

        @Override
        public void syncSelectionContext(int context) {
            this.ctx.setMainNode((GWTJahiaNode)this.selectionModel.getSelectedItem());
            this.ctx.setSelectedNodes(this.selectionModel.getSelectedItems());
            this.ctx.refresh(context);
        }

        @Override
        public void setSelectPathAfterDataUpdate(List<String> paths) {
        }

        @Override
        public GWTConfiguration getConfig() {
            return SidePanelTabItem.this.editLinker.getConfig();
        }

        public EditLinker getEditLinker() {
            return SidePanelTabItem.this.editLinker;
        }

        @Override
        public boolean isDisplayHiddenProperties() {
            return false;
        }
    }
}

