/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.form.tag;

import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.Util;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.List;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.form.tag.TagField;

public class AddTagContainer
extends HorizontalPanel {
    private static final int DEFAULT_AUTOCOMPLETE_LIMIT = 10;
    protected TagComboBox tagComboBox;
    protected Button addTagButton;
    protected TagField tagField;

    public AddTagContainer(TagField _tagField, String autoComplete) {
        this.tagField = _tagField;
        this.tagComboBox = new TagComboBox(autoComplete);
        this.addTagButton = new Button(Messages.get("label.add"));
        this.addTagButton.addStyleName("button-add");
        this.addTagButton.setIcon(StandardIconsProvider.STANDARD_ICONS.plusRound());
        this.addTagButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                AddTagContainer.this.addTag();
            }
        });
        this.add((Component)this.tagComboBox);
        this.add((Component)this.addTagButton);
    }

    private void addTag() {
        String tag = null;
        if (this.tagComboBox.getValue() != null) {
            tag = ((GWTJahiaValueDisplayBean)this.tagComboBox.getValue()).getValue();
        } else if (this.tagComboBox.getRawValue() != null && this.tagComboBox.getRawValue().trim().length() > 0) {
            tag = this.tagComboBox.getRawValue().trim();
        }
        if (tag != null) {
            this.tagField.addTag(tag);
            this.tagComboBox.setRawValue("");
        }
    }

    public class TagComboBox
    extends ComboBox<GWTJahiaValueDisplayBean> {
        public TagComboBox(String autoComplete) {
            this.setDisplayField("display");
            if (autoComplete != null) {
                final Long autocompleteLimit = new Integer(Util.parseInt((String)autoComplete, (int)10)).longValue();
                ListStore store = new ListStore((ListLoader)new BaseListLoader((DataProxy)new RpcProxy<List<GWTJahiaValueDisplayBean>>(){

                    protected void load(Object loadConfig, AsyncCallback<List<GWTJahiaValueDisplayBean>> asyncCallback) {
                        GWTJahiaNode site = JahiaGWTParameters.getSiteNode();
                        JahiaContentManagementService.App.getInstance().getTags(TagComboBox.this.getRawValue(), site != null ? site.getPath() : null, 1L, autocompleteLimit, 0L, true, asyncCallback);
                    }
                }));
                this.setStore(store);
                this.setTriggerAction(ComboBox.TriggerAction.ALL);
                this.setMinChars(2);
                this.setQueryDelay(100);
            } else {
                ListStore store = new ListStore();
                this.setStore(store);
            }
            this.setHideTrigger(true);
            this.addKeyListener(new KeyListener(){

                public void componentKeyPress(ComponentEvent event) {
                    if (event.getEvent().getKeyCode() == 13) {
                        AddTagContainer.this.addTag();
                    }
                }

                public void componentKeyUp(ComponentEvent event) {
                    if (event instanceof FieldEvent && ((FieldEvent)event).getField().getRawValue().length() == 0) {
                        TagComboBox.this.collapse();
                    }
                }
            });
        }
    }
}

