/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.node;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseTreeLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.data.TreeLoader;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.store.TreeStoreEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.PathStorage;

public class GWTJahiaNodeTreeFactory {
    protected String repository;
    protected List<String> paths;
    protected List<String> nodeTypes;
    protected List<String> filters;
    protected List<String> fields = GWTJahiaNode.DEFAULT_FIELDS;
    protected List<String> mimeTypes;
    private PathStorage pathStorage;
    protected TreeLoader<GWTJahiaNode> loader;
    protected TreeStore<GWTJahiaNode> store;
    private boolean checkSubchilds = false;
    private List<String> hiddenTypes = new ArrayList<String>();
    private String hiddenRegex;
    private boolean displayHiddenTypes = false;
    private boolean showOnlyNodesWithTemplates = false;

    public GWTJahiaNodeTreeFactory(List<String> paths) {
        this(paths, GWTJahiaNode.DEFAULT_FIELDS);
    }

    public GWTJahiaNodeTreeFactory(List<String> paths, List<String> fields) {
        this.paths = paths;
        this.fields = fields;
        this.repository = paths.toString();
        this.pathStorage = new PathStorage(this.repository);
        this.repository = this.repository.replace("$siteKey", JahiaGWTParameters.getSiteKey());
    }

    public GWTJahiaNodeTreeFactory(List<String> paths, boolean checkSubchilds) {
        this(paths);
        this.checkSubchilds = checkSubchilds;
    }

    public GWTJahiaNodeTreeFactory(TreeLoader<GWTJahiaNode> loader, String repository) {
        this.pathStorage = new PathStorage(repository);
        this.loader = loader;
        this.repository = repository;
    }

    public TreeLoader<GWTJahiaNode> getLoader() {
        if (this.loader == null) {
            this.loader = new GWTJahiaNodeTreeLoader((DataProxy)new GWTJahiaNodeProxy());
        }
        return this.loader;
    }

    public TreeStore<GWTJahiaNode> getStore() {
        if (this.store == null) {
            this.store = new TreeStore(this.getLoader());
            this.store.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof String && o2 instanceof String) {
                        String s1 = (String)o1;
                        String s2 = (String)o2;
                        return Collator.getInstance().localeCompare(s1, s2);
                    }
                    if (o1 instanceof Comparable && o2 instanceof Comparable) {
                        return ((Comparable)o1).compareTo(o2);
                    }
                    return 0;
                }
            }));
        }
        return this.store;
    }

    public GWTJahiaNodeTreeGrid getTreeGrid(ColumnModel cm) {
        GWTJahiaNodeTreeGrid grid = new GWTJahiaNodeTreeGrid(this.getStore(), cm);
        grid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.pathStorage.addStorageListener(grid);
        this.loader.addLoadListener((LoadListener)new LoadMaskListener((Component)grid));
        return grid;
    }

    public GWTJahiaNodeTreePanel getTreePanel() {
        GWTJahiaNodeTreePanel panel = new GWTJahiaNodeTreePanel(this.getStore());
        panel.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        panel.setAutoSelect(false);
        this.pathStorage.addStorageListener(panel);
        this.loader.addLoadListener((LoadListener)new LoadMaskListener((Component)panel));
        return panel;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setNodeTypes(List<String> nodeTypes) {
        this.nodeTypes = nodeTypes;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public void setFields(List<String> fields) {
        this.fields = new ArrayList<String>(fields);
        this.fields.add("locksInfo");
        this.fields.add("permissions");
        this.fields.add("childrenInfo");
        this.fields.add("icon");
    }

    public void setMimeTypes(List<String> mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public List<String> getSelectedPath() {
        return this.pathStorage.getSelectedPath();
    }

    public void setSelectedPath(String selectedPath) {
        this.pathStorage.setSelectedPath(selectedPath);
    }

    public void setSelectedPath(List<String> selectedPath) {
        this.pathStorage.setSelectedPath(selectedPath);
    }

    public List<String> getOpenPath() {
        return this.pathStorage.getOpenPath();
    }

    public void setOpenPath(String openPath) {
        this.pathStorage.setOpenPath(openPath);
    }

    public void setOpenPath(List<String> openPath) {
        this.pathStorage.setOpenPath(openPath);
    }

    public void setDisplayHiddenTypes(boolean displayHiddenTypes) {
        this.displayHiddenTypes = displayHiddenTypes;
    }

    public void setHiddenRegex(String hiddenRegex) {
        this.hiddenRegex = hiddenRegex;
    }

    public void setHiddenTypes(List<String> hiddenTypes) {
        this.hiddenTypes = hiddenTypes;
    }

    public void setShowOnlyNodesWithTemplates(boolean showOnlyNodesWithTemplates) {
        this.showOnlyNodesWithTemplates = showOnlyNodesWithTemplates;
    }

    public class GWTJahiaNodeTreePanel
    extends TreePanel<GWTJahiaNode> {
        GWTJahiaNodeTreePanel(TreeStore store) {
            super(store);
            this.setAutoSelect(false);
        }

        protected void onDataChanged(TreeStoreEvent<GWTJahiaNode> mTreeStoreEvent) {
            super.onDataChanged(mTreeStoreEvent);
            final GWTJahiaNode p = (GWTJahiaNode)mTreeStoreEvent.getParent();
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    if (p == null) {
                        GWTJahiaNodeTreePanel.this.expandChildren(GWTJahiaNodeTreePanel.this.store.getRootItems());
                    } else {
                        GWTJahiaNodeTreePanel.this.expandChildren(GWTJahiaNodeTreePanel.this.store.getChildren((ModelData)p));
                    }
                }
            });
        }

        private void expandChildren(List<GWTJahiaNode> children) {
            for (GWTJahiaNode child : children) {
                if (child.isExpandOnLoad()) {
                    this.setExpanded((ModelData)child, true);
                }
                if (!child.isSelectedOnLoad()) continue;
                this.getSelectionModel().select(true, (ModelData[])new GWTJahiaNode[]{child});
            }
        }
    }

    public class GWTJahiaNodeTreeGrid
    extends TreeGrid<GWTJahiaNode> {
        public GWTJahiaNodeTreeGrid(TreeStore store, ColumnModel cm) {
            super(store, cm);
        }

        protected void onDataChanged(TreeStoreEvent<GWTJahiaNode> mTreeStoreEvent) {
            super.onDataChanged(mTreeStoreEvent);
            final GWTJahiaNode p = (GWTJahiaNode)mTreeStoreEvent.getParent();
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    if (p == null) {
                        GWTJahiaNodeTreeGrid.this.expandChildren(GWTJahiaNodeTreeGrid.this.treeStore.getRootItems());
                    } else if (GWTJahiaNodeTreeGrid.this.treeStore.getChildren((ModelData)p) != null) {
                        GWTJahiaNodeTreeGrid.this.expandChildren(GWTJahiaNodeTreeGrid.this.treeStore.getChildren((ModelData)p));
                    }
                }
            });
        }

        private void expandChildren(List<GWTJahiaNode> children) {
            for (GWTJahiaNode child : children) {
                if (child.isExpandOnLoad()) {
                    this.setExpanded((ModelData)child, true);
                }
                if (!child.isSelectedOnLoad()) continue;
                this.getSelectionModel().select(true, (ModelData[])new GWTJahiaNode[]{child});
            }
        }
    }

    public class GWTJahiaNodeTreeLoader
    extends BaseTreeLoader<GWTJahiaNode> {
        GWTJahiaNodeTreeLoader(DataProxy proxy) {
            super(proxy);
        }

        public boolean hasChildren(GWTJahiaNode parent) {
            return parent.hasChildren();
        }
    }

    class GWTJahiaNodeProxy
    extends RpcProxy<List<GWTJahiaNode>> {
        GWTJahiaNodeProxy() {
        }

        protected void load(Object currentPage, final AsyncCallback<List<GWTJahiaNode>> listAsyncCallback) {
            if (currentPage == null) {
                JahiaContentManagementService.App.getInstance().getRoot(GWTJahiaNodeTreeFactory.this.paths, GWTJahiaNodeTreeFactory.this.nodeTypes, GWTJahiaNodeTreeFactory.this.mimeTypes, GWTJahiaNodeTreeFactory.this.filters, GWTJahiaNodeTreeFactory.this.fields, GWTJahiaNodeTreeFactory.this.pathStorage.getSelectedPath(), GWTJahiaNodeTreeFactory.this.pathStorage.getOpenPath(), GWTJahiaNodeTreeFactory.this.checkSubchilds, GWTJahiaNodeTreeFactory.this.displayHiddenTypes, GWTJahiaNodeTreeFactory.this.hiddenTypes, GWTJahiaNodeTreeFactory.this.hiddenRegex, false, listAsyncCallback);
            } else {
                GWTJahiaNode gwtJahiaNode = (GWTJahiaNode)currentPage;
                if (gwtJahiaNode.isExpandOnLoad()) {
                    ArrayList<GWTJahiaNode> list = new ArrayList<GWTJahiaNode>();
                    for (ModelData modelData : gwtJahiaNode.getChildren()) {
                        list.add((GWTJahiaNode)modelData);
                    }
                    listAsyncCallback.onSuccess(list);
                } else {
                    JahiaContentManagementService.App.getInstance().lsLoad(gwtJahiaNode.getPath(), GWTJahiaNodeTreeFactory.this.nodeTypes, GWTJahiaNodeTreeFactory.this.mimeTypes, GWTJahiaNodeTreeFactory.this.filters, GWTJahiaNodeTreeFactory.this.fields, GWTJahiaNodeTreeFactory.this.checkSubchilds, -1, -1, GWTJahiaNodeTreeFactory.this.displayHiddenTypes, GWTJahiaNodeTreeFactory.this.hiddenTypes, GWTJahiaNodeTreeFactory.this.hiddenRegex, false, false, (AsyncCallback<PagingLoadResult<GWTJahiaNode>>)new BaseAsyncCallback<PagingLoadResult<GWTJahiaNode>>(){

                        public void onSuccess(PagingLoadResult<GWTJahiaNode> result) {
                            listAsyncCallback.onSuccess((Object)result.getData());
                        }

                        @Override
                        public void onApplicationFailure(Throwable caught) {
                            listAsyncCallback.onFailure(caught);
                        }
                    });
                }
            }
        }
    }

    private static class LoadMaskListener
    extends LoadListener {
        private final Component grid;

        public LoadMaskListener(Component grid) {
            this.grid = grid;
        }

        public void loaderBeforeLoad(LoadEvent le) {
            this.grid.mask(Messages.get("label.loading", "Loading"), "x-mask-loading");
        }

        public void loaderLoadException(LoadEvent le) {
            this.grid.unmask();
        }

        public void loaderLoad(LoadEvent le) {
            this.grid.unmask();
        }
    }
}

