/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class ClipboardActionItem
extends BaseActionItem {
    private static ClipboardActionItem instance;
    private transient List<GWTJahiaNode> copiedStuff = new ArrayList<GWTJahiaNode>();

    protected ClipboardActionItem() {
    }

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        ClipboardActionItem.setInstance(this);
    }

    private static void setInstance(ClipboardActionItem i) {
        instance = i;
    }

    public static void setCopied(List<GWTJahiaNode> copiedNodes) {
        if (instance == null) {
            instance = new ClipboardActionItem();
        }
        ClipboardActionItem.instance.copiedStuff = copiedNodes;
        ClipboardActionItem.refreshView();
    }

    private static void refreshView() {
        if (instance == null) {
            instance = new ClipboardActionItem();
        }
        if (ClipboardActionItem.instance.linker != null) {
            Button b = (Button)instance.getTextToolItem();
            if (ClipboardActionItem.instance.copiedStuff.isEmpty()) {
                b.setEnabled(false);
                b.setMenu(null);
            } else {
                List<GWTJahiaNode> copiedNodes = ClipboardActionItem.instance.copiedStuff;
                Menu menu = new Menu();
                menu.addStyleName("clipboard-info-menu");
                b.setMenu(menu);
                MenuItem m = new MenuItem();
                m.addStyleName("clipboard-info-menu-item");
                if (copiedNodes.size() > 1) {
                    m.setText(copiedNodes.size() + " " + Messages.get("label.items", " Items"));
                } else {
                    m.setText(copiedNodes.get(0).getDisplayName());
                }
                m.setEnabled(false);
                menu.add((Component)m);
                b.setEnabled(true);
            }
        }
    }

    @Override
    public Component createNewToolItem() {
        Button b = (Button)super.createNewToolItem();
        b.setEnabled(false);
        b.setText(Messages.get("label.clipboard", "Clipboard"));
        return b;
    }
}

