/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.user.client.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class ExecuteActionItem
extends NodeTypeAwareBaseActionItem {
    private static final long serialVersionUID = -1317342305404063292L;
    public static final int STATUS_CODE_OK = 200;
    protected String action;
    protected String confirmationMessageKey;
    private Set<String> requiredNodeTypes;
    protected String parameterData;

    @Override
    public void onComponentSelection() {
        if (this.confirmationMessageKey != null) {
            MessageBox.confirm((String)Messages.get("label.information", "Information"), (String)Messages.get(this.confirmationMessageKey, "You are about to execute action " + this.action + ". Do you want to continue?"), (Listener)new Listener<MessageBoxEvent>(){

                public void handleEvent(MessageBoxEvent be) {
                    if ("yes".equalsIgnoreCase(be.getButtonClicked().getItemId())) {
                        ExecuteActionItem.this.doAction();
                    }
                }
            });
        } else {
            this.doAction();
        }
    }

    protected void doAction() {
        List<GWTJahiaNode> gwtJahiaNodes = this.linker.getSelectionContext().getMultipleSelection();
        for (GWTJahiaNode gwtJahiaNode : gwtJahiaNodes) {
            String baseURL = org.jahia.ajax.gwt.client.util.URL.getAbsoluteURL(JahiaGWTParameters.getContextPath() + "/cms/render");
            String localURL = baseURL + "/default/" + JahiaGWTParameters.getLanguage() + URL.encode((String)gwtJahiaNode.getPath());
            this.linker.loading(Messages.get("label.executing", "Executing action ..."));
            RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, localURL.replaceAll("#", "%23") + "." + this.action + ".do");
            try {
                String requestData = this.getRequestData();
                if (this.parameterData != null) {
                    String string = requestData = requestData != null && requestData.length() > 0 ? requestData + "&" + this.parameterData : this.parameterData;
                }
                if (requestData != null) {
                    builder.setHeader("Content-type", "application/x-www-form-urlencoded");
                }
                builder.setHeader("accept", "application/json");
                builder.sendRequest(requestData, new RequestCallback(){

                    public void onError(Request request, Throwable exception) {
                        Window.alert((String)"Cannot create connection");
                        ExecuteActionItem.this.linker.loaded();
                        ExecuteActionItem.this.actionExecuted(500);
                    }

                    public void onResponseReceived(Request request, Response response) {
                        if (response.getStatusCode() != 200) {
                            Window.alert((String)("Cannot contact remote server : error " + response.getStatusCode()));
                        }
                        try {
                            JSONObject jsondata = JSONParser.parseStrict((String)response.getText()).isObject();
                            if (jsondata.get("refreshData") != null) {
                                JSONObject refreshData = jsondata.get("refreshData").isObject();
                                HashMap<String, Object> data = new HashMap<String, Object>();
                                for (String s : refreshData.keySet()) {
                                    data.put(s, refreshData.get(s));
                                }
                                ExecuteActionItem.this.linker.refresh(data);
                            }
                            if (jsondata.get("messageDisplay") != null) {
                                JSONObject object = jsondata.get("messageDisplay").isObject();
                                String title = object.get("title").isString().stringValue();
                                String text = object.get("text").isString().stringValue();
                                String type = object.get("messageBoxType").isString().stringValue();
                                if ("alert".equals(type)) {
                                    MessageBox.alert((String)title, (String)text, null);
                                } else {
                                    MessageBox.info((String)title, (String)text, null);
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ExecuteActionItem.this.linker.loaded();
                        ExecuteActionItem.this.actionExecuted(response.getStatusCode());
                    }
                });
            }
            catch (RequestException requestException) {}
        }
    }

    protected void actionExecuted(int statusCode) {
    }

    protected String getRequestData() {
        return null;
    }

    @Override
    public void handleNewLinkerSelection() {
        boolean enabled;
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        boolean bl = enabled = lh.getMultipleSelection().size() > 0 && this.isNodeTypeAllowed(lh.getMultipleSelection());
        if (enabled && this.requiredNodeTypes != null && !this.requiredNodeTypes.isEmpty()) {
            for (GWTJahiaNode selected : lh.getMultipleSelection()) {
                if (selected.isNodeType(this.requiredNodeTypes)) continue;
                enabled = false;
                break;
            }
        }
        this.setEnabled(enabled);
        if (enabled) {
            super.handleNewLinkerSelection();
        }
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setConfirmationMessageKey(String confirmationMessageKey) {
        this.confirmationMessageKey = confirmationMessageKey;
    }

    public void setRequiredNodeTypes(Set<String> requiredNodeTypes) {
        this.requiredNodeTypes = requiredNodeTypes;
    }

    public void setParameters(Map<String, String> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                if (buffer.length() > 0) {
                    buffer.append("&");
                }
                buffer.append(param.getKey()).append("=").append(param.getValue());
            }
            this.parameterData = buffer.toString();
        }
    }
}

