/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.TreeGridEvent;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.edit.ContentTypeTree;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class NewViewActionItem
extends BaseActionItem {
    protected List<String> parentTypesAsList;
    private static int TEMPLATE_TYPE_FOLDER_TOKEN = 2;
    private static int VIEW_FILE_FOLDER_TOKEN = 3;
    private static final String TEMPLATE = "jnt:template";
    private static final String TEMPLATE_FILE = "jnt:templateFile";
    private static final String VIEW_FILE = "jnt:viewFile";
    private transient Map<String, GWTJahiaNodeType> fileNodeTypes;

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.parentTypesAsList = Arrays.asList("jnt:moduleVersionFolder", "jnt:nodeTypeFolder", "jnt:templateTypeFolder");
    }

    @Override
    public void onComponentSelection() {
        if (this.fileNodeTypes == null) {
            this.linker.loading(Messages.get("label.loading", "Loading"));
            JahiaContentManagementService.App.getInstance().getNodeTypes(Arrays.asList(TEMPLATE_FILE, VIEW_FILE), (AsyncCallback<List<GWTJahiaNodeType>>)new BaseAsyncCallback<List<GWTJahiaNodeType>>(){

                public void onSuccess(List<GWTJahiaNodeType> gwtJahiaNodeTypes) {
                    NewViewActionItem.this.fileNodeTypes = new HashMap();
                    for (GWTJahiaNodeType gwtJahiaNodeType : gwtJahiaNodeTypes) {
                        NewViewActionItem.this.fileNodeTypes.put(gwtJahiaNodeType.getName(), gwtJahiaNodeType);
                    }
                    NewViewActionItem.this.newView(NewViewActionItem.this.linker, true);
                }
            });
        } else {
            this.newView(this.linker, false);
        }
    }

    private void newView(final Linker linker, boolean isLoading) {
        final GWTJahiaNode selectedNode = linker.getSelectionContext().getSingleSelection();
        if (selectedNode.getNodeTypes().contains("jnt:moduleVersionFolder")) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(JahiaGWTParameters.getSiteNode().getPath());
            for (String s : (List)JahiaGWTParameters.getSiteNode().getProperties().get("j:resolvedDependencies")) {
                for (GWTJahiaNode n : JahiaGWTParameters.getSitesMap().values()) {
                    if (!n.getName().equals(s)) continue;
                    paths.add(n.getPath());
                }
            }
            if (!isLoading) {
                linker.loading(Messages.get("label.loading", "Loading"));
            }
            JahiaContentManagementService.App.getInstance().getContentTypesAsTree(Arrays.asList("nt:base"), null, true, (AsyncCallback<List<GWTJahiaNodeType>>)new BaseAsyncCallback<List<GWTJahiaNodeType>>(){

                public void onSuccess(List<GWTJahiaNodeType> result) {
                    linker.loaded();
                    final Window popup = new Window();
                    popup.addStyleName("new-view-modal");
                    popup.setHeadingHtml(Messages.get("label.addView", "Add view"));
                    popup.setHeight(400);
                    popup.setWidth(350);
                    popup.setModal(true);
                    popup.setLayout((Layout)new FillLayout());
                    ContentTypeTree contentTypeTree = new ContentTypeTree();
                    contentTypeTree.fillStore(result);
                    TreeGrid<GWTJahiaNodeType> treeGrid = contentTypeTree.getTreeGrid();
                    treeGrid.sinkEvents(3);
                    treeGrid.addListener(Events.OnDoubleClick, (Listener)new Listener<TreeGridEvent<GWTJahiaNodeType>>(){

                        public void handleEvent(TreeGridEvent<GWTJahiaNodeType> baseEvent) {
                            GWTJahiaNodeType gwtJahiaNodeType = (GWTJahiaNodeType)baseEvent.getModel();
                            if (gwtJahiaNodeType != null && linker != null) {
                                GWTJahiaNodeType engineNodeType = NewViewActionItem.TEMPLATE.equals(gwtJahiaNodeType.getName()) ? (GWTJahiaNodeType)NewViewActionItem.this.fileNodeTypes.get(NewViewActionItem.TEMPLATE_FILE) : (GWTJahiaNodeType)NewViewActionItem.this.fileNodeTypes.get(NewViewActionItem.VIEW_FILE);
                                NewViewActionItem.this.createEngine(engineNodeType, selectedNode, gwtJahiaNodeType.getName());
                                popup.hide();
                            }
                        }
                    });
                    popup.add((Widget)contentTypeTree);
                    popup.show();
                }

                @Override
                public void onFailure(Throwable caught) {
                    linker.loaded();
                    super.onFailure(caught);
                }
            });
        } else {
            if (isLoading) {
                linker.loaded();
            }
            GWTJahiaNodeType fileNodeType = TEMPLATE.equals(this.findNodeType(selectedNode)) ? this.fileNodeTypes.get(TEMPLATE_FILE) : this.fileNodeTypes.get(VIEW_FILE);
            this.createEngine(fileNodeType, selectedNode, this.findNodeType(selectedNode));
        }
    }

    private void createEngine(GWTJahiaNodeType nodeType, GWTJahiaNode selectedNode, String targetName) {
        HashMap<String, GWTJahiaNodeProperty> props = new HashMap<String, GWTJahiaNodeProperty>();
        props.put("nodeTypeName", new GWTJahiaNodeProperty("nodeTypeName", targetName));
        EngineLoader.showCreateEngine(this.linker, selectedNode, nodeType, props, targetName.replaceAll(":", "_"), false, null);
    }

    @Override
    public void handleNewLinkerSelection() {
        boolean enabled;
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        GWTJahiaNode n = lh.getSingleSelection();
        boolean bl = enabled = !"".equals(n.getChildConstraints().trim()) && !lh.isLocked() && this.hasPermission(lh.getSelectionPermissions()) && PermissionsUtils.isPermitted("jcr:addChildNodes", lh.getSelectionPermissions());
        if (enabled) {
            String title = this.getGwtToolbarItem().getTitle();
            if (n.isNodeType("jnt:moduleVersionFolder")) {
                this.updateTitle(title);
            } else {
                String nodetype = this.findNodeType(n);
                if (nodetype.equals("")) {
                    enabled = false;
                } else {
                    this.updateTitle(title + (!nodetype.equals("") ? " : " + nodetype : ""));
                }
            }
        }
        this.setEnabled(enabled);
    }

    private String findNodeType(GWTJahiaNode n) {
        String[] splittedPath = n.getPath().split("/");
        if (n.isNodeType("jnt:nodeTypeFolder")) {
            return n.getName().replace("_", ":");
        }
        if (splittedPath.length > TEMPLATE_TYPE_FOLDER_TOKEN && n.isNodeType("jnt:templateTypeFolder")) {
            return splittedPath[splittedPath.length - TEMPLATE_TYPE_FOLDER_TOKEN].replace("_", ":");
        }
        if (splittedPath.length > VIEW_FILE_FOLDER_TOKEN && (n.isNodeType(VIEW_FILE) || n.isNodeType(TEMPLATE_FILE))) {
            return splittedPath[splittedPath.length - VIEW_FILE_FOLDER_TOKEN].replace("_", ":");
        }
        if (n.isNodeType("jnt:nodeType")) {
            return n.getName();
        }
        return "";
    }
}

