/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HtmlContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class NodePathActionItem
extends BaseActionItem {
    private transient Text text;
    private transient HtmlContainer container;

    @Override
    public Component getCustomItem() {
        this.text = new Text("");
        this.text.setTagName("span");
        this.container = new HtmlContainer("<span class='node-path-title'>" + Messages.get("label.currentPagePath", "Current page path") + ": </span><span class='x-current-page-path node-path-text'></span>");
        this.container.setStyleName("node-path-container");
        this.container.addStyleName(this.getGwtToolbarItem().getClassName());
        this.container.addStyleName("action-bar-menu-item");
        this.container.add((Widget)this.text, ".node-path-text");
        return this.container;
    }

    @Override
    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        MainModule mainModule;
        HTML overlayLabel;
        String path = node.getPath();
        if (path.startsWith("/sites/" + node.getSiteKey())) {
            path = path.substring(node.getSiteKey().length() + 8);
        }
        this.text.addStyleName("node-path-text-inner");
        this.text.setStyleAttribute("color", "");
        this.text.setText(path);
        if (this.container.isRendered()) {
            this.container.getElement().setAttribute("data-nodedisplayname", node.getDisplayName());
            this.container.getElement().setAttribute("data-nodepath", node.getPath());
        }
        if (this.linker instanceof EditLinker && (overlayLabel = (mainModule = ((EditLinker)this.linker).getMainModule()).getOverlayLabel()) != null) {
            this.text.setStyleAttribute("color", mainModule.getOverlayColorText());
            this.text.setText(this.text.getText() + " (" + overlayLabel.getText() + ")");
        }
    }
}

