/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.util.content.CopyPasteEngine;
import org.jahia.ajax.gwt.client.util.content.actions.ContentActions;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.edit.ContentTypeWindow;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class PasteReferenceActionItem
extends BaseActionItem {
    protected transient List<String> allowedRefs;

    @Override
    public void onComponentSelection() {
        if (CopyPasteEngine.getInstance().getCopiedNodes().size() == 1) {
            GWTJahiaNode copiedNode = CopyPasteEngine.getInstance().getCopiedNodes().get(0);
            HashMap<String, GWTJahiaNodeProperty> props = new HashMap<String, GWTJahiaNodeProperty>(2);
            props.put("jcr:title", new GWTJahiaNodeProperty("jcr:title", new GWTJahiaNodePropertyValue(copiedNode.getDisplayName(), 1)));
            props.put("j:node", new GWTJahiaNodeProperty("j:node", new GWTJahiaNodePropertyValue(copiedNode, 10)));
            ContentTypeWindow.createContent(this.linker, copiedNode.getName(), this.allowedRefs, props, this.linker.getSelectionContext().getSingleSelection(), true, false);
        } else {
            ContentActions.pasteReference(this.linker);
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        boolean b = false;
        if (!CopyPasteEngine.getInstance().getCopiedNodes().isEmpty()) {
            LinkerSelectionContext lh = this.linker.getSelectionContext();
            b = lh.getSingleSelection() != null && !lh.isLocked() && this.hasPermission(lh.getSelectionPermissions()) && PermissionsUtils.isPermitted("jcr:addChildNodes", lh.getSelectionPermissions()) && lh.isPasteAllowed();
            String refTypes = null;
            if (this.linker instanceof EditLinker && b) {
                Module module = ((EditLinker)this.linker).getSelectedModule();
                refTypes = module.getReferenceTypes();
            } else if (lh.getSingleSelection() != null) {
                refTypes = (String)lh.getSingleSelection().get("referenceTypes");
            }
            if (refTypes != null && refTypes.length() > 0) {
                String[] refs = refTypes.split(" ");
                this.allowedRefs = new ArrayList<String>();
                for (String ref : refs) {
                    String[] types = ref.split("\\[|\\]");
                    if (types[1] != null && Arrays.asList(types[1].split(" |,")).contains("jnt:contentReference")) {
                        this.allowedRefs.add("jnt:contentReference");
                        break;
                    }
                    if (!this.checkNodeType(CopyPasteEngine.getInstance().getCopiedNodes(), types[1])) continue;
                    this.allowedRefs.add(types[0]);
                }
                if (this.allowedRefs.size() == 0) {
                    b = false;
                }
            } else {
                b = false;
            }
        }
        this.setEnabled(b);
    }

    private boolean checkNodeType(List<GWTJahiaNode> sources, String nodetypes) {
        boolean allowed = true;
        if (nodetypes != null && nodetypes.length() > 0) {
            if (sources != null) {
                String[] allowedTypes = nodetypes.split(" |,");
                for (GWTJahiaNode source : sources) {
                    boolean nodeAllowed = false;
                    for (String type : allowedTypes) {
                        if (!source.getNodeTypes().contains(type) && !source.getInheritedNodeTypes().contains(type)) continue;
                        nodeAllowed = true;
                        break;
                    }
                    allowed &= nodeAllowed;
                }
            }
        } else {
            allowed = false;
        }
        return allowed;
    }
}

