/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class SiteSwitcherActionItem
extends BaseActionItem {
    private static List<SiteSwitcherActionItem> instances = new ArrayList<SiteSwitcherActionItem>();
    private transient LayoutContainer mainComponent;
    private transient ComboBox<GWTJahiaNode> sitesCombo;
    private boolean filterOnAvailableSources = false;
    private List<String> root = Arrays.asList("/sites/*");
    private boolean filterEditModeBlockedSites = false;

    public void setRoot(List<String> root) {
        this.root = root;
    }

    public boolean isFilterOnAvailableSources() {
        return this.filterOnAvailableSources;
    }

    public void setFilterOnAvailableSources(boolean filterOnAvailableSources) {
        this.filterOnAvailableSources = filterOnAvailableSources;
    }

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.mainComponent = this.isFilterOnAvailableSources() ? new VerticalPanel() : new HorizontalPanel();
        instances.add(this);
        this.createSitesCombo();
        this.mainComponent.add(this.sitesCombo);
        this.mainComponent.addStyleName(this.getGwtToolbarItem().getClassName());
        this.mainComponent.addStyleName("action-bar-menu-item");
        this.refreshSitesList(linker);
    }

    public static void reloadAndRefreshAllSitesList(String sitesLocation, final Linker linker) {
        JahiaContentManagementService.App.getInstance().getRoot(Arrays.asList(sitesLocation), Arrays.asList("jnt:virtualsite"), null, null, GWTJahiaNode.DEFAULT_SITEMAP_FIELDS, null, null, false, false, null, null, false, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            public void onSuccess(List<GWTJahiaNode> result) {
                HashMap<String, GWTJahiaNode> sitesMap = new HashMap<String, GWTJahiaNode>();
                for (GWTJahiaNode aSite : result) {
                    sitesMap.put(aSite.getSiteUUID(), aSite);
                }
                JahiaGWTParameters.setSitesMap(sitesMap);
                SiteSwitcherActionItem.refreshAllSitesList(linker);
            }
        });
    }

    public static void refreshAllSitesList(Linker linker) {
        for (SiteSwitcherActionItem instance : instances) {
            instance.refreshSitesList(linker);
        }
    }

    private void refreshSitesList(final Linker linker) {
        ArrayList<GWTJahiaNode> sites = new ArrayList<GWTJahiaNode>();
        for (GWTJahiaNode n : JahiaGWTParameters.getSitesMap().values()) {
            if (this.filterEditModeBlockedSites && (n.get("editModeBlocked") == null || ((Boolean)n.get("editModeBlocked")).booleanValue()) || this.filterOnAvailableSources && n.get("j:sourcesFolder") == null) continue;
            sites.add(n);
        }
        this.sitesCombo.removeAllListeners();
        this.sitesCombo.getStore().removeAll();
        this.sitesCombo.setValue(null);
        this.sitesCombo.getStore().add(sites);
        LinkedHashSet<String> siteNames = new LinkedHashSet<String>();
        for (GWTJahiaNode site : sites) {
            String displayName = site.getDisplayName();
            if (siteNames.contains(site.getDisplayName())) {
                displayName = displayName + " (" + site.getSiteKey() + ")";
            }
            if (site.get("j:versionInfo") != null) {
                displayName = displayName + " (" + site.get("j:versionInfo") + ")";
            }
            site.set("switcherDisplayName", displayName);
            siteNames.add(site.getDisplayName());
            if (!site.getUUID().equals(JahiaGWTParameters.getSiteUUID())) continue;
            this.sitesCombo.setValue((ModelData)site);
        }
        this.sitesCombo.getStore().sort("switcherDisplayName", Style.SortDir.ASC);
        this.sitesCombo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                GWTJahiaNode jahiaNode;
                EditLinker editLinker = null;
                if (linker instanceof EditLinker) {
                    editLinker = (EditLinker)linker;
                } else if (linker instanceof SidePanelTabItem.SidePanelLinker) {
                    editLinker = ((SidePanelTabItem.SidePanelLinker)linker).getEditLinker();
                }
                if (event.getSelection().size() == 0) {
                    GWTJahiaNode node = null;
                    for (GWTJahiaNode currentNode : JahiaGWTParameters.getSitesMap().values()) {
                        if (!currentNode.getPath().equals("/sites/systemsite")) continue;
                        node = currentNode;
                        break;
                    }
                    jahiaNode = node;
                } else {
                    jahiaNode = (GWTJahiaNode)event.getSelection().get(0);
                }
                final EditLinker finalEditLinker = editLinker;
                JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList(jahiaNode.getPath()), GWTJahiaNode.DEFAULT_SITE_FIELDS, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                    public void onSuccess(List<GWTJahiaNode> result) {
                        GWTJahiaNode siteNode = result.get(0);
                        if (finalEditLinker != null && siteNode.get("j:languages") != null && ((List)siteNode.get("j:languages")).size() > 0 && !((List)siteNode.get("j:languages")).contains(JahiaGWTParameters.getLanguage()) && siteNode.get("j:defaultLanguage") != null) {
                            finalEditLinker.setLocale((GWTJahiaLanguage)((Object)siteNode.get("j:defaultLanguage")));
                        }
                        JahiaGWTParameters.setSiteNode(siteNode);
                        if (finalEditLinker != null && finalEditLinker.getSidePanel() != null) {
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("refreshAll", true);
                            finalEditLinker.getSidePanel().refresh(data);
                        }
                        if (((String)SiteSwitcherActionItem.this.root.get(0)).startsWith("/modules")) {
                            if (!siteNode.getPath().equals("/sites/systemsite")) {
                                MainModule.staticGoTo(siteNode.getPath(), null);
                            } else if (finalEditLinker != null) {
                                finalEditLinker.handleNewMainSelection();
                            }
                        } else if (finalEditLinker != null && !finalEditLinker.getMainModule().getPath().startsWith(siteNode.getPath() + "/")) {
                            MainModule.staticGoTo((String)siteNode.get("homepage-path"), null);
                        } else if (finalEditLinker != null) {
                            finalEditLinker.handleNewMainSelection();
                            finalEditLinker.handleNewMainNodeLoaded();
                        }
                    }
                });
            }
        });
    }

    private void createSitesCombo() {
        this.sitesCombo = new ComboBox();
        this.sitesCombo.setStore(new ListStore());
        this.sitesCombo.setDisplayField("switcherDisplayName");
        this.sitesCombo.setValueField("uuid");
        this.sitesCombo.setTypeAhead(true);
        this.sitesCombo.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.sitesCombo.setForceSelection(true);
        this.sitesCombo.getListView().setStyleAttribute("font-size", "11px");
        this.sitesCombo.setAllowBlank(true);
        this.sitesCombo.getListView().addStyleName("menu-" + this.getGwtToolbarItem().getClassName());
        this.sitesCombo.setWidth(200);
        this.setEnabled(true);
    }

    @Override
    public Component getCustomItem() {
        return this.mainComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mainComponent.setEnabled(enabled);
    }

    @Override
    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        String path = JahiaGWTParameters.getSitesMap().get(node.getSiteUUID()).getPath();
        String s = node.getPath();
        if (s.contains("@/") && s.startsWith("/sites")) {
            path = s.substring(0, s.indexOf(47, 7));
        }
        for (GWTJahiaNode site : this.sitesCombo.getStore().getModels()) {
            if (!site.getPath().equals(path)) continue;
            this.sitesCombo.setValue((ModelData)site);
            return;
        }
        this.sitesCombo.setValue(null);
    }

    public void setFilterEditModeBlockedSites(boolean filterEditModeBlockedSites) {
        this.filterEditModeBlockedSites = filterEditModeBlockedSites;
    }
}

