/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class UnzipActionItem
extends BaseActionItem {
    @Override
    public void onComponentSelection() {
        List<GWTJahiaNode> selectedItems = this.linker.getSelectionContext().getMultipleSelection();
        if (selectedItems != null && selectedItems.size() > 0) {
            this.linker.loading(Messages.get("statusbar.unzipping.label"));
            ArrayList<String> selectedPaths = new ArrayList<String>(selectedItems.size());
            for (GWTJahiaNode node : selectedItems) {
                if (!node.getName().endsWith(".zip") && !node.getName().endsWith(".ZIP")) continue;
                selectedPaths.add(node.getPath());
            }
            JahiaContentManagementService.App.getInstance().unzip(selectedPaths, new BaseAsyncCallback(){

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    Window.alert((String)(Messages.get("failure.unzip.label") + "\n" + throwable.getLocalizedMessage()));
                    UnzipActionItem.this.linker.loaded();
                }

                public void onSuccess(Object o) {
                    UnzipActionItem.this.linker.loaded();
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshAll", true);
                    UnzipActionItem.this.linker.refresh(data);
                }
            });
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        this.setEnabled(lh.getMultipleSelection().size() > 0 && this.hasPermission(lh.getSelectionPermissions()) && lh.isParentWriteable() && lh.isFile() && lh.isZip());
    }
}

