/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.wizard;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.CardPanel;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HtmlContainer;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.ProgressBar;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import java.util.List;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.wizard.WizardCard;

public class WizardWindow
extends Window {
    protected int currentStep = 0;
    protected List<WizardCard> cards;
    private Header headerPanel;
    private CardPanel cardPanel;
    protected Button prevBtn;
    protected Button nextBtn;
    protected Button cancelBtn;
    private Indicator progressIndicator = Indicator.DOT;

    public WizardWindow(List<WizardCard> cards) {
        this.addStyleName("wizard-window");
        this.cards = cards != null ? cards : new LinkedList();
        for (WizardCard card : this.cards) {
            card.setWizardWindow(this);
        }
        this.setSize(540, 400);
        this.setClosable(true);
        this.setResizable(true);
        this.setModal(true);
        this.setMaximizable(true);
        this.setHeadingHtml(this.getHeaderTitle());
    }

    protected void onButtonPressed(Button button) {
        if (button == this.cancelBtn) {
            this.hide(button);
            return;
        }
        if (button == this.prevBtn) {
            this.doPrevious();
        }
        if (button == this.nextBtn) {
            this.doNext();
        }
    }

    public void doCancel() {
        this.hide();
    }

    public void doNext() {
        if (!this.cards.get(this.currentStep).isValid()) {
            return;
        }
        this.cards.get(this.currentStep).next();
        if (this.currentStep + 1 == this.cards.size()) {
            this.cards.get(this.currentStep).notifyFinishListeners();
        } else {
            WizardCard nextCard = this.cards.get(this.currentStep + 1);
            if (!nextCard.isUiCreated()) {
                nextCard.createUI();
                nextCard.setUiCreated(true);
            }
            ++this.currentStep;
            this.updateWizard();
        }
    }

    public void doPrevious() {
        if (this.currentStep > 0) {
            --this.currentStep;
            this.updateWizard();
        }
    }

    public void updateWizard() {
        WizardCard wc = this.cards.get(this.currentStep);
        this.headerPanel.updateIndicatorStep(wc.getCardTitle(), wc.getHtmltext());
        wc.refreshLayout();
        this.cardPanel.setActiveItem((Component)wc);
        if (this.currentStep + 1 == this.cards.size()) {
            this.nextBtn.setText(this.getFinishButtonText());
        } else {
            this.nextBtn.setText(this.getNextButtonText());
        }
        if (this.currentStep == 0) {
            this.prevBtn.setEnabled(false);
        } else {
            this.prevBtn.setEnabled(true);
        }
    }

    protected void onRender(Element parent, int pos) {
        this.prevBtn = new Button(this.getPreviousButtonText());
        this.prevBtn.addStyleName("button-previous");
        this.nextBtn = new Button(this.getNextButtonText());
        this.nextBtn.addStyleName("button-next");
        this.cancelBtn = new Button(this.getCancelButtonText());
        this.cancelBtn.addStyleName("button-cancel");
        SelectionListener<ButtonEvent> listener = new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                WizardWindow.this.onButtonPressed(buttonEvent.getButton());
            }
        };
        this.prevBtn.addSelectionListener((SelectionListener)listener);
        this.nextBtn.addSelectionListener((SelectionListener)listener);
        this.cancelBtn.addSelectionListener((SelectionListener)listener);
        ToolBar buttonBar = new ToolBar();
        buttonBar.add((Component)this.prevBtn);
        buttonBar.add((Component)this.nextBtn);
        buttonBar.add((Component)this.cancelBtn);
        this.setBottomComponent((Component)buttonBar);
        super.onRender(parent, pos);
        this.setLayout((Layout)new BorderLayout());
        this.headerPanel = new Header();
        this.add((Widget)this.headerPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 60.0f));
        this.cardPanel = new CardPanel();
        this.cardPanel.setStyleAttribute("padding", "5px 5px 5px 5px");
        this.cardPanel.setStyleAttribute("backgroundColor", "#F6F6F6");
        this.add((Widget)this.cardPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        for (WizardCard wizardCard : this.cards) {
            this.cardPanel.add((Widget)wizardCard);
        }
        if (this.cards.size() > 0) {
            this.updateWizard();
        }
    }

    public String getHeaderTitle() {
        return Messages.get("org.jahia.engines.wizard.title", "Wizard");
    }

    public void setProgressIndicator(Indicator value) {
        this.progressIndicator = value;
    }

    public String getPreviousButtonText() {
        return Messages.get("org.jahia.engines.wizard.button.prev", "< Previous");
    }

    public String getNextButtonText() {
        return Messages.get("org.jahia.engines.wizard.button.next", "Next >");
    }

    public String getCancelButtonText() {
        return Messages.get("label.cancel", "Cancel");
    }

    public String getFinishButtonText() {
        return Messages.get("label.finish", "Finish");
    }

    public String getIndicateStepText() {
        return Messages.get("label.step", "Step");
    }

    public String getIndicateOfText() {
        return Messages.get("label.of", "of");
    }

    public List<WizardCard> getCards() {
        return this.cards;
    }

    public void resetCards(int index) {
        for (int i = index + 1; i < this.cards.size(); ++i) {
            WizardCard card = this.cards.get(i);
            if (card == null) continue;
            card.resetUI();
        }
    }

    public WizardWindow addCard(WizardCard card) {
        if (this.cards.size() > 0) {
            this.cards.get(this.cards.size() - 1).setNextWizardCard(card);
        }
        this.cards.add(card);
        card.setWizardWindow(this);
        return this;
    }

    protected class Header
    extends VerticalPanel {
        private ProgressBar indicatorBar;
        private HtmlContainer titleHTML;

        protected Header() {
            this.setTableWidth("100%");
            this.setTableHeight("100%");
            this.setStyleName("ext-ux-wiz-Header");
            this.setBorders(true);
            this.titleHTML = new HtmlContainer("");
            this.titleHTML.setStyleAttribute("font-weight", "bold");
            this.titleHTML.setStyleAttribute("padding", "4px 0px 0px 4px");
            this.titleHTML.setStyleName("ext-ux-wiz-Header-title");
            this.add((Component)this.titleHTML);
            if (WizardWindow.this.progressIndicator == Indicator.PROGRESSBAR || WizardWindow.this.progressIndicator == Indicator.DOT) {
                this.indicatorBar = new ProgressBar();
                LayoutContainer lc = new LayoutContainer();
                lc.add((Widget)this.indicatorBar);
                lc.setWidth("50%");
                TableData td = new TableData();
                td.setHorizontalAlign(Style.HorizontalAlignment.RIGHT);
                td.setPadding(5);
                this.add((Widget)lc, (LayoutData)td);
            }
        }

        protected void updateIndicatorStep(String cardtitle, String description) {
            final String stepStr = WizardWindow.this.getIndicateStepText() + " " + (1 + WizardWindow.this.currentStep) + " " + WizardWindow.this.getIndicateOfText() + " " + WizardWindow.this.cards.size() + " : " + cardtitle;
            final double stepRatio = (double)(1 + WizardWindow.this.currentStep) / (double)WizardWindow.this.cards.size();
            if (description != null) {
                this.titleHTML.setHtml(description);
            } else {
                this.titleHTML.setHtml("");
            }
            if (WizardWindow.this.progressIndicator == Indicator.PROGRESSBAR || WizardWindow.this.progressIndicator == Indicator.DOT) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Header.this.indicatorBar.updateProgress(stepRatio, stepStr);
                    }
                });
            }
        }

        protected void onRender(Element parent, int pos) {
            super.onRender(parent, pos);
            this.setStyleAttribute("borderLeft", "none");
            this.setStyleAttribute("borderRight", "none");
            this.setStyleAttribute("borderTop", "none");
        }
    }

    public static enum Indicator {
        NONE,
        DOT,
        PROGRESSBAR;

    }
}

