/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.module.empty.client;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jahia.ajax.gwt.client.EmptyLinker;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.CommonEntryPoint;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.content.actions.ContentActions;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.content.DeleteItemWindow;
import org.jahia.ajax.gwt.client.widget.content.util.ContentHelper;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineJSConfig;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.contentengine.WorkflowHistoryPanel;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.poller.ContentUnpublishedEvent;
import org.jahia.ajax.gwt.client.widget.poller.EventDispatcherPollListener;
import org.jahia.ajax.gwt.client.widget.poller.ProcessPollingEvent;
import org.jahia.ajax.gwt.client.widget.poller.TaskEvent;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;

public class EmptyEntryPoint
extends CommonEntryPoint {
    private static EmptyEntryPoint instance;
    private Linker linker;
    private GWTEditConfiguration configuration;

    public static EmptyEntryPoint getInstance() {
        return instance;
    }

    @Override
    public void onModuleLoad() {
        super.onModuleLoad();
        instance = this;
        JahiaContentManagementService.App.getInstance().getEditConfiguration("/", "editmode", "default", (AsyncCallback<GWTEditConfiguration>)new BaseAsyncCallback<GWTEditConfiguration>(){

            public void onSuccess(GWTEditConfiguration config) {
                PermissionsUtils.loadPermissions(config.getPermissions());
                if (config.isEventDispatchingEnabled()) {
                    new EventDispatcherPollListener(TaskEvent.class, ProcessPollingEvent.class, ContentUnpublishedEvent.class);
                }
                EmptyEntryPoint.this.exposeFunctions();
                JahiaGWTParameters.setSiteNode(config.getSiteNode());
                EmptyEntryPoint.this.configuration = config;
                EmptyEntryPoint.this.linker = new EmptyLinker(config);
            }

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.error((String)"Error when loading EditConfiguration", (Throwable)throwable);
                Window.Location.assign((String)(JahiaGWTParameters.getContextPath() + "/errors/error_404.jsp"));
            }
        });
    }

    public GWTEditConfiguration getConfiguration() {
        return this.configuration;
    }

    public Linker getLinker() {
        return this.linker;
    }

    private native void exposeFunctions();

    static void alert(String title, String message) {
        MessageBox.alert((String)(title != null ? title : "Info"), (String)message, null);
    }

    public static JavaScriptObject getEditTabs(String path, String uuid, String displayName, JsArrayString nodeTypes, JsArrayString inheritedNodeTypes, boolean hasOrderableChildNodes) {
        GWTJahiaNode node = MainModule.getGwtJahiaNode(uuid, path, displayName, nodeTypes, inheritedNodeTypes);
        JSONArray editTabs = new JSONArray();
        List<GWTEngineTab> gwtEngineTabs = EmptyEntryPoint.resolveEditTabs(hasOrderableChildNodes, EmptyEntryPoint.getInstance().getLinker().getConfig().getEngineConfiguration(node), node);
        for (int idx = 0; idx < gwtEngineTabs.size(); ++idx) {
            JSONObject jsonTab = new JSONObject();
            GWTEngineTab gwtEngineTab = gwtEngineTabs.get(idx);
            jsonTab.put("id", (JSONValue)new JSONString(gwtEngineTab.getId()));
            jsonTab.put("title", (JSONValue)new JSONString(gwtEngineTab.getTitle()));
            if (gwtEngineTab.getRequiredPermission() != null && gwtEngineTab.getRequiredPermission().length() > 0) {
                jsonTab.put("requiredPermission", (JSONValue)new JSONString(gwtEngineTab.getRequiredPermission()));
            }
            editTabs.set(idx, (JSONValue)jsonTab);
        }
        return editTabs.getJavaScriptObject();
    }

    private static List<GWTEngineTab> resolveEditTabs(boolean hasOrderableChildNodes, GWTEngineConfiguration config, GWTJahiaNode node) {
        ArrayList<GWTEngineTab> gwtEngineTabs = new ArrayList<GWTEngineTab>();
        for (GWTEngineTab tabConfig : config.getEngineTabs()) {
            EditEngineTabItem tabItem = tabConfig.getTabItem();
            if (!tabConfig.showInEngine() || !tabItem.getHideForTypes().isEmpty() && node.isNodeType(tabItem.getHideForTypes()) || (!hasOrderableChildNodes || !tabItem.isOrderableTab()) && (tabItem.isOrderableTab() || !tabItem.getShowForTypes().isEmpty() && !node.isNodeType(tabItem.getShowForTypes()))) continue;
            gwtEngineTabs.add(tabConfig);
        }
        return gwtEngineTabs;
    }

    public static void editContent(String path, String displayName, JsArrayString nodeTypes, JsArrayString inheritedNodeTypes, String uuid, boolean skipRefreshOnSave, EditEngineJSConfig jsConfig) {
        GWTJahiaNode node = MainModule.getGwtJahiaNode(uuid, path, displayName, nodeTypes, inheritedNodeTypes);
        EngineLoader.showEditEngine(EmptyEntryPoint.getInstance().getLinker(), node, null, skipRefreshOnSave, jsConfig);
    }

    public static void openWorkflow(String target) {
        WorkflowHistoryPanel widget = new WorkflowHistoryPanel(EmptyEntryPoint.getInstance().getLinker());
        RootPanel rootPanel = RootPanel.get((String)target);
        rootPanel.clear();
        rootPanel.add((Widget)widget);
    }

    public static void showPageEdit(String target, String path, String template, String nodeTypes) {
        RootPanel panel = RootPanel.get((String)target);
        panel.add((Widget)new MainModule(path, template, nodeTypes, EmptyEntryPoint.getInstance().getConfiguration()));
    }

    public static void deleteContent(String uuid, String path, String displayName, JsArrayString nodeTypes, JsArrayString inheritedNodeTypes, boolean skipRefreshOnDelete, boolean deletePermanently) {
        GWTJahiaNode node = MainModule.getGwtJahiaNode(uuid, path, displayName, nodeTypes, inheritedNodeTypes);
        Linker linker = EmptyEntryPoint.getInstance().getLinker();
        LinkerSelectionContext selectionContext = linker.getSelectionContext();
        selectionContext.setMainNode(node);
        selectionContext.setSelectedNodes(Collections.singletonList(node));
        selectionContext.refresh(3);
        DeleteItemWindow window = new DeleteItemWindow(linker, selectionContext.getSelectedNodes(), deletePermanently, skipRefreshOnDelete, JahiaGWTParameters.getBaseEditUrl());
        window.show();
    }

    public static void deleteContents(JsArray objects, boolean skipRefreshOnDelete, boolean deletePermanently) {
        Linker linker = EmptyEntryPoint.getInstance().getLinker();
        LinkerSelectionContext selectionContext = linker.getSelectionContext();
        List<GWTJahiaNode> nodes = MainModule.getGwtJahiaNodes(objects);
        if (nodes.size() > 0) {
            selectionContext.setMainNode(nodes.get(0));
            selectionContext.setSelectedNodes(nodes);
            selectionContext.refresh(3);
            DeleteItemWindow window = new DeleteItemWindow(linker, selectionContext.getSelectedNodes(), deletePermanently, skipRefreshOnDelete, JahiaGWTParameters.getBaseEditUrl());
            window.show();
        }
    }

    public static void undeleteContent(final String uuid, final String path, String displayName, final String nodeName) {
        String message = Messages.getWithArgs("message.undelete.confirm", "Do you really want to undelete the selected resource {0}?", new String[]{displayName});
        MessageBox.confirm((String)Messages.get("label.information", "Information"), (String)message, (Listener)new Listener<MessageBoxEvent>(){

            public void handleEvent(MessageBoxEvent event) {
                if (event.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                    JahiaContentManagementService.App.getInstance().undeletePaths(Collections.singletonList(path), new BaseAsyncCallback<Object>(){

                        @Override
                        public void onApplicationFailure(Throwable throwable) {
                            Log.error((String)throwable.getMessage(), (Throwable)throwable);
                            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
                        }

                        public void onSuccess(Object result) {
                            ContentHelper.sendContentModificationEvent(uuid, path, nodeName, "update", null);
                        }
                    });
                }
            }
        });
    }

    public static void undeleteContents(JsArray objects) {
        final List<GWTJahiaNode> nodes = MainModule.getGwtJahiaNodes(objects);
        String message = Messages.getWithArgs("message.undelete.multiple.confirm", "Do you really want to undelete the {0} selected resources?", new String[]{String.valueOf(nodes.size())});
        final ArrayList<String> paths = new ArrayList<String>();
        for (GWTJahiaNode node : nodes) {
            paths.add(node.getPath());
        }
        MessageBox.confirm((String)Messages.get("label.information", "Information"), (String)message, (Listener)new Listener<MessageBoxEvent>(){

            public void handleEvent(MessageBoxEvent event) {
                if (event.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                    JahiaContentManagementService.App.getInstance().undeletePaths(paths, new BaseAsyncCallback<Object>(){

                        @Override
                        public void onApplicationFailure(Throwable throwable) {
                            Log.error((String)throwable.getMessage(), (Throwable)throwable);
                            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
                        }

                        public void onSuccess(Object result) {
                            for (GWTJahiaNode node : nodes) {
                                ContentHelper.sendContentModificationEvent(node.getUUID(), node.getPath(), node.getName(), "update", null);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void switchSite(String siteKey, final String lang) {
        if (!lang.equals(JahiaGWTParameters.getReactLanguage())) {
            JahiaGWTParameters.setReactLanguage(lang);
        }
        if (!siteKey.equals(JahiaGWTParameters.getReactSiteKey())) {
            JahiaGWTParameters.setReactSiteKey(siteKey);
        }
        if (siteKey.equals(JahiaGWTParameters.getSiteKey()) && lang.equals(JahiaGWTParameters.getLanguage())) {
            return;
        }
        if (!siteKey.equals(JahiaGWTParameters.getSiteKey())) {
            JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList("/sites/" + siteKey), GWTJahiaNode.DEFAULT_SITE_FIELDS, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                public void onSuccess(List<GWTJahiaNode> result) {
                    GWTJahiaNode siteNode;
                    if (!result.isEmpty() && EmptyEntryPoint.isValidSiteLanguage(siteNode = result.get(0), lang)) {
                        JahiaGWTParameters.setSiteNode(siteNode);
                        JahiaGWTParameters.setLanguage(JahiaGWTParameters.getLanguage(lang));
                    }
                }
            });
        } else if (EmptyEntryPoint.isValidSiteLanguage(JahiaGWTParameters.getSiteNode(), lang)) {
            JahiaGWTParameters.setLanguage(JahiaGWTParameters.getLanguage(lang));
        }
    }

    private static boolean isValidSiteLanguage(GWTJahiaNode siteNode, String lang) {
        List langs = (List)siteNode.get("j:languages");
        return langs.contains(lang);
    }

    public static void switchLanguage(String lang) {
        if (!lang.equals(JahiaGWTParameters.getReactLanguage())) {
            JahiaGWTParameters.setReactLanguage(lang);
        }
        if (lang.equals(JahiaGWTParameters.getLanguage())) {
            return;
        }
        if (EmptyEntryPoint.isValidSiteLanguage(JahiaGWTParameters.getSiteNode(), lang)) {
            JahiaGWTParameters.setLanguage(JahiaGWTParameters.getLanguage(lang));
        }
    }

    public static void createContent(String path, JsArrayString nodeTypes, boolean includeSubTypes, boolean skipRefreshOnSave) {
        GWTJahiaNode parent = new GWTJahiaNode();
        parent.setPath(path);
        ContentActions.showContentWizard(EmptyEntryPoint.getInstance().getLinker(), nodeTypes != null && nodeTypes.length() > 0 ? nodeTypes.join(" ") : "jmix:droppableContent", parent, includeSubTypes, skipRefreshOnSave);
    }

    public static void openPublicationWorkflow(JsArrayString uuids, boolean allSubTree, boolean allLanguages, boolean checkForUnpublication) {
        PublicationWorkflow.openPublicationWorkflow(MainModule.convertArray(uuids), EmptyEntryPoint.getInstance().getLinker(), allSubTree, allLanguages, checkForUnpublication);
    }
}

