/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.core;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.SessionValidationResult;

public class CommonEntryPoint
implements EntryPoint {
    private static Timer sessionCheckTimer;
    JahiaContentManagementServiceAsync contentManagementService;
    private static String loginUrl;

    public void onModuleLoad() {
        Log.setUncaughtExceptionHandler();
    }

    protected void checkSession() {
        sessionCheckTimer = new Timer(){

            public void run() {
                CommonEntryPoint.this.getContentManagementService().isValidSession((AsyncCallback<SessionValidationResult>)new BaseAsyncCallback<SessionValidationResult>(){

                    public void onSuccess(SessionValidationResult result) {
                        int val = result.getPollingInterval();
                        loginUrl = result.getLoginUrl();
                        if (val > 0) {
                            this.schedule(val);
                        } else if (val == 0) {
                            this.cancel();
                            CommonEntryPoint.this.handleSessionExpired(this);
                        }
                    }
                });
            }
        };
        sessionCheckTimer.run();
    }

    protected JahiaContentManagementServiceAsync getContentManagementService() {
        if (this.contentManagementService == null) {
            this.contentManagementService = JahiaContentManagementService.App.getInstance();
        }
        return this.contentManagementService;
    }

    protected void handleSessionExpired(BaseAsyncCallback<?> callback) {
        callback.showLogin();
    }

    public static Timer getSessionCheckTimer() {
        return sessionCheckTimer;
    }

    static String getLoginUrl() {
        return loginUrl;
    }

    public static native void consoleLog(String var0);

    public static native void consoleError(String var0);
}

