/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util.security;

import java.util.Iterator;
import java.util.List;

public enum PermissionsResolver {
    MATCH_ALL{

        @Override
        public boolean resolve(List<String> permissions, Matcher matcher) {
            if (permissions.isEmpty()) {
                return true;
            }
            boolean result = true;
            Iterator<String> it = permissions.iterator();
            while (it.hasNext() && result) {
                String permission = it.next();
                result = matcher.matches(permission);
            }
            return result;
        }
    }
    ,
    MATCH_ANY{

        @Override
        public boolean resolve(List<String> permissions, Matcher matcher) {
            if (permissions.isEmpty()) {
                return true;
            }
            for (String permission : permissions) {
                if (!matcher.matches(permission)) continue;
                return true;
            }
            return false;
        }
    };


    public abstract boolean resolve(List<String> var1, Matcher var2);

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

