/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.PropertyEditor;
import com.extjs.gxt.ui.client.widget.form.TwinTriggerField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.content.ContentPicker;
import org.jahia.ajax.gwt.client.widget.content.CustomContentPicker;
import org.jahia.ajax.gwt.client.widget.usergroup.UserGroupAdder;
import org.jahia.ajax.gwt.client.widget.usergroup.UserGroupSelect;

public class ContentPickerField
extends TwinTriggerField<List<GWTJahiaNode>> {
    private List<GWTJahiaNode> value;
    private String selectionLabel;
    private List<String> types;
    private List<String> filters;
    private List<String> mimeTypes;
    private String configuration;
    private boolean multiple;
    private Map<String, String> selectorOptions;

    public ContentPickerField(Map<String, String> selectorOptions, List<String> types, List<String> filters, List<String> mimeTypes, String configuration, boolean multiple) {
        this.setPropertyEditor((PropertyEditor)new PropertyEditor<List<GWTJahiaNode>>(){

            public String getStringValue(List<GWTJahiaNode> value) {
                StringBuilder s = new StringBuilder();
                Iterator<GWTJahiaNode> it = value.iterator();
                while (it.hasNext()) {
                    GWTJahiaNode currentNode = it.next();
                    if (currentNode.get("j:url") != null) {
                        s.append(currentNode.get("j:url"));
                    } else {
                        s.append(currentNode.getName());
                    }
                    if (!it.hasNext()) continue;
                    s.append(", ");
                }
                return s.toString();
            }

            public List<GWTJahiaNode> convertStringValue(String value) {
                return new ArrayList<GWTJahiaNode>();
            }
        });
        this.types = types;
        this.filters = filters;
        this.mimeTypes = mimeTypes;
        this.configuration = configuration;
        this.multiple = multiple;
        this.selectorOptions = selectorOptions;
        this.setTwinTriggerStyle("x-form-clear-trigger");
        this.setEditable(false);
        this.setValue(new ArrayList<GWTJahiaNode>());
        this.propertyEditor = new PropertyEditor<List<GWTJahiaNode>>(){

            public String getStringValue(List<GWTJahiaNode> value) {
                StringBuilder result = new StringBuilder();
                for (GWTJahiaNode gwtJahiaNode : value) {
                    if (result.length() > 0) {
                        result.append(",");
                    }
                    result.append(gwtJahiaNode.getDisplayName());
                }
                return result.toString();
            }

            public List<GWTJahiaNode> convertStringValue(String value) {
                return null;
            }
        };
    }

    protected void onTriggerClick(ComponentEvent ce) {
        super.onTriggerClick(ce);
        if (this.disabled || this.isReadOnly()) {
            return;
        }
        if (this.configuration.equals("userpicker")) {
            new UserGroupSelect(new UserPickerAdder(), 1, JahiaGWTParameters.getSiteNode().getName(), !this.multiple);
        } else if (this.configuration.equals("usergrouppicker")) {
            new UserGroupSelect(new UserPickerAdder(), 3, JahiaGWTParameters.getSiteNode().getName(), !this.multiple);
        } else if (this.configuration.equals("custompicker")) {
            JahiaContentManagementService.App.getInstance().getManagerConfiguration(this.selectorOptions.get("config"), null, (AsyncCallback<GWTManagerConfiguration>)new BaseAsyncCallback<GWTManagerConfiguration>(){

                public void onSuccess(GWTManagerConfiguration config) {
                    PermissionsUtils.loadPermissions(config.getPermissions());
                    final Window w = new Window();
                    w.setLayout((Layout)new FitLayout());
                    w.setId("JahiaGxtCustomContentPickerWindow");
                    w.addStyleName("modal-" + ContentPickerField.this.configuration);
                    final CustomContentPicker contentPicker = new CustomContentPicker(config.getCustomPickerConfiguration(), (List<GWTJahiaNode>)ContentPickerField.this.getValue(), config.getSiteNode());
                    if (config.getTitle() != null) {
                        w.setHeadingHtml(config.getTitle());
                    } else {
                        w.setHeadingHtml(Messages.get("label." + config.getName(), config.getName()));
                    }
                    int windowHeight = com.google.gwt.user.client.Window.getClientHeight() - 10;
                    w.setModal(true);
                    w.setSize(900, windowHeight);
                    w.setResizable(true);
                    w.setMaximizable(true);
                    w.setBodyBorder(false);
                    ButtonBar bar = new ButtonBar();
                    bar.setAlignment(Style.HorizontalAlignment.CENTER);
                    Button ok = new Button(Messages.get("label.save"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent event) {
                            List<String> values = contentPicker.getValues();
                            JahiaContentManagementService.App.getInstance().getNodes(values, null, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                                public void onSuccess(List<GWTJahiaNode> gwtJahiaNodes) {
                                    ContentPickerField.this.setValue(gwtJahiaNodes);
                                    w.hide();
                                }
                            });
                        }
                    });
                    ok.addStyleName("button-save");
                    ok.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonOK());
                    bar.add((Component)ok);
                    if (ContentPickerField.this.getValue() == null || ContentPickerField.this.getValue().size() == 0) {
                        ok.setEnabled(false);
                    }
                    ok.setEnabled(true);
                    Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent event) {
                            w.hide();
                        }
                    });
                    cancel.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonCancel());
                    cancel.addStyleName("button-cancel");
                    bar.add((Component)cancel);
                    w.add((Widget)contentPicker);
                    w.setBottomComponent((Component)bar);
                    w.show();
                    contentPicker.loadData();
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    Log.error((String)"Error while loading user permission", (Throwable)throwable);
                }
            });
        } else {
            JahiaContentManagementService.App.getInstance().getManagerConfiguration(this.configuration, null, (AsyncCallback<GWTManagerConfiguration>)new BaseAsyncCallback<GWTManagerConfiguration>(){

                public void onSuccess(GWTManagerConfiguration config) {
                    PermissionsUtils.loadPermissions(config.getPermissions());
                    final Window w = new Window();
                    w.setLayout((Layout)new FitLayout());
                    w.setId("JahiaGxtContentPickerWindow");
                    w.addStyleName("modal-" + ContentPickerField.this.configuration);
                    final ContentPicker contentPicker = new ContentPicker(ContentPickerField.this.selectorOptions, (List<GWTJahiaNode>)ContentPickerField.this.getValue(), ContentPickerField.this.types, ContentPickerField.this.filters, ContentPickerField.this.mimeTypes, config, ContentPickerField.this.multiple);
                    if (config.getTitle() != null) {
                        w.setHeadingHtml(config.getTitle());
                    } else {
                        w.setHeadingHtml(Messages.get("label." + config.getName(), config.getName()));
                    }
                    int windowHeight = com.google.gwt.user.client.Window.getClientHeight() - 10;
                    w.setModal(true);
                    w.setSize(900, windowHeight);
                    w.setResizable(true);
                    w.setMaximizable(true);
                    w.setBodyBorder(false);
                    ButtonBar bar = new ButtonBar();
                    bar.setAlignment(Style.HorizontalAlignment.CENTER);
                    Button ok = new Button(Messages.get("label.save"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent event) {
                            List<GWTJahiaNode> selection = contentPicker.getSelectedNodes();
                            ContentPickerField.this.setValue(selection);
                            w.hide();
                        }
                    });
                    ok.addStyleName("button-save");
                    ok.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonOK());
                    bar.add((Component)ok);
                    contentPicker.setSaveButton(ok);
                    if (ContentPickerField.this.getValue() == null || ContentPickerField.this.getValue().size() == 0) {
                        ok.setEnabled(false);
                    }
                    Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent event) {
                            w.hide();
                        }
                    });
                    cancel.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonCancel());
                    cancel.addStyleName("button-cancel");
                    bar.add((Component)cancel);
                    w.add((Widget)contentPicker);
                    w.setBottomComponent((Component)bar);
                    w.show();
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    Log.error((String)"Error while loading user permission", (Throwable)throwable);
                }
            });
        }
    }

    protected void onTwinTriggerClick(ComponentEvent ce) {
        if (this.disabled || this.isReadOnly()) {
            return;
        }
        this.setValue(new ArrayList<GWTJahiaNode>());
    }

    public List<GWTJahiaNode> getValue() {
        Log.debug((String)("Get value: " + this.value));
        return this.value;
    }

    public void setValue(List<GWTJahiaNode> value) {
        this.value = value;
        super.setValue(value);
    }

    private class UserPickerAdder
    implements UserGroupAdder {
        private UserPickerAdder() {
        }

        @Override
        public void addUsersGroups(List<GWTJahiaNode> users) {
            ContentPickerField.this.setValue(users);
        }
    }
}

