/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.NumberField;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.ColumnData;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.ExistingFileException;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;

public class ImageResize
extends Window {
    private Linker linker;
    private ComboBox<GWTJahiaValueDisplayBean> predefinedSizesBox;
    private boolean autoName = true;

    public ImageResize(Linker linker, final GWTJahiaNode n, List<Integer[]> predefinedSizes) {
        this.addStyleName("image-resize");
        this.linker = linker;
        final int w = Integer.parseInt((String)n.get("j:width"));
        final int h = Integer.parseInt((String)n.get("j:height"));
        this.setHeadingHtml(Messages.get("label.resize"));
        this.setSize(500, 250);
        this.setResizable(false);
        ButtonBar buttons = new ButtonBar();
        FormPanel form = new FormPanel();
        form.setFrame(false);
        form.setHeaderVisible(false);
        form.setBorders(false);
        form.setFieldWidth(350);
        this.setModal(true);
        FormData layoutData = new FormData(100, 0);
        final NumberField wf = new NumberField();
        final NumberField hf = new NumberField();
        final CheckBox keepRatio = new CheckBox();
        final TextField newname = new TextField();
        if (predefinedSizes != null && !predefinedSizes.isEmpty()) {
            ArrayList<GWTJahiaValueDisplayBean> sizes = new ArrayList<GWTJahiaValueDisplayBean>();
            for (Integer[] d : predefinedSizes) {
                String label = d[0] + " x " + d[1];
                GWTJahiaValueDisplayBean v = new GWTJahiaValueDisplayBean(label, label);
                v.set("width", d[0]);
                v.set("height", d[1]);
                sizes.add(v);
            }
            if (!sizes.isEmpty()) {
                this.predefinedSizesBox = new ComboBox();
                this.predefinedSizesBox.setDisplayField("display");
                this.predefinedSizesBox.setStore(new ListStore());
                this.predefinedSizesBox.setForceSelection(true);
                this.predefinedSizesBox.setTriggerAction(ComboBox.TriggerAction.ALL);
                this.predefinedSizesBox.setDeferHeight(true);
                this.predefinedSizesBox.getStore().add(sizes);
                this.predefinedSizesBox.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

                    public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> se) {
                        GWTJahiaValueDisplayBean v = (GWTJahiaValueDisplayBean)se.getSelectedItem();
                        wf.setValue((Object)((Integer)v.get("width")));
                        if (!keepRatio.getValue().booleanValue()) {
                            hf.setValue((Object)((Integer)v.get("height")));
                        } else {
                            hf.setValue((Object)(h * ((Number)wf.getValue()).intValue() / w));
                        }
                        if (ImageResize.this.autoName) {
                            ImageResize.this.setAutoName((TextField<String>)newname, ((Number)wf.getValue()).intValue(), ((Number)hf.getValue()).intValue());
                        }
                    }
                });
                this.predefinedSizesBox.setEmptyText(Messages.get("selectPredefinedSize.label", "select a predefined size"));
                this.predefinedSizesBox.setFieldLabel(Messages.get("label.size", "Size"));
                form.add(this.predefinedSizesBox, (LayoutData)new ColumnData(200.0));
            }
        }
        wf.setName("width");
        wf.setValue((Object)new Integer(w));
        wf.setFieldLabel(Messages.get("width.label"));
        form.add((Widget)wf, (LayoutData)layoutData);
        hf.setName("height");
        hf.setValue((Object)new Integer(h));
        hf.setFieldLabel(Messages.get("height.label"));
        form.add((Widget)hf, (LayoutData)layoutData);
        keepRatio.setName("ratio");
        keepRatio.setValue(Boolean.valueOf(true));
        keepRatio.setFieldLabel(Messages.get("ratio.label"));
        form.add((Widget)keepRatio, (LayoutData)new FormData(20, 0));
        newname.setName("newname");
        newname.setWidth(350);
        int extIndex = n.getName().lastIndexOf(".");
        if (extIndex > 0) {
            String dotExt = n.getName().substring(extIndex);
            newname.setValue((Object)n.getName().replaceAll(dotExt + "+$", "-resize" + w + "x" + h + dotExt));
        } else {
            newname.setValue((Object)(n.getName() + "-resize" + w + "x" + h));
        }
        newname.setFieldLabel(Messages.get("label.rename"));
        newname.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                ImageResize.this.autoName = false;
            }
        });
        form.add((Widget)newname);
        hf.addListener(Events.KeyUp, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent ce) {
                if (keepRatio.getValue().booleanValue()) {
                    wf.setValue((Object)(w * ((Number)hf.getValue()).intValue() / h));
                }
                if (ImageResize.this.autoName) {
                    ImageResize.this.setAutoName((TextField<String>)newname, ((Number)wf.getValue()).intValue(), ((Number)hf.getValue()).intValue());
                }
            }
        });
        wf.addListener(Events.KeyUp, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent ce) {
                if (keepRatio.getValue().booleanValue()) {
                    hf.setValue((Object)(h * ((Number)wf.getValue()).intValue() / w));
                }
                if (ImageResize.this.autoName) {
                    ImageResize.this.setAutoName((TextField<String>)newname, ((Number)wf.getValue()).intValue(), ((Number)hf.getValue()).intValue());
                }
            }
        });
        keepRatio.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent ce) {
                if (keepRatio.getValue().booleanValue()) {
                    hf.setValue((Object)(h * ((Number)wf.getValue()).intValue() / w));
                }
            }
        });
        Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ImageResize.this.hide();
            }
        });
        cancel.addStyleName("button-cancel");
        Button submit = new Button(Messages.get("label.ok"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ImageResize.this.resizeImage(n.getPath(), (String)newname.getValue(), ((Number)wf.getValue()).intValue(), ((Number)hf.getValue()).intValue(), false);
            }
        });
        submit.addStyleName("button-submit");
        buttons.add((Component)cancel);
        buttons.add((Component)submit);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setBottomComponent((Component)buttons);
        this.add((Component)form);
    }

    protected void setAutoName(TextField<String> newname, int w, int h) {
        String v = (String)newname.getValue();
        int dp = v.lastIndexOf(".");
        newname.setFireChangeEventOnSetValue(false);
        newname.setValue((Object)(v.substring(0, v.lastIndexOf("-resize")) + "-resize" + w + "x" + h + (dp != -1 ? v.substring(dp, v.length()) : "")));
        newname.setFireChangeEventOnSetValue(true);
    }

    private void resizeImage(final String path, final String targetName, final int width, final int height, boolean force) {
        JahiaContentManagementService.App.getInstance().resizeImage(path, targetName, width, height, force, new BaseAsyncCallback<Object>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                if (throwable instanceof ExistingFileException) {
                    if (com.google.gwt.user.client.Window.confirm((String)(Messages.get("alreadyExists.label") + "\n" + Messages.get("confirm.overwrite.label")))) {
                        ImageResize.this.resizeImage(path, targetName, width, height, true);
                    }
                } else {
                    com.google.gwt.user.client.Window.alert((String)(Messages.get("failure.resize.label") + "\n" + throwable.getLocalizedMessage()));
                    Log.error((String)Messages.get("failure.resize.label"), (Throwable)throwable);
                }
            }

            public void onSuccess(Object result) {
                ImageResize.this.hide();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshMain", true);
                ImageResize.this.linker.refresh(data);
            }
        });
    }
}

