/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.ExistingFileException;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;

public class ImageRotate
extends Window {
    private Linker m_linker;

    public ImageRotate(Linker linker, final GWTJahiaNode n) {
        this.addStyleName("image-rotate");
        this.m_linker = linker;
        this.setHeadingHtml(Messages.get("label.rotate"));
        this.setSize(500, 150);
        this.setResizable(false);
        ButtonBar buttons = new ButtonBar();
        FormPanel form = new FormPanel();
        form.setFrame(false);
        form.setHeaderVisible(false);
        form.setBorders(false);
        this.setModal(true);
        final TextField newname = new TextField();
        newname.setName("newname");
        int extIndex = n.getName().lastIndexOf(".");
        if (extIndex > 0) {
            String dotExt = n.getName().substring(extIndex);
            newname.setValue((Object)n.getName().replaceAll(dotExt + "+$", "-rotate" + dotExt));
        } else {
            newname.setValue((Object)(n.getName() + "-rotate"));
        }
        newname.setFieldLabel(Messages.get("label.rename"));
        form.add((Widget)newname);
        Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ImageRotate.this.hide();
            }
        });
        cancel.addStyleName("button-cancel");
        Button left = new Button(Messages.get("label.rotateLeft"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ImageRotate.this.rotateImage(n.getPath(), (String)newname.getValue(), false, false);
            }
        });
        left.addStyleName("button-left");
        Button right = new Button(Messages.get("label.rotateRight"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ImageRotate.this.rotateImage(n.getPath(), (String)newname.getValue(), true, false);
            }
        });
        right.addStyleName("button-right");
        buttons.add((Component)cancel);
        buttons.add((Component)left);
        buttons.add((Component)right);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.setBottomComponent((Component)buttons);
        this.add((Component)form);
    }

    private void rotateImage(final String path, final String target, final boolean clockwise, boolean force) {
        JahiaContentManagementService.App.getInstance().rotateImage(path, target, clockwise, force, new BaseAsyncCallback<Object>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                if (throwable instanceof ExistingFileException) {
                    if (com.google.gwt.user.client.Window.confirm((String)(Messages.get("alreadyExists.label") + "\n" + Messages.get("confirm.overwrite.label")))) {
                        ImageRotate.this.rotateImage(path, target, clockwise, true);
                    }
                } else {
                    com.google.gwt.user.client.Window.alert((String)(Messages.get("failure.rotate.label") + "\n" + throwable.getLocalizedMessage()));
                    Log.error((String)Messages.get("failure.rotate.label"), (Throwable)throwable);
                }
            }

            public void onSuccess(Object result) {
                ImageRotate.this.hide();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshMain", true);
                ImageRotate.this.m_linker.refresh(data);
            }
        });
    }
}

