/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseTreeModel;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.ModelIconProvider;
import com.extjs.gxt.ui.client.data.TreeLoader;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.TreeGridDragSource;
import com.extjs.gxt.ui.client.dnd.TreeGridDropTarget;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.IconButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.TreeGridEvent;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.ToolButton;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTRepository;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.content.actions.ContentActions;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.content.ContentRepositoryTabs;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.node.GWTJahiaNodeTreeFactory;

public class RepositoryTab
extends ContentPanel {
    private GWTRepository repository;
    private TreeLoader<GWTJahiaNode> loader;
    private TreeStore<GWTJahiaNode> store;
    private ContentRepositoryTabs folderTreeContainer;
    private TreeGrid<GWTJahiaNode> m_tree;
    private GWTJahiaNodeTreeFactory factory;
    private GWTManagerConfiguration config;

    public RepositoryTab(final ContentRepositoryTabs container, GWTRepository repo, List<String> selectedPaths, final GWTManagerConfiguration config) {
        super((Layout)new FitLayout());
        this.collapse();
        this.setBorders(false);
        this.setBodyBorder(false);
        this.getHeader().setBorders(false);
        this.folderTreeContainer = container;
        this.repository = repo;
        this.getHeader().setIcon(ToolbarIconProvider.getInstance().getIcon(repo.getKey()));
        this.factory = new GWTJahiaNodeTreeFactory(this.repository.getPaths());
        this.factory.setNodeTypes(config.getFolderTypes());
        this.factory.setMimeTypes(config.getMimeTypes());
        this.factory.setFilters(config.getFilters());
        ArrayList<String> keys = new ArrayList<String>(config.getTreeColumnKeys());
        int indexOf = keys.indexOf("publicationInfo");
        if (indexOf == -1 && !config.isSuppressTreePublicationInfo()) {
            keys.add("publicationInfo");
        } else if (indexOf != -1 && config.isSuppressTreePublicationInfo()) {
            keys.remove(indexOf);
        }
        keys.add("subnodesConstraintsInfo");
        this.factory.setFields(keys);
        this.factory.setSelectedPath(selectedPaths);
        this.factory.setHiddenTypes(config.getHiddenTypes());
        this.factory.setHiddenRegex(config.getHiddenRegex());
        this.factory.setShowOnlyNodesWithTemplates(config.isShowOnlyNodesWithTemplates());
        this.loader = this.factory.getLoader();
        this.store = this.factory.getStore();
        this.store.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                GWTJahiaNode s1 = (GWTJahiaNode)o1;
                GWTJahiaNode s2 = (GWTJahiaNode)o2;
                String key = config.getTreeColumnKeys().get(0);
                Object val1 = s1.get(key);
                Object val2 = s2.get(key);
                return Collator.getInstance().localeCompare(val1.toString(), val2.toString());
            }
        }));
        NodeColumnConfigList columns = new NodeColumnConfigList(config.getTreeColumns());
        columns.init();
        ((ColumnConfig)columns.get(0)).setRenderer(NodeColumnConfigList.NAME_TREEGRID_RENDERER);
        this.m_tree = this.factory.getTreeGrid(new ColumnModel((List)columns));
        this.m_tree.setHideHeaders(true);
        this.m_tree.setIconProvider((ModelIconProvider)ContentModelIconProvider.getInstance());
        if (columns.getAutoExpand() != null) {
            this.m_tree.setAutoExpandColumn(columns.getAutoExpand());
        }
        this.m_tree.setBorders(false);
        this.m_tree.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection() != null && selectionChangedEvent.getSelection().size() > 0) {
                    container.expandTab(RepositoryTab.this);
                }
                RepositoryTab.this.getLinker().onTreeItemSelected();
            }
        });
        this.setScrollMode(Style.Scroll.NONE);
        this.setHeadingHtml(repo.getTitle());
        this.getHeader().addTool((Component)new ToolButton("x-tool-refresh", (SelectionListener)new SelectionListener<IconButtonEvent>(){

            public void componentSelected(IconButtonEvent event) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("refreshAll", true);
                RepositoryTab.this.refresh(data);
            }
        }));
        this.add((Component)this.m_tree);
        this.config = config;
    }

    protected boolean isNodeTypeAllowed(GWTJahiaNode selectedNode) {
        if (selectedNode == null) {
            return true;
        }
        return !(this.config.getForbiddenNodeTypesForDragAndDrop() != null && selectedNode.isNodeType(this.config.getForbiddenNodeTypesForDragAndDrop()) || this.config.getAllowedNodeTypesForDragAndDrop() != null && !selectedNode.isNodeType(this.config.getAllowedNodeTypesForDragAndDrop()));
    }

    public void init() {
        this.factory.setDisplayHiddenTypes(this.getLinker() != null && this.getLinker().isDisplayHiddenTypes());
        this.loader.load();
        if (this.getLinker().getDndListener() != null) {
            TreeGridDragSource source = new TreeGridDragSource((Component)this.m_tree){

                protected void onDragStart(DNDEvent e) {
                    super.onDragStart(e);
                    List l = (List)e.getData();
                    ArrayList<GWTJahiaNode> r = new ArrayList<GWTJahiaNode>();
                    for (BaseTreeModel model : l) {
                        GWTJahiaNode jahiaNode = (GWTJahiaNode)model.get("model");
                        if (!RepositoryTab.this.isNodeTypeAllowed(jahiaNode) || !PermissionsUtils.isPermitted("jcr:removeNode", jahiaNode.getPermissions())) {
                            e.setCancelled(true);
                            break;
                        }
                        r.add(jahiaNode);
                    }
                    e.setData(r);
                }
            };
            source.addDNDListener(this.getLinker().getDndListener());
            TreeGridDropTarget target = new TreeGridDropTarget(this.m_tree){

                protected void handleInsert(DNDEvent dndEvent, TreeGrid.TreeNode treeNode) {
                    this.handleAppend(dndEvent, treeNode);
                }

                protected void handleAppend(DNDEvent event, TreeGrid.TreeNode item) {
                    super.handleAppend(event, item);
                    List list = (List)event.getData();
                    for (GWTJahiaNode source : list) {
                        GWTJahiaNode target = (GWTJahiaNode)this.activeItem.getModel();
                        if (target.getPath().startsWith(source.getPath()) || source.getPath().equals(target.getPath() + "/" + source.getName())) {
                            event.getStatus().setStatus(false);
                            continue;
                        }
                        HashSet<String> constraints = new HashSet<String>(source.getInheritedNodeTypes());
                        constraints.addAll(source.getNodeTypes());
                        constraints.retainAll(Arrays.asList(target.getChildConstraints().split(" ")));
                        if (!constraints.isEmpty()) continue;
                        event.getStatus().setStatus(false);
                    }
                }

                protected void handleAppendDrop(DNDEvent dndEvent, TreeGrid.TreeNode treeNode) {
                    if (dndEvent.getStatus().getStatus()) {
                        ContentActions.move(RepositoryTab.this.getLinker(), (List)dndEvent.getData(), (GWTJahiaNode)treeNode.getModel());
                        RepositoryTab.this.loader.load();
                    }
                }

                protected void handleInsertDrop(DNDEvent event, TreeGrid.TreeNode item, int index) {
                }
            };
            target.setFeedback(DND.Feedback.BOTH);
            target.setAllowSelfAsSource(true);
            target.setAutoExpand(true);
        }
    }

    public void openAndSelectItem(final Object item) {
        GWTJahiaNode openItem = (GWTJahiaNode)item;
        if (this.getSelectedItem() != null && openItem.getPath().startsWith(this.getSelectedItem().getPath())) {
            if (this.m_tree.isExpanded((ModelData)this.getSelectedItem())) {
                GWTJahiaNode gItem = (GWTJahiaNode)this.store.findModel((ModelData)((GWTJahiaNode)item));
                Log.debug((String)("expand: " + gItem.getPath()));
                this.m_tree.getSelectionModel().select((ModelData)gItem, false);
            } else {
                this.m_tree.addListener(Events.Expand, (Listener)new Listener<TreeGridEvent>(){

                    public void handleEvent(TreeGridEvent le) {
                        RepositoryTab.this.m_tree.removeListener(Events.Expand, (Listener)this);
                        GWTJahiaNode gItem = (GWTJahiaNode)RepositoryTab.this.store.findModel((ModelData)((GWTJahiaNode)item));
                        Log.debug((String)("expand: " + gItem.getPath()));
                        RepositoryTab.this.m_tree.getSelectionModel().select((ModelData)gItem, false);
                    }
                });
                this.m_tree.setExpanded((ModelData)this.getSelectedItem(), true);
            }
        }
    }

    public void refresh(Map<String, Object> data) {
        boolean refresh = true;
        if (data != null && (data.containsKey("refreshMain") || data.containsKey("refreshAll"))) {
            refresh = this.isExpanded();
        }
        if (refresh) {
            List<String> selectedPath = this.factory.getSelectedPath();
            this.factory.getStore().removeAll();
            this.factory.setSelectedPath(selectedPath);
            this.factory.setDisplayHiddenTypes(this.getLinker() != null && this.getLinker().isDisplayHiddenTypes());
            this.loader.load();
        }
    }

    public GWTRepository getRepository() {
        return this.repository;
    }

    public GWTJahiaNode getSelectedItem() {
        List selection = this.m_tree.getSelectionModel().getSelection();
        if (selection != null && selection.size() > 0) {
            return (GWTJahiaNode)selection.get(0);
        }
        return null;
    }

    private ManagerLinker getLinker() {
        return this.folderTreeContainer.getLinker();
    }

    public void removeSelection() {
        this.m_tree.getSelectionModel().deselectAll();
    }
}

