/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content.compare;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.compare.VersionViewer;
import org.jahia.ajax.gwt.client.widget.content.util.ContentHelper;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;

public class CompareEngine
extends Window {
    public static final int BUTTON_HEIGHT = 24;
    private GWTJahiaNode node;
    private Linker linker = null;
    private String locale;
    private VersionViewer leftPanel;
    protected ButtonBar buttonBar;
    private String uuid;
    private String path;
    private Date versionDate = null;
    private NodeHolder engine = null;
    private String workspace = null;
    private String versionLabel = null;
    private boolean refreshOpener = false;
    private VersionViewer rightPanel;

    public CompareEngine(GWTJahiaNode node, String locale, Linker linker, boolean displayVersionSelector, boolean displayTwoPanels) {
        this.linker = linker;
        this.node = node;
        this.locale = locale;
        this.init(displayVersionSelector, displayTwoPanels);
    }

    public CompareEngine(String uuid, String locale, boolean displayVersionSelector, String path) {
        this.locale = locale;
        this.uuid = uuid;
        this.path = path;
        this.init(displayVersionSelector, true);
    }

    public CompareEngine(String uuid, String locale, boolean displayVersionSelector, String path, Date versionDate, NodeHolder engine, String workspace, String versionLabel) {
        this.locale = locale;
        this.uuid = uuid;
        this.path = path;
        this.versionDate = versionDate;
        this.engine = engine;
        this.workspace = workspace;
        this.versionLabel = versionLabel;
        this.init(displayVersionSelector, true);
    }

    protected void init(boolean displayVersionSelector, boolean displayTwoPanels) {
        this.setLayout((Layout)new RowLayout(Style.Orientation.HORIZONTAL));
        this.addStyleName("compare-engine");
        this.setBodyBorder(false);
        int windowHeight = com.google.gwt.user.client.Window.getClientHeight() - 10;
        int windowWidth = com.google.gwt.user.client.Window.getClientWidth() - 10;
        this.setSize(windowWidth, windowHeight);
        this.setClosable(true);
        this.setResizable(true);
        this.setModal(true);
        this.setMaximizable(true);
        String title = Messages.get("label.compare", "Compare ");
        if (this.node != null) {
            this.setHeadingHtml(title + this.node.getPath());
        } else {
            this.setHeadingHtml(title + this.path);
        }
        this.leftPanel = this.node != null ? new VersionViewer(this.node, this.linker.getSelectionContext().getSingleSelection().getLanguageCode(), this.linker, "live", false, displayVersionSelector, this) : new VersionViewer(this.uuid, this.locale, this.workspace != null ? this.workspace : "live", false, displayVersionSelector, this.versionDate, this, this.versionLabel);
        this.add((Widget)this.leftPanel, (LayoutData)new RowData(displayTwoPanels ? 0.5 : 1.0, 1.0));
        if (displayTwoPanels) {
            this.rightPanel = this.node != null ? new VersionViewer(this.node, this.linker.getSelectionContext().getSingleSelection().getLanguageCode(), this.linker, displayVersionSelector ? "live" : "default", true, displayVersionSelector, this){

                @Override
                public String getCompareWith() {
                    return CompareEngine.this.leftPanel.getInnerHTML();
                }
            } : new VersionViewer(this.uuid, this.locale, "default", true, displayVersionSelector, null, this, null){

                @Override
                public String getCompareWith() {
                    return CompareEngine.this.leftPanel.getInnerHTML();
                }
            };
            this.add((Widget)this.rightPanel, (LayoutData)new RowData(0.5, 1.0));
        }
        this.layout();
    }

    protected void onHide() {
        super.onHide();
        if (this.refreshOpener) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (this.uuid != null) {
                ContentHelper.sendContentModificationEvent(this.uuid, this.path, null, "version", null);
            }
            data.put("refreshAll", true);
            if (this.engine != null) {
                this.engine.close();
                this.engine.getLinker().refresh(data);
            }
            if (this.linker != null) {
                this.linker.refresh(data);
            }
        }
    }

    public void show() {
        super.show();
        this.maximize();
    }

    public void setRefreshOpener(boolean refreshOpener) {
        this.refreshOpener = refreshOpener;
    }

    protected VersionViewer getLeftPanel() {
        return this.leftPanel;
    }

    protected VersionViewer getRightPanel() {
        return this.rightPanel;
    }
}

