/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.RpcMap;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreFilter;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.CreateContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.form.CodeMirrorField;

public class CodeEditorTabItem
extends EditEngineTabItem {
    private static final long serialVersionUID = 5207870064789655518L;
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_SIZE_VALUE = "11px";
    private String codePropertyName;
    private String stubType;
    private String codeMirrorMode = "jsp";
    private Map<String, String> availableCodeMirrorModes;
    private GWTJahiaNode gwtJahiaNode;
    private transient CodeMirrorField codeField;
    private transient GWTJahiaNodeProperty codeProperty;
    private transient Map<String, List<GWTJahiaValueDisplayBean>> snippets;
    private transient ComboBox<GWTJahiaValueDisplayBean> snippetType;
    private transient ComboBox<GWTJahiaValueDisplayBean> mirrorTemplates;
    private transient boolean readOnly;

    public CodeEditorTabItem() {
        this.setHandleCreate(true);
    }

    @Override
    public void init(final NodeHolder engine, final AsyncTabItem tab, String locale) {
        this.gwtJahiaNode = engine.getNode();
        tab.setLayout((Layout)new BorderLayout());
        tab.setScrollMode(Style.Scroll.AUTO);
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(10);
        horizontalPanel.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        tab.add((Widget)horizontalPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 40.0f));
        final HorizontalPanel actions = new HorizontalPanel();
        actions.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        horizontalPanel.add((Widget)actions);
        if (!tab.isProcessed()) {
            GWTJahiaNodeProperty typeName = engine.getProperties().get("nodeTypeName");
            if (typeName == null) {
                typeName = engine.getPresetProperties().get("nodeTypeName");
            }
            this.codeProperty = engine.getProperties().containsKey(this.codePropertyName) ? engine.getProperties().get(this.codePropertyName) : new GWTJahiaNodeProperty(this.codePropertyName, "", 1);
            Button indentButton = new Button(Messages.get("label.indentAll"));
            indentButton.addStyleName("button-indent");
            indentButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent buttonEvent) {
                    if (CodeEditorTabItem.this.codeField != null) {
                        CodeEditorTabItem.this.codeField.indent();
                    }
                }
            });
            if (this.stubType != null) {
                final Button addAllButton = new Button(Messages.get("label.addAll"));
                addAllButton.addStyleName("button-addAll");
                final Button addButton = new Button(Messages.get("label.add"));
                addButton.addStyleName("button-add");
                this.snippetType = new ComboBox();
                this.snippetType.setTypeAhead(true);
                this.snippetType.getListView().setStyleAttribute(FONT_SIZE, FONT_SIZE_VALUE);
                this.snippetType.setTriggerAction(ComboBox.TriggerAction.ALL);
                this.snippetType.setForceSelection(true);
                this.snippetType.setWidth(200);
                this.snippetType.removeAllListeners();
                this.snippetType.setStore(new ListStore());
                this.snippetType.setAllowBlank(false);
                this.snippetType.setDisplayField("display");
                this.snippetType.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

                    public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> se) {
                        CodeEditorTabItem.this.mirrorTemplates.clear();
                        CodeEditorTabItem.this.mirrorTemplates.getStore().removeAll();
                        CodeEditorTabItem.this.mirrorTemplates.getStore().add((List)CodeEditorTabItem.this.snippets.get(((GWTJahiaValueDisplayBean)se.getSelectedItem()).getValue()));
                        if (CodeEditorTabItem.this.mirrorTemplates.getStore().getModels().size() > 0) {
                            addAllButton.enable();
                            CodeEditorTabItem.this.mirrorTemplates.setEmptyText(Messages.get("label.stub.choose.codeTemplate"));
                        } else {
                            addAllButton.disable();
                        }
                        addButton.disable();
                    }
                });
                this.mirrorTemplates = new ComboBox<GWTJahiaValueDisplayBean>(){

                    public void doQuery(String q, boolean forceAll) {
                        final String query = q;
                        StoreFilter<GWTJahiaValueDisplayBean> filter = new StoreFilter<GWTJahiaValueDisplayBean>(){

                            public boolean select(Store<GWTJahiaValueDisplayBean> store, GWTJahiaValueDisplayBean parent, GWTJahiaValueDisplayBean item, String property) {
                                return item.getDisplay().contains(query);
                            }
                        };
                        if (q == null) {
                            q = "";
                        }
                        FieldEvent fe = new FieldEvent((Field)this);
                        fe.setValue((Object)q);
                        if (!this.fireEvent(Events.BeforeQuery, (ComponentEvent)fe)) {
                            return;
                        }
                        if (q.length() >= 1) {
                            if (!q.equals(this.lastQuery)) {
                                this.lastQuery = q;
                                this.store.clearFilters();
                                if (this.store.getFilters() != null) {
                                    this.store.getFilters().clear();
                                }
                                this.store.addFilter((StoreFilter)filter);
                                this.store.applyFilters(this.getDisplayField());
                                this.expand();
                            }
                        } else {
                            this.lastQuery = "";
                            this.store.clearFilters();
                            if (this.store.getFilters() != null) {
                                this.store.getFilters().clear();
                            }
                            this.expand();
                        }
                    }
                };
                this.mirrorTemplates.setTypeAhead(true);
                this.mirrorTemplates.getListView().setStyleAttribute(FONT_SIZE, FONT_SIZE_VALUE);
                this.mirrorTemplates.setTriggerAction(ComboBox.TriggerAction.ALL);
                this.mirrorTemplates.setForceSelection(true);
                this.mirrorTemplates.setWidth(300);
                this.mirrorTemplates.removeAllListeners();
                this.mirrorTemplates.setStore(new ListStore());
                this.mirrorTemplates.getStore().sort("display", Style.SortDir.ASC);
                this.mirrorTemplates.setAllowBlank(true);
                this.mirrorTemplates.setDisplayField("display");
                String path = engine.isExistingNode() ? engine.getNode().getPath() : engine.getTargetNode().getPath();
                String nodeType = typeName != null ? typeName.getValues().get(0).getString() : null;
                JahiaContentManagementService.App.getInstance().initializeCodeEditor(path, !engine.isExistingNode(), nodeType, this.stubType, (AsyncCallback<RpcMap>)new BaseAsyncCallback<RpcMap>(){

                    public void onSuccess(RpcMap result) {
                        if (!result.isEmpty() && result.get("snippets") != null) {
                            CodeEditorTabItem.this.snippets = (Map)result.get("snippets");
                            for (String type : CodeEditorTabItem.this.snippets.keySet()) {
                                CodeEditorTabItem.this.snippetType.getStore().add((ModelData)new GWTJahiaValueDisplayBean(type, Messages.get("label.snippetType." + type, type)));
                            }
                            CodeEditorTabItem.this.snippetType.setValue((ModelData)((GWTJahiaValueDisplayBean)CodeEditorTabItem.this.snippetType.getStore().getAt(0)));
                            addButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                                public void componentSelected(ButtonEvent buttonEvent) {
                                    if (CodeEditorTabItem.this.mirrorTemplates.getValue() != null) {
                                        CodeEditorTabItem.this.codeField.insertProperty(((GWTJahiaValueDisplayBean)CodeEditorTabItem.this.mirrorTemplates.getValue()).getValue());
                                    }
                                }
                            });
                            Label label = new Label(Messages.get("label.snippetType", "Snippet Type"));
                            label.setStyleAttribute(CodeEditorTabItem.FONT_SIZE, CodeEditorTabItem.FONT_SIZE_VALUE);
                            actions.add((Widget)label);
                            actions.add((Widget)CodeEditorTabItem.this.snippetType);
                            label = new Label(Messages.get("label.codeMirrorTemplates", "Code Template"));
                            label.setStyleAttribute(CodeEditorTabItem.FONT_SIZE, CodeEditorTabItem.FONT_SIZE_VALUE);
                            actions.add((Widget)label);
                            actions.add((Widget)CodeEditorTabItem.this.mirrorTemplates);
                            addButton.disable();
                            CodeEditorTabItem.this.mirrorTemplates.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

                                public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> se) {
                                    addButton.enable();
                                }
                            });
                            actions.add((Widget)addButton);
                            addAllButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                                public void componentSelected(ButtonEvent ce) {
                                    StringBuilder s = new StringBuilder();
                                    for (GWTJahiaValueDisplayBean value : CodeEditorTabItem.this.mirrorTemplates.getStore().getModels()) {
                                        s.append(value.getValue()).append("\n");
                                    }
                                    CodeEditorTabItem.this.codeField.insertProperty(s.toString());
                                }
                            });
                            actions.add((Widget)addAllButton);
                        }
                        if (!engine.getProperties().containsKey(CodeEditorTabItem.this.codePropertyName)) {
                            Map stubs = (Map)result.get("stubs");
                            if (stubs.size() == 1) {
                                CodeEditorTabItem.this.codeProperty = new GWTJahiaNodeProperty(CodeEditorTabItem.this.codePropertyName, (String)stubs.values().iterator().next(), 1);
                                CodeEditorTabItem.this.initEditor(tab);
                            } else if (stubs.size() > 1) {
                                actions.hide();
                                final LayoutContainer w = new LayoutContainer((Layout)new CenterLayout());
                                final ComboBox stubsCombo = new ComboBox();
                                stubsCombo.setWidth(300);
                                stubsCombo.setTypeAhead(true);
                                stubsCombo.getListView().setStyleAttribute(CodeEditorTabItem.FONT_SIZE, CodeEditorTabItem.FONT_SIZE_VALUE);
                                stubsCombo.setTriggerAction(ComboBox.TriggerAction.ALL);
                                stubsCombo.setForceSelection(true);
                                stubsCombo.setStore(new ListStore());
                                stubsCombo.setDisplayField("display");
                                stubsCombo.setEmptyText(Messages.get("label.stub.select"));
                                for (String stub : stubs.keySet()) {
                                    String display;
                                    String viewName;
                                    if (stub.indexOf(47) != -1) {
                                        viewName = stub.substring(stub.indexOf("."), stub.lastIndexOf("."));
                                        display = Messages.get("label.stub" + viewName);
                                    } else {
                                        display = Messages.get("label.stub.default");
                                        viewName = "";
                                    }
                                    GWTJahiaValueDisplayBean value = new GWTJahiaValueDisplayBean((String)stubs.get(stub), display);
                                    value.set("viewName", viewName);
                                    stubsCombo.getStore().add((ModelData)value);
                                }
                                stubsCombo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

                                    public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> se) {
                                        w.removeFromParent();
                                        CodeEditorTabItem.this.initEditor(tab);
                                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                            public void execute() {
                                                CodeEditorTabItem.this.codeField.insertProperty(((GWTJahiaValueDisplayBean)stubsCombo.getValue()).getValue());
                                            }
                                        });
                                        if (engine instanceof CreateContentEngine) {
                                            CreateContentEngine createContentEngine = (CreateContentEngine)engine;
                                            createContentEngine.setTargetName(createContentEngine.getTargetName() + ((GWTJahiaValueDisplayBean)stubsCombo.getValue()).get("viewName"));
                                        }
                                        actions.show();
                                        CodeEditorTabItem.this.codeField.show();
                                    }
                                });
                                w.add((Widget)stubsCombo);
                                tab.add((Widget)w, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
                                tab.layout();
                            } else {
                                CodeEditorTabItem.this.initEditor(tab);
                            }
                        } else {
                            CodeEditorTabItem.this.initEditor(tab);
                        }
                    }
                });
            } else {
                if (this.availableCodeMirrorModes != null && this.availableCodeMirrorModes.size() > 0) {
                    actions.add((Widget)new Label(Messages.get("label.selectSyntaxHighlighting", "Select syntax highlighting") + ": "));
                    actions.add(this.getModeCombo());
                }
                this.initEditor(tab);
            }
            if (this.isEditable(this.gwtJahiaNode)) {
                actions.add((Widget)indentButton);
            }
            actions.show();
            tab.setProcessed(true);
            boolean bl = this.readOnly = engine.getNode() != null && engine.getNode().isLocked() != false;
            if (this.codeField != null) {
                this.codeField.setReadOnly(this.readOnly);
            }
        }
    }

    private ComboBox<GWTJahiaValueDisplayBean> getModeCombo() {
        ComboBox modes = new ComboBox();
        modes.setTypeAhead(true);
        modes.getListView().setStyleAttribute(FONT_SIZE, FONT_SIZE_VALUE);
        modes.setTriggerAction(ComboBox.TriggerAction.ALL);
        modes.setForceSelection(true);
        modes.setStore(new ListStore());
        modes.setDisplayField("display");
        for (Map.Entry<String, String> m : this.availableCodeMirrorModes.entrySet()) {
            String label = m.getValue();
            if (label == null || label.length() == 0) {
                label = Messages.get("label.none", "none");
            }
            GWTJahiaValueDisplayBean option = new GWTJahiaValueDisplayBean(m.getKey(), label);
            modes.getStore().add((ModelData)option);
            if (this.codeMirrorMode == null || !this.codeMirrorMode.equals(m.getKey())) continue;
            ArrayList<GWTJahiaValueDisplayBean> selection = new ArrayList<GWTJahiaValueDisplayBean>();
            selection.add(option);
            modes.setSelection(selection);
        }
        modes.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> se) {
                CodeEditorTabItem.this.codeField.setMode(((GWTJahiaValueDisplayBean)se.getSelectedItem()).getValue());
            }
        });
        return modes;
    }

    private void initEditor(AsyncTabItem tab) {
        if (this.isEditable(this.gwtJahiaNode)) {
            this.codeField = new CodeMirrorField();
            this.codeField.setWidth("95%");
            this.codeField.setHeight("90%");
            this.codeField.setMode(this.codeMirrorMode);
            List<GWTJahiaNodePropertyValue> values = this.codeProperty.getValues();
            if (!values.isEmpty()) {
                this.codeField.setValue(values.get(0).getString());
            }
            tab.add((Widget)this.codeField, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
            tab.layout();
            tab.show();
            this.codeField.setReadOnly(this.readOnly);
        } else {
            String url = this.gwtJahiaNode.getUrl();
            HTML link = new HTML(Messages.get("sizeLimit.message") + "<br /><br /><a href=\"" + url + "\" target=\"_blank\">" + SafeHtmlUtils.htmlEscape((String)this.gwtJahiaNode.getName()) + "</a>");
            tab.add((Widget)link, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
            tab.layout();
            tab.show();
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed) {
            this.codeField = null;
            this.codeProperty = null;
            this.snippets = null;
            this.snippetType = null;
            this.mirrorTemplates = null;
        }
        super.setProcessed(processed);
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> chidren, GWTJahiaNodeACL acl) {
        if (this.codeField != null) {
            this.codeProperty.setValue(new GWTJahiaNodePropertyValue((String)this.codeField.getValue()));
            changedProperties.add(this.codeProperty);
        }
    }

    public boolean isEditable(GWTJahiaNode node) {
        return node == null || node.isNodeType("jnt:file") && node.getSize() <= JahiaGWTParameters.getStudioMaxDisplayableFileSize();
    }

    public void setCodePropertyName(String codePropertyName) {
        this.codePropertyName = codePropertyName;
    }

    public void setStubType(String stubType) {
        this.stubType = stubType;
    }

    public void setCodeMirrorMode(String codeMirrorMode) {
        this.codeMirrorMode = codeMirrorMode;
    }

    public void setAvailableCodeMirrorModes(Map<String, String> availableCodeMirrorModes) {
        this.availableCodeMirrorModes = availableCodeMirrorModes;
    }
}

