/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaCreateEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.ButtonItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;

public class CreateContentEngine
extends AbstractContentEngine {
    protected GWTJahiaNodeType type = null;
    protected String targetName = null;
    protected boolean createInParentAndMoveBefore = false;
    private boolean systemNameReadOnly;
    private int childCount;
    private int listLimit;

    public CreateContentEngine(GWTEngineConfiguration configuration, Linker linker, GWTJahiaNode parent, GWTJahiaNodeType type, Map<String, GWTJahiaNodeProperty> props, String targetName, boolean createInParentAndMoveBefore, EngineContainer engineContainer, boolean skipRefreshOnSave, boolean systemNameReadOnly) {
        super(configuration, linker, createInParentAndMoveBefore ? parent.getPath().substring(0, parent.getPath().lastIndexOf(47)) : parent.getPath(), skipRefreshOnSave);
        this.existingNode = false;
        this.systemNameReadOnly = systemNameReadOnly;
        this.targetNode = parent;
        this.type = type;
        if (!"*".equals(targetName)) {
            this.targetName = targetName;
        }
        this.createInParentAndMoveBefore = createInParentAndMoveBefore;
        this.setId("JahiaGxtCreateContentEngine");
        this.nodeTypes = new ArrayList(1);
        this.nodeTypes.add(type);
        this.presetProperties = new HashMap<String, GWTJahiaNodeProperty>(props);
        this.heading = Messages.get("label.add", "Add") + ": " + type.getLabel();
        this.init(engineContainer);
        this.addStyleName("create-content-engine");
        this.loadEngine();
    }

    @Override
    public void close() {
        super.close();
        JahiaGWTParameters.removeEngineLanguage();
        this.container.closeEngine();
    }

    protected void initTabs() {
        for (GWTEngineTab tabConfig : this.config.getEngineTabs()) {
            EditEngineTabItem tabItem = tabConfig.getTabItem();
            if (!tabConfig.showInEngine() || tabConfig.getRequiredPermission() != null && !PermissionsUtils.isPermitted(tabConfig.getRequiredPermission(), JahiaGWTParameters.getSiteNode()) || !tabItem.isHandleCreate() || !tabItem.getHideForTypes().isEmpty() && tabItem.getHideForTypes().contains(this.type.getName()) || !tabItem.getShowForTypes().isEmpty() && !tabItem.getShowForTypes().contains(this.type.getName())) continue;
            this.tabs.add((TabItem)tabItem.create(tabConfig, this));
        }
        this.tabs.setSelection((TabItem)this.tabs.getItem(0));
    }

    @Override
    protected void initFooter() {
        List<Module> parentModules;
        for (ButtonItem buttonItem : this.config.getCreationButtons()) {
            BoxComponent button = buttonItem.create(this);
            this.buttons.add(button);
            this.buttonBar.add((Component)button);
        }
        for (ButtonItem buttonItem : this.config.getCommonButtons()) {
            this.buttonBar.add((Component)buttonItem.create(this));
        }
        List<Module> list = parentModules = ModuleHelper.getModulesByPath() != null ? ModuleHelper.getModulesByPath().get(this.parentPath) : null;
        if (parentModules != null && parentModules.size() == 1) {
            Module module = parentModules.get(0);
            this.childCount = module.getChildCount();
            this.listLimit = module.getListLimit();
        } else {
            this.childCount = 0;
            this.listLimit = -1;
        }
        this.setButtonsEnabled(false);
    }

    @Override
    protected void onLanguageChange(GWTJahiaLanguage previous) {
        this.handleLanguageChange(previous);
        this.fillCurrentTab();
    }

    private void loadEngine() {
        JahiaContentManagementService.App.getInstance().initializeCreateEngine(((GWTJahiaNodeType)this.nodeTypes.iterator().next()).getName(), this.parentPath, this.targetName, (AsyncCallback<GWTJahiaCreateEngineInitBean>)new BaseAsyncCallback<GWTJahiaCreateEngineInitBean>(){

            public void onSuccess(GWTJahiaCreateEngineInitBean result) {
                if (CreateContentEngine.this.closed) {
                    return;
                }
                CreateContentEngine.this.mixin = result.getMixin();
                CreateContentEngine.this.choiceListInitializersValues = result.getChoiceListInitializersValues();
                CreateContentEngine.this.defaultValues = result.getDefaultValues();
                CreateContentEngine.this.currentLanguageBean = result.getCurrentLocale();
                CreateContentEngine.this.defaultLanguageCode = result.getDefaultLanguageCode();
                CreateContentEngine.this.acl = result.getAcl();
                List<GWTJahiaLanguage> languages = result.getLanguages();
                CreateContentEngine.this.setAvailableLanguages(languages);
                CreateContentEngine.this.setButtonsEnabled(true);
                CreateContentEngine.this.initTabs();
                CreateContentEngine.this.tabs.addListener(Events.Select, (Listener)new Listener<ComponentEvent>(){

                    public void handleEvent(ComponentEvent event) {
                        CreateContentEngine.this.fillCurrentTab();
                    }
                });
                CreateContentEngine.this.nodeName = result.getDefaultName();
                CreateContentEngine.this.fillCurrentTab();
                CreateContentEngine.this.updateWipControls();
                CreateContentEngine.this.loaded();
            }

            @Override
            public void onApplicationFailure(Throwable caught) {
                Log.error((String)"Unable to load avalibale mixin", (Throwable)caught);
            }
        });
    }

    @Override
    public void setButtonsEnabled(boolean enabled) {
        for (BoxComponent button : this.buttons) {
            button.setEnabled(enabled);
        }
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public boolean isCreateInParentAndMoveBefore() {
        return this.createInParentAndMoveBefore;
    }

    public GWTJahiaNodeType getType() {
        return this.type;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public void setChildCount(int childCount) {
        this.childCount = childCount;
    }

    public int getListLimit() {
        return this.listLimit;
    }

    public boolean isSystemNameReadOnly() {
        return this.systemNameReadOnly;
    }

    @Override
    protected boolean isNodeOfJmixLastPublishedType() {
        return super.isNodeOfJmixLastPublishedType() || this.getType().getSuperTypes().contains("jmix:lastPublished");
    }
}

