/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.CreateContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.SaveButtonItem;

public class CreateResourceButtonItem
extends SaveButtonItem {
    private String fileExtension;

    @Override
    public BoxComponent create(final AbstractContentEngine engine) {
        Button button = new Button(Messages.get("label.save", "Save"));
        button.setHeight(24);
        button.addStyleName("button-save");
        button.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonOK());
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                GWTJahiaNode node = engine.getNode();
                if (node == null) {
                    node = engine.getTargetNode();
                }
                final String nodePath = node.getPath();
                final Window popup = new Window();
                popup.addStyleName("create-resource-save-modal");
                popup.setHeadingHtml(Messages.get("label.saveAs", "Save as..."));
                popup.setHeight(120);
                popup.setWidth(350);
                popup.setModal(true);
                FormPanel f = new FormPanel();
                f.setHeaderVisible(false);
                f.setBorders(false);
                final TextField name = new TextField();
                name.setFieldLabel(Messages.get("label.name", "Name"));
                name.setMinLength(1);
                f.add((Widget)name);
                Button b = new Button(Messages.get("label.submit", "submit"));
                b.addStyleName("button-submit");
                f.addButton(b);
                b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        LinkedHashMap<String, String> parentNodesType = new LinkedHashMap<String, String>();
                        parentNodesType.put(nodePath, "jnt:folder");
                        String finalName = (String)name.getValue();
                        if (CreateResourceButtonItem.this.fileExtension != null && !finalName.endsWith("." + CreateResourceButtonItem.this.fileExtension)) {
                            finalName = finalName + "." + CreateResourceButtonItem.this.fileExtension;
                        }
                        CreateResourceButtonItem.this.prepareAndSave(nodePath, finalName, parentNodesType, (CreateContentEngine)engine);
                        popup.hide();
                    }
                });
                Button c = new Button(Messages.get("label.cancel", "Cancel"));
                c.addStyleName("button-cancel");
                c.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent buttonEvent) {
                        popup.hide();
                    }
                });
                f.addButton(c);
                f.setButtonAlign(Style.HorizontalAlignment.CENTER);
                FormButtonBinding binding = new FormButtonBinding(f);
                binding.addButton(b);
                popup.add((Widget)f);
                popup.setFocusWidget((Widget)name);
                popup.show();
            }
        });
        return button;
    }

    protected void prepareAndSave(String parentPath, String nodeName, Map<String, String> parentNodesType, final CreateContentEngine engine) {
        HashSet<String> addedTypes = new HashSet<String>();
        HashSet<String> removedTypes = new HashSet<String>();
        for (TabItem tab : engine.getTabs().getItems()) {
            EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
            item.doSave(null, engine.getChangedProperties(), engine.getChangedI18NProperties(), addedTypes, removedTypes, null, engine.getAcl());
        }
        List<GWTJahiaNodeProperty> changedProperties = engine.getChangedProperties();
        List<GWTJahiaNodeProperty> properties = null;
        if (engine.getProperties().size() > 0) {
            HashMap<String, GWTJahiaNodeProperty> engineProperties = new HashMap<String, GWTJahiaNodeProperty>(engine.getProperties());
            for (GWTJahiaNodeProperty changed : changedProperties) {
                GWTJahiaNodeProperty prop = (GWTJahiaNodeProperty)engineProperties.get(changed.getName());
                if (prop == null) continue;
                prop.setValues(changed.getValues());
            }
            properties = new ArrayList(engineProperties.values());
        } else {
            properties = changedProperties;
        }
        JahiaContentManagementService.App.getInstance().createNode(parentPath, nodeName, engine.getType().getName(), null, engine.getAcl(), properties, engine.changedI18NProperties, null, parentNodesType, false, new AsyncCallback<GWTJahiaNode>(){

            public void onFailure(Throwable throwable) {
                MessageBox.alert((String)Messages.get("label.error.processingRequestError", "An error occurred while processing your request"), (String)throwable.getMessage(), null).getDialog().addStyleName("engine-save-error");
            }

            public void onSuccess(GWTJahiaNode gwtJahiaNode) {
                Linker linker = engine.getLinker();
                engine.close();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("node", gwtJahiaNode);
                linker.refresh(data);
            }
        });
    }

    @Override
    protected void prepareAndSave(AbstractContentEngine engine, boolean closeAfterSave) {
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }
}

