/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.CreateContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineValidation;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;

public class CustomEditEngineTabItem
extends EditEngineTabItem {
    private boolean handleMultipleSelection;
    private String onInitMethodName;
    private String onLanguageChangeMethodName;
    private String doSaveMethodName;
    private String doValidateMethodName;
    private transient boolean inited = false;
    private transient String languageChanged;

    @Override
    public void init(NodeHolder engine, AsyncTabItem tab, String language) {
        if (!this.inited || this.languageChanged != null) {
            Element element = null;
            JsArrayString types = (JsArrayString)JsArrayString.createArray().cast();
            for (GWTJahiaNodeType type : engine.getNodeTypes()) {
                types.push(type.getName());
            }
            if (this.languageChanged == null) {
                this.languageChanged = JahiaGWTParameters.getLanguage();
            }
            String methodName = this.inited ? this.onLanguageChangeMethodName : this.onInitMethodName;
            JavaScriptObject param = null;
            if (engine.isExistingNode() && !engine.isMultipleSelection()) {
                param = CustomEditEngineTabItem.convertExistingNode(engine.getNode(), engine.getProperties(), types, language);
            } else if (!engine.isExistingNode() && engine instanceof CreateContentEngine) {
                param = CustomEditEngineTabItem.convertNewNode(((CreateContentEngine)engine).getParentPath(), engine.getNodeName(), types, language);
            }
            element = (Element)CustomEditEngineTabItem.doCall(methodName, param).cast();
            if (element != null) {
                while (tab.getElement().getChildCount() > 0) {
                    tab.getElement().removeChild(tab.getElement().getChild(0));
                }
                tab.getElement().appendChild((Node)element);
            }
            this.inited = true;
            this.languageChanged = null;
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed) {
            this.inited = false;
            this.languageChanged = null;
        }
        super.setProcessed(processed);
    }

    @Override
    public void onLanguageChange(String language, TabItem tabItem) {
        this.languageChanged = language;
    }

    @Override
    public void doValidate(List<EngineValidation.ValidateResult> validateResult, NodeHolder engine, TabItem tab, String selectedLanguage, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, TabPanel tabs) {
        if (this.doValidateMethodName != null) {
            CustomEditEngineTabItem.doCall(this.doValidateMethodName, CustomEditEngineTabItem.getValidateOperations(validateResult, engine, tab, selectedLanguage, changedI18NProperties));
        }
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> children, GWTJahiaNodeACL acl) {
        if (this.doSaveMethodName != null) {
            LinkedHashMap<String, GWTJahiaNode> childrenMap = new LinkedHashMap<String, GWTJahiaNode>();
            CustomEditEngineTabItem.doCall(this.doSaveMethodName, CustomEditEngineTabItem.getWriteOperations(node, changedProperties, changedI18NProperties, addedTypes, removedTypes, childrenMap));
            if (!childrenMap.isEmpty()) {
                if (node != null) {
                    if (node.getChildren() != null && node.getChildren().size() > 0) {
                        LinkedList<GWTJahiaNode> newChildren = new LinkedList<GWTJahiaNode>();
                        for (ModelData modelData : node.getChildren()) {
                            GWTJahiaNode alreadyExistChild = (GWTJahiaNode)modelData;
                            if (childrenMap.get(alreadyExistChild.getUUID()) != null) {
                                newChildren.add((GWTJahiaNode)childrenMap.get(alreadyExistChild.getUUID()));
                                childrenMap.remove(alreadyExistChild.getUUID());
                                continue;
                            }
                            newChildren.add(alreadyExistChild);
                        }
                        if (childrenMap.size() > 0) {
                            for (GWTJahiaNode gWTJahiaNode : childrenMap.values()) {
                                newChildren.add(gWTJahiaNode);
                            }
                        }
                        for (GWTJahiaNode gWTJahiaNode : newChildren) {
                            node.add((ModelData)gWTJahiaNode);
                        }
                    } else {
                        for (GWTJahiaNode child : childrenMap.values()) {
                            node.add((ModelData)child);
                        }
                    }
                    node.set("includeChildren", Boolean.TRUE);
                } else {
                    children.addAll(childrenMap.values());
                }
            }
        }
    }

    public static native JavaScriptObject doCall(String var0, Object var1);

    @Override
    public boolean isHandleMultipleSelection() {
        return this.handleMultipleSelection;
    }

    public void setHandleMultipleSelection(boolean handleMultipleSelection) {
        this.handleMultipleSelection = handleMultipleSelection;
    }

    public void setOnInitMethodName(String onInitMethodName) {
        this.onInitMethodName = onInitMethodName;
    }

    public void setOnLanguageChangeMethodName(String onLanguageChangeMethodName) {
        this.onLanguageChangeMethodName = onLanguageChangeMethodName;
    }

    public void setDoSaveMethodName(String doSaveMethodName) {
        this.doSaveMethodName = doSaveMethodName;
    }

    public void setDoValidateMethodName(String doValidateMethodName) {
        this.doValidateMethodName = doValidateMethodName;
    }

    public static void setProperty(List<GWTJahiaNodeProperty> changedProperties, String name, String value, int type) {
        changedProperties.add(new GWTJahiaNodeProperty(name, value, type));
    }

    public static Object getProperty(Map<String, GWTJahiaNodeProperty> properties, String name) {
        if (properties.containsKey(name)) {
            GWTJahiaNodeProperty property = properties.get(name);
            if (property.isMultiple()) {
                JsArrayString array = (JsArrayString)JsArrayString.createArray().cast();
                for (GWTJahiaNodePropertyValue value : property.getValues()) {
                    array.push(value.getString());
                }
                return array;
            }
            return property.getValues().get(0).getString();
        }
        return null;
    }

    public static void setI18NProperty(Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, String lang, String name, String value, int type) {
        if (!changedI18NProperties.containsKey(lang)) {
            changedI18NProperties.put(lang, new ArrayList());
        }
        changedI18NProperties.get(lang).add(new GWTJahiaNodeProperty(name, value, type));
    }

    private static void setChild(String uuid, String name, Map<String, GWTJahiaNode> children) {
        GWTJahiaNode node = new GWTJahiaNode();
        node.setUUID(uuid);
        node.setName(name);
        node.setNodeTypes(new ArrayList<String>());
        node.set("nodeLangCodeProperties", new HashMap());
        node.set("nodeProperties", new ArrayList());
        children.put(uuid, node);
    }

    public static void addChildMixin(String uuid, String mixin, Map<String, GWTJahiaNode> children) {
        children.get(uuid).getNodeTypes().add(mixin);
    }

    public static void setChildProperty(String uuid, String name, String value, int type, Map<String, GWTJahiaNode> children) {
        ((List)children.get(uuid).get("nodeProperties")).add(new GWTJahiaNodeProperty(name, value, type));
    }

    public static void addValidationError(List<EngineValidation.ValidateResult> validateResult, TabItem tab, String message) {
        EngineValidation.ValidateResult result = new EngineValidation.ValidateResult();
        result.canIgnore = false;
        result.errorTab = tab;
        result.message = message;
        validateResult.add(result);
    }

    public static native JavaScriptObject convertExistingNode(GWTJahiaNode var0, Map<String, GWTJahiaNodeProperty> var1, JsArrayString var2, String var3);

    public static native JavaScriptObject convertNewNode(String var0, String var1, JsArrayString var2, String var3);

    public static native JavaScriptObject getValidateOperations(List<EngineValidation.ValidateResult> var0, NodeHolder var1, TabItem var2, String var3, Map<String, List<GWTJahiaNodeProperty>> var4);

    public static native JavaScriptObject getWriteOperations(GWTJahiaNode var0, List<GWTJahiaNodeProperty> var1, Map<String, List<GWTJahiaNodeProperty>> var2, Set<String> var3, Set<String> var4, Map<String, GWTJahiaNode> var5);
}

