/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.GWTRenderResult;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.contentengine.PropertiesTabItem;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;

public class LayoutTabItem
extends PropertiesTabItem {
    private transient LayoutContainer ctn;
    private transient LayoutContainer htmlPreview;
    private transient SelectionChangedListener<GWTJahiaValueDisplayBean> listener;
    private String cssWrapper;

    @Override
    public AsyncTabItem create(GWTEngineTab engineTab, NodeHolder engine) {
        if (this.dataType == null) {
            this.dataType = Arrays.asList("layout");
        }
        return super.create(engineTab, engine);
    }

    @Override
    public void init(NodeHolder engine, AsyncTabItem tab, String language) {
        super.init(engine, tab, language);
        if (this.listener != null) {
            this.listener.selectionChanged(null);
        }
    }

    @Override
    public void attachPropertiesEditor(final NodeHolder engine, final AsyncTabItem tab) {
        if (engine.getNode() != null && engine.getLinker() instanceof EditLinker) {
            final PropertiesEditor.PropertyAdapterField templateField = this.propertiesEditor.getFieldsMap().get("j:view");
            final PropertiesEditor.PropertyAdapterField skinField = this.propertiesEditor.getFieldsMap().get("j:skin");
            final PropertiesEditor.PropertyAdapterField subNodesViewField = this.propertiesEditor.getFieldsMap().get("j:subNodesView");
            this.listener = new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

                public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> se) {
                    String template;
                    HashMap<String, List<String>> contextParams = new HashMap<String, List<String>>();
                    if (skinField != null && skinField.getValue() != null) {
                        contextParams.put("forcedSkin", Arrays.asList(((GWTJahiaValueDisplayBean)((ComboBox)skinField.getField()).getValue()).getValue()));
                    }
                    if (subNodesViewField != null && subNodesViewField.getValue() != null) {
                        contextParams.put("forcedSubNodesTemplate", Arrays.asList(((GWTJahiaValueDisplayBean)((ComboBox)subNodesViewField.getField()).getValue()).getValue()));
                    }
                    String string = template = templateField != null && templateField.getValue() != null ? ((GWTJahiaValueDisplayBean)((ComboBox)templateField.getField()).getValue()).getValue() : null;
                    if (engine.getNode() != null) {
                        JahiaContentManagementService.App.getInstance().getRenderedContent(engine.getNode().getPath(), null, LayoutTabItem.this.language, template, "preview", contextParams, false, null, null, null, (AsyncCallback<GWTRenderResult>)new BaseAsyncCallback<GWTRenderResult>(){

                            public void onSuccess(GWTRenderResult result) {
                                HTML html = new HTML(result.getResult());
                                LayoutTabItem.this.setHTML(html);
                                tab.layout();
                            }
                        });
                    } else {
                        LayoutTabItem.this.setHTML(null);
                    }
                }
            };
            if (templateField != null) {
                ((ComboBox)templateField.getField()).addSelectionChangedListener(this.listener);
            }
            if (skinField != null) {
                ((ComboBox)skinField.getField()).addSelectionChangedListener(this.listener);
            }
            if (subNodesViewField != null) {
                ((ComboBox)subNodesViewField.getField()).addSelectionChangedListener(this.listener);
            }
            tab.setLayout((Layout)new FillLayout());
            if (this.ctn == null) {
                this.ctn = new LayoutContainer((Layout)new FitLayout());
                tab.add((Widget)this.ctn);
                this.htmlPreview = new LayoutContainer();
                this.htmlPreview.addStyleName(this.cssWrapper);
                this.htmlPreview.setStyleAttribute("background-color", "white");
                FieldSet f = new FieldSet();
                f.addStyleName("x-panel");
                f.setHeadingHtml(Messages.get("label.preview", "Preview"));
                f.setScrollMode(Style.Scroll.AUTO);
                f.add((Widget)this.htmlPreview);
                tab.add((Widget)f);
            }
            this.ctn.add((Widget)this.propertiesEditor);
        } else {
            super.attachPropertiesEditor(engine, tab);
        }
    }

    public void setHTML(HTML html) {
        this.htmlPreview.removeAll();
        if (html != null) {
            this.htmlPreview.add((Widget)html);
        }
        this.htmlPreview.layout();
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed && this.langPropertiesEditorMap != null) {
            this.ctn = null;
            this.htmlPreview = null;
            this.listener = null;
        }
        super.setProcessed(processed);
    }

    public void setCssWrapper(String cssWrapper) {
        this.cssWrapper = cssWrapper;
    }
}

