/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.HBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.HBoxLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.ContentTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;

public class NamespaceTabItem
extends ContentTabItem {
    @Override
    protected void setNameField(NodeHolder engine, AsyncTabItem tab) {
        if (!engine.isMultipleSelection()) {
            String nodeName;
            tab.setLayout((Layout)new RowLayout());
            FormLayout fl = new FormLayout();
            fl.setLabelWidth(0);
            HBoxLayout hBoxLayout = new HBoxLayout();
            hBoxLayout.setHBoxLayoutAlign(HBoxLayout.HBoxLayoutAlign.MIDDLE);
            LayoutContainer panel = new LayoutContainer((Layout)hBoxLayout);
            if (this.nameText == null) {
                this.nameFieldSet = new FieldSet();
                this.nameFieldSet.setHeadingHtml(Messages.get("label.type.name", "Type name"));
                this.nameFieldSet.setLayout((Layout)fl);
                this.nameText = new NameField();
                this.nameText.addStyleName("JahiaGxtField_systemName");
                this.nameText.setWidth("250");
                ((NameField)this.nameText).setMaxLength(this.maxNameSize);
                ((NameField)this.nameText).setAllowBlank(false);
                this.nameText.setStyleAttribute("padding-left", "0");
                this.nameText.setFireChangeEventOnSetValue(true);
                panel.add((Widget)this.nameText, (LayoutData)new HBoxLayoutData(0, 5, 0, 5));
                this.name = new AdapterField((Widget)panel);
                this.name.setFieldLabel(Messages.get("label.type.name", "Type name"));
                FormData fd = new FormData("98%");
                fd.setMargins(new Margins(0));
                this.nameFieldSet.add((Widget)this.name, (LayoutData)fd);
                if (engine.getNode() != null && engine.getNode().isLocked().booleanValue()) {
                    this.nameText.setReadOnly(true);
                    if (this.autoUpdateName != null) {
                        this.autoUpdateName.setEnabled(false);
                    }
                }
            }
            if ((nodeName = engine.getNodeName()) != null && !nodeName.equals("primary-nodetype") && !nodeName.equals("mixin-nodetype")) {
                this.nameText.setValue((Object)nodeName);
            }
        }
    }

    private class NameField
    extends MultiField<String> {
        private transient SimpleComboBox<String> namespaces;
        private transient TextField<String> localName = new TextField();

        public NameField() {
            this.namespaces = new SimpleComboBox<String>(){

                public void markInvalid(String msg) {
                    NameField.this.localName.markInvalid(msg);
                }
            };
            this.namespaces.setTriggerAction(ComboBox.TriggerAction.ALL);
            JahiaContentManagementService.App.getInstance().getNamespaces(new AsyncCallback<List<String>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<String> result) {
                    result.remove(NameField.this.namespaces.getSimpleValue());
                    NameField.this.namespaces.add(result);
                }
            });
            this.add((Field)this.namespaces);
            this.add((Field)this.localName);
            this.localName.setValidator(new Validator(){

                public String validate(Field<?> field, String value) {
                    return value == null || !value.matches("[A-Za-z0-9_]+") ? Messages.get("label.error.invalidNodeTypeName", "The entered node type name is not valid. The value should match the following pattern: [A-Za-z0-9_]+") : null;
                }
            });
        }

        public String getValue() {
            return this.namespaces.getSimpleValue() == null || ((String)this.namespaces.getSimpleValue()).trim().equals("") ? (String)this.localName.getValue() : (String)this.namespaces.getSimpleValue() + ":" + (String)this.localName.getValue();
        }

        public void setValue(String value) {
            if (value != null && value.contains(":")) {
                String[] s = value.split(":");
                this.namespaces.add((Object)s[0]);
                this.namespaces.setSimpleValue((Object)s[0]);
                this.namespaces.select((ModelData)((SimpleComboValue)this.namespaces.getStore().findModel(s[0])));
                this.localName.setValue((Object)s[1]);
            } else {
                this.localName.setValue((Object)value);
            }
        }

        public void setMaxLength(int maxLength) {
            this.localName.setMaxLength(maxLength);
        }

        public void setAllowBlank(boolean allowBlank) {
            this.namespaces.setAllowBlank(allowBlank);
            this.localName.setAllowBlank(allowBlank);
        }
    }
}

