/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.seo.GWTJahiaUrlMapping;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.contentengine.UrlMappingEditor;

public class SeoTabItem
extends EditEngineTabItem {
    private static final long serialVersionUID = -3131345831935771996L;
    private transient UrlMappingEditor activeEditor;
    private transient Map<String, UrlMappingEditor> editorsByLanguage = new HashMap<String, UrlMappingEditor>(1);

    public SeoTabItem() {
        this.setHandleCreate(false);
    }

    @Override
    public void init(NodeHolder engine, AsyncTabItem tab, String locale) {
        if (engine.getNode() == null) {
            return;
        }
        UrlMappingEditor next = this.getEditor(engine, tab, locale);
        if (this.activeEditor != null) {
            if (this.activeEditor == next) {
                return;
            }
            this.activeEditor.setVisible(false);
        }
        next.setVisible(true);
        next.layout();
        this.activeEditor = next;
        tab.layout();
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed && this.editorsByLanguage != null) {
            this.editorsByLanguage.clear();
            this.activeEditor = null;
        }
        super.setProcessed(processed);
    }

    private UrlMappingEditor getEditor(NodeHolder engine, AsyncTabItem tab, String locale) {
        UrlMappingEditor editor = this.editorsByLanguage.get(locale);
        if (editor == null) {
            boolean editable = !engine.isExistingNode() || PermissionsUtils.isPermitted("jcr:modifyProperties", engine.getNode()) && engine.getNode().isLocked() == false;
            editor = new UrlMappingEditor(engine.getNode(), locale, editable);
            editor.setVisible(false);
            this.editorsByLanguage.put(locale, editor);
            tab.add((Widget)editor);
        }
        return editor;
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> chidren, GWTJahiaNodeACL acl) {
        HashSet<String> langs = new HashSet<String>(this.editorsByLanguage.keySet());
        if (langs.isEmpty()) {
            return;
        }
        HashMap<String, List<GWTJahiaUrlMapping>> mappings = new HashMap<String, List<GWTJahiaUrlMapping>>();
        for (Map.Entry<String, UrlMappingEditor> editor : this.editorsByLanguage.entrySet()) {
            mappings.put(editor.getKey(), editor.getValue().getMappings());
        }
        if (!node.getNodeTypes().contains("jmix:vanityUrlMapped")) {
            node.getNodeTypes().add("jmix:vanityUrlMapped");
        }
        node.set("vanityMappings", mappings);
    }
}

