/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.definition.FormFieldCreator;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.definition.LangPropertiesEditor;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;

public class TranslateContentEngine
extends Window {
    public static final int BUTTON_HEIGHT = 24;
    private GWTJahiaNode node;
    private final GWTJahiaLanguage srcLanguage;
    private final GWTJahiaLanguage destLanguage;
    private Linker linker = null;
    private Button ok;
    private CheckBox wipCheckbox;
    private LangPropertiesEditor sourceLangPropertiesEditor;
    private LangPropertiesEditor targetLangPropertiesEditor;
    protected ButtonBar buttonBar;
    private TranslateContentEngineSaveCallback translateContentEngineSaveCallback;
    private Set<String> workInProgressByLocale = new HashSet<String>();

    public TranslateContentEngine(GWTJahiaNode node, Linker linker, GWTJahiaLanguage srcLanguage, GWTJahiaLanguage destLanguage) {
        this.addStyleName("translate-content-engine");
        this.linker = linker;
        this.node = node;
        this.srcLanguage = srcLanguage;
        this.destLanguage = destLanguage;
        this.init();
    }

    protected void init() {
        this.setLayout((Layout)new FitLayout());
        this.setBodyBorder(false);
        int windowHeight = com.google.gwt.user.client.Window.getClientHeight() - 10;
        int windowWidth = com.google.gwt.user.client.Window.getClientWidth() - 10;
        this.setSize(windowWidth, windowHeight);
        this.setClosable(true);
        this.setResizable(true);
        this.setModal(true);
        this.setMaximizable(true);
        this.setHeadingHtml(Messages.get("label.translate", "Translate") + ": " + this.node.getName());
        LayoutContainer panel = new LayoutContainer();
        panel.setLayout((Layout)new BorderLayout());
        this.sourceLangPropertiesEditor = new LangPropertiesEditor(this.node, Arrays.asList("content"), false, this.srcLanguage, null, new LangPropertiesEditor.CallBack(){

            @Override
            public void execute() {
                if (TranslateContentEngine.this.targetLangPropertiesEditor != null && TranslateContentEngine.this.targetLangPropertiesEditor.isNeedRefresh()) {
                    TranslateContentEngine.this.targetLangPropertiesEditor.refresh();
                }
            }
        });
        this.targetLangPropertiesEditor = new LangPropertiesEditor(this.node, Arrays.asList("content"), true, this.destLanguage, this.sourceLangPropertiesEditor, new LangPropertiesEditor.CallBack(){

            @Override
            public void execute() {
                TranslateContentEngine.this.wipCheckbox.setValue(Boolean.valueOf(TranslateContentEngine.this.workInProgressByLocale.contains(TranslateContentEngine.this.targetLangPropertiesEditor.getDisplayedLocale().getLanguage())));
            }
        });
        if (this.node.getWorkInProgressStatus() != null && this.node.getWorkInProgressLanguages() != null) {
            this.workInProgressByLocale.addAll(this.node.getWorkInProgressLanguages());
        }
        Button copyButton = new Button(Messages.get("label.translate.copy", "Copy to other language"));
        copyButton.addStyleName("button-translatecopy");
        this.sourceLangPropertiesEditor.getTopBar().add((Widget)copyButton);
        copyButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                PropertiesEditor sourcePropertiesEditor = TranslateContentEngine.this.sourceLangPropertiesEditor.getPropertiesEditorByLang(TranslateContentEngine.this.sourceLangPropertiesEditor.getDisplayedLocale().getLanguage());
                List<GWTJahiaNodeProperty> props = sourcePropertiesEditor.getProperties();
                Map<String, PropertiesEditor.PropertyAdapterField> fieldsMap = TranslateContentEngine.this.targetLangPropertiesEditor.getPropertiesEditorByLang(TranslateContentEngine.this.targetLangPropertiesEditor.getDisplayedLocale().getLanguage()).getFieldsMap();
                for (GWTJahiaNodeProperty prop : props) {
                    if (!sourcePropertiesEditor.getGWTJahiaItemDefinition(prop).isInternationalized()) continue;
                    Field<?> f = fieldsMap.get(prop.getName()).getField();
                    FormFieldCreator.copyValue(prop, f);
                }
            }
        });
        panel.add((Widget)this.sourceLangPropertiesEditor, (LayoutData)new BorderLayoutData(Style.LayoutRegion.WEST, (float)(windowWidth / 2)));
        panel.add((Widget)this.targetLangPropertiesEditor, (LayoutData)new BorderLayoutData(Style.LayoutRegion.EAST, (float)(windowWidth / 2)));
        this.add((Component)panel);
        LayoutContainer buttonsPanel = new LayoutContainer();
        buttonsPanel.setBorders(false);
        this.buttonBar = new ButtonBar();
        this.buttonBar.setAlignment(Style.HorizontalAlignment.CENTER);
        this.initFooter();
        buttonsPanel.add((Widget)this.buttonBar);
        this.setBottomComponent((Component)buttonsPanel);
        this.setFooter(true);
        this.layout();
    }

    protected void initFooter() {
        this.wipCheckbox = new CheckBox();
        this.wipCheckbox.setBoxLabel(Messages.get("label.saveAsWIP", "Save as work in progress"));
        this.wipCheckbox.setToolTip(Messages.get("label.saveAsWIP.information", "If checked, this content will ne be part of publication process"));
        this.wipCheckbox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                TranslateContentEngine.this.setWorkInProgress(TranslateContentEngine.this.wipCheckbox.getValue());
            }
        });
        this.buttonBar.add((Component)this.wipCheckbox);
        this.ok = new Button(Messages.get("label.save"));
        this.ok.addStyleName("button-save");
        this.ok.setHeight(24);
        this.ok.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonOK());
        this.ok.addSelectionListener((SelectionListener)new SaveSelectionListener());
        this.buttonBar.add((Component)this.ok);
        Button cancel = new Button(Messages.get("label.cancel"));
        cancel.addStyleName("button-cancel");
        cancel.setHeight(24);
        cancel.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonCancel());
        cancel.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                TranslateContentEngine.this.hide();
            }
        });
        this.buttonBar.add((Component)cancel);
    }

    public void setWorkInProgress(boolean wip) {
        if (wip) {
            this.workInProgressByLocale.add(this.targetLangPropertiesEditor.getDisplayedLocale().getLanguage());
        } else {
            this.workInProgressByLocale.remove(this.targetLangPropertiesEditor.getDisplayedLocale().getLanguage());
        }
    }

    public void setTranslateContentEngineSaveCallback(TranslateContentEngineSaveCallback translateContentEngineSaveCallback) {
        this.translateContentEngineSaveCallback = translateContentEngineSaveCallback;
    }

    public void focus() {
    }

    private class SaveSelectionListener
    extends SelectionListener<ButtonEvent> {
        private SaveSelectionListener() {
        }

        public void componentSelected(ButtonEvent event) {
            ArrayList<GWTJahiaNodeProperty> sharedProperties = new ArrayList<GWTJahiaNodeProperty>();
            LinkedList<GWTJahiaNodePropertyValue> languages = new LinkedList<GWTJahiaNodePropertyValue>();
            boolean saveWip = false;
            List<String> currentLanguages = TranslateContentEngine.this.node.getWorkInProgressLanguages();
            if (currentLanguages == null) {
                currentLanguages = new ArrayList<String>();
            }
            for (String locale : TranslateContentEngine.this.workInProgressByLocale) {
                saveWip |= !currentLanguages.contains(locale);
                languages.add(new GWTJahiaNodePropertyValue(locale));
            }
            if (saveWip || languages.size() != currentLanguages.size()) {
                GWTJahiaNodeProperty wipLocaleProperty = new GWTJahiaNodeProperty();
                wipLocaleProperty.setName("j:workInProgressLanguages");
                wipLocaleProperty.setValues(languages);
                wipLocaleProperty.setMultiple(true);
                sharedProperties.add(wipLocaleProperty);
                String status = TranslateContentEngine.this.node.getWorkInProgressStatus();
                if (status == null) {
                    status = GWTJahiaNode.WipStatus.LANGUAGES.name();
                } else if (languages.size() == 0) {
                    status = GWTJahiaNode.WipStatus.DISABLED.name();
                }
                sharedProperties.add(new GWTJahiaNodeProperty("j:workInProgressStatus", status));
            }
            Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties = TranslateContentEngine.this.targetLangPropertiesEditor.getLangPropertiesMap();
            for (String language : TranslateContentEngine.this.targetLangPropertiesEditor.getLangPropertiesMap().keySet()) {
                if (changedI18NProperties.containsKey(language)) continue;
                changedI18NProperties.put(language, new ArrayList());
            }
            JahiaContentManagementService.App.getInstance().saveNode(TranslateContentEngine.this.node, null, changedI18NProperties, sharedProperties, null, new BaseAsyncCallback(){

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    String message = throwable.getMessage();
                    if (message.contains("Invalid link")) {
                        message = Messages.get("label.error.invalidlink", "Invalid link") + " : " + message.substring(message.indexOf(":") + 1);
                    }
                    com.google.gwt.user.client.Window.alert((String)(Messages.get("failure.properties.save", "Properties save failed") + "\n\n" + message));
                    Log.error((String)"failed", (Throwable)throwable);
                }

                public void onSuccess(Object o) {
                    Info.display((String)Messages.get("label.information", "Information"), (String)Messages.get("saved_prop", "Properties saved\n\n"));
                    TranslateContentEngine.this.hide();
                    if (TranslateContentEngine.this.linker != null) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("refreshMain", true);
                        TranslateContentEngine.this.linker.refresh(data);
                    }
                    if (TranslateContentEngine.this.translateContentEngineSaveCallback != null) {
                        TranslateContentEngine.this.translateContentEngineSaveCallback.onSave();
                    }
                }
            });
        }
    }

    public static interface TranslateContentEngineSaveCallback {
        public void onSave();
    }
}

