/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.Iterator;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;

public class WorkInProgressButton
extends HorizontalPanel {
    private AbstractContentEngine engine;
    private Button button = new Button();
    private Html title = new Html();

    public WorkInProgressButton(AbstractContentEngine engine) {
        this.engine = engine;
        this.title.addStyleName("button-label");
        this.add((Component)this.title);
        this.add((Component)this.button);
        this.addStyleName("button-label-group");
    }

    public void updateButtonTitle() {
        switch (this.engine.getWipStatus()) {
            case ALL_CONTENT: {
                this.title.setHtml(Messages.get("label.wip.engine.title", "Work in progress:"));
                this.button.setHtml(Messages.get("label.wip.engine.title.all", "All Content <span>(localized & non-localized)</span>"));
                this.button.removeStyleName("button-work-in-progress-off");
                this.button.addStyleName("button-work-in-progress-on");
                break;
            }
            case LANGUAGES: {
                this.title.setHtml(Messages.get("label.wip.engine.title", "Work in progress:"));
                this.button.removeStyleName("button-work-in-progress-off");
                this.button.addStyleName("button-work-in-progress-on");
                Iterator<String> languagesIt = this.engine.getWorkInProgressLanguagesSorted().iterator();
                if (this.engine.getWorkInProgressLanguagesSorted().size() == 1) {
                    Object[] language = new String[]{WorkInProgressButton.resolveLanguageDisplayName(languagesIt.next())};
                    this.button.setHtml(Messages.getWithArgs("label.wip.engine.title.one", "{0} <span>(excluding non-localized content)</span>", language));
                    break;
                }
                if (this.engine.getWorkInProgressLanguagesSorted().size() == 2) {
                    Object[] languages = new String[]{WorkInProgressButton.resolveLanguageDisplayName(languagesIt.next()), WorkInProgressButton.resolveLanguageDisplayName(languagesIt.next())};
                    this.button.setHtml(Messages.getWithArgs("label.wip.engine.title.two", "{0} and {1} <span>(excluding non-localized content)</span>", languages));
                    break;
                }
                if (this.engine.getWorkInProgressLanguagesSorted().size() <= 2) break;
                Object[] params = new String[]{WorkInProgressButton.resolveLanguageDisplayName(languagesIt.next()), Integer.valueOf(this.engine.getWorkInProgressLanguagesSorted().size() - 1).toString()};
                this.button.setHtml(Messages.getWithArgs("label.wip.engine.title.more", "{0} and {1} more languages <span>(excluding non-localized content)</span>", params));
                break;
            }
            default: {
                this.title.setHtml("");
                this.button.removeStyleName("button-work-in-progress-on");
                this.button.addStyleName("button-work-in-progress-off");
                this.button.setHtml(Messages.get("label.wip.button.title", "Mark as work in progress"));
            }
        }
    }

    public void addSelectionListener(SelectionListener<ButtonEvent> listener) {
        this.button.addSelectionListener(listener);
    }

    private static String resolveLanguageDisplayName(String lang) {
        for (GWTJahiaLanguage language : JahiaGWTParameters.getSiteLanguages()) {
            if (!lang.equals(language.getLanguage())) continue;
            return language.getDisplayName();
        }
        return lang;
    }
}

