/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.event.WindowListener;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.ButtonItem;
import org.jahia.ajax.gwt.client.widget.contentengine.CreateContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EditContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.WorkInProgressButton;

public class WorkInProgressButtonItem
implements ButtonItem {
    private static final long serialVersionUID = -648440265273432614L;
    private boolean checkedByDefault = false;
    private transient WorkInProgressButton wipButton;
    private String academyUrl;

    @Override
    public BoxComponent create(final AbstractContentEngine engine) {
        if (engine instanceof CreateContentEngine && this.checkedByDefault) {
            if (JahiaGWTParameters.getSiteLanguages().size() == 1) {
                engine.setWipStatus(GWTJahiaNode.WipStatus.LANGUAGES);
                HashSet<String> langs = new HashSet<String>();
                langs.add(JahiaGWTParameters.getSiteLanguages().get(0).getLanguage());
                engine.setWorkInProgressLanguages(langs);
            } else {
                engine.setWipStatus(GWTJahiaNode.WipStatus.ALL_CONTENT);
            }
        }
        if (engine instanceof EditContentEngine) {
            ((EditContentEngine)engine).setWorkInProgressCheckedByDefault(this.checkedByDefault);
        }
        if (JahiaGWTParameters.getSiteLanguages().size() > 1) {
            this.wipButton = new WorkInProgressButton(engine);
            final WorkInProgressWindow window = new WorkInProgressWindow(engine);
            this.wipButton.addSelectionListener(new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    window.show();
                }
            });
            return this.wipButton;
        }
        final CheckBoxWip checkbox = new CheckBoxWip();
        checkbox.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent event) {
                HashSet<String> langs = new HashSet<String>();
                if (checkbox.getValue().booleanValue()) {
                    engine.setWipStatus(GWTJahiaNode.WipStatus.LANGUAGES);
                    langs.add(engine.getSelectedLanguage());
                } else {
                    engine.setWipStatus(GWTJahiaNode.WipStatus.DISABLED);
                }
                engine.setWorkInProgressLanguages(langs);
                engine.updateWipStyle();
            }
        });
        checkbox.setBoxLabel(Messages.get("label.saveAsWIP", "Save as work in progress"));
        checkbox.setToolTip(Messages.get("label.saveAsWIP.information", "If checked, this content will ne be part of publication process"));
        return checkbox;
    }

    public void setCheckedByDefault(boolean checkedByDefault) {
        this.checkedByDefault = checkedByDefault;
    }

    public void setAcademyUrl(String academyUrl) {
        this.academyUrl = academyUrl;
    }

    private class WorkInProgressWindow
    extends Window {
        private final Radio turnOff = new Radio();
        private final Radio allContents = new Radio();
        private final Radio selectedLanguages = new Radio();
        private final CheckBoxGroup languages = new CheckBoxGroup();
        private final Html errorLanguages = new Html();
        private final Html helpPanel = new Html();

        public WorkInProgressWindow(final AbstractContentEngine engine) {
            VerticalPanel vp = new VerticalPanel();
            vp.setSpacing(10);
            final VerticalPanel vpLanguages = new VerticalPanel();
            LayoutContainer langContainer = new LayoutContainer();
            this.setSize(500, 300);
            this.setPlain(true);
            this.setModal(true);
            this.setBlinkModal(true);
            this.setHeadingText(Messages.get("label.wip.title", "Work in progress"));
            this.addStyleName("wip-window");
            this.addWindowListener(new WindowListener(){

                public void windowShow(WindowEvent we) {
                    super.windowShow(we);
                    switch (engine.getWipStatus()) {
                        case DISABLED: {
                            WorkInProgressWindow.this.turnOff.setValue(Boolean.valueOf(true));
                            WorkInProgressWindow.this.turnOff.fireEvent(Events.OnClick);
                            break;
                        }
                        case LANGUAGES: {
                            WorkInProgressWindow.this.selectedLanguages.setValue(Boolean.valueOf(true));
                            WorkInProgressWindow.this.selectedLanguages.fireEvent(Events.OnClick);
                            break;
                        }
                        case ALL_CONTENT: {
                            WorkInProgressWindow.this.allContents.setValue(Boolean.valueOf(true));
                            WorkInProgressWindow.this.allContents.fireEvent(Events.OnClick);
                            break;
                        }
                        default: {
                            if (WorkInProgressButtonItem.this.checkedByDefault) {
                                WorkInProgressWindow.this.allContents.setValue(Boolean.valueOf(true));
                                WorkInProgressWindow.this.allContents.fireEvent(Events.OnClick);
                                break;
                            }
                            WorkInProgressWindow.this.turnOff.setValue(Boolean.valueOf(true));
                            WorkInProgressWindow.this.turnOff.fireEvent(Events.OnClick);
                        }
                    }
                    Set<String> wipLanguages = engine.getWorkInProgressLanguagesSorted();
                    for (Field field : WorkInProgressWindow.this.languages.getAll()) {
                        CheckBox language = (CheckBox)field;
                        language.setValue(Boolean.valueOf(wipLanguages.contains(language.getValueAttribute())));
                    }
                }
            });
            vpLanguages.addListener(Events.OnChange, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    WorkInProgressWindow.this.errorLanguages.hide();
                    vpLanguages.removeStyleName("error-languages");
                }
            });
            Html title = new Html(Messages.get("label.wip.title.sub", "Select what you would like to mark as Work in Progress"));
            title.addStyleName("wip-panel-subtitle");
            vp.add((Widget)title);
            this.allContents.addListener(Events.OnClick, this.getOnChangeListener(false, Messages.getWithArgs("label.wip.allcontent.helper", "All Content helper text. <a target=\"_blank\" href=\"{0}\">Find out more at The Academy</a>", new String[]{WorkInProgressButtonItem.this.academyUrl})));
            String titleText = Messages.get("label.wip.allcontent", "All Content ( localised & non-localised )");
            this.allContents.setBoxLabel(titleText);
            this.allContents.setTitle(titleText);
            this.allContents.addStyleName("wip-radio-all-content");
            vp.add((Widget)this.allContents);
            this.selectedLanguages.setBoxLabel(Messages.get("label.wip.localisedcontent", "Localised Content only"));
            this.selectedLanguages.addListener(Events.OnClick, this.getOnChangeListener(true, Messages.getWithArgs("label.wip.localisedcontent.helper", "Localised Content helper text. <a target=\"_blank\" href=\"{0}\">Find out more at The Academy</a>", new String[]{WorkInProgressButtonItem.this.academyUrl})));
            vpLanguages.add((Widget)this.selectedLanguages);
            this.languages.setFieldLabel("Languages");
            this.languages.setOrientation(Style.Orientation.VERTICAL);
            for (GWTJahiaLanguage language : JahiaGWTParameters.getSiteLanguages()) {
                CheckBox languageCheck = new CheckBox();
                languageCheck.setBoxLabel(language.getDisplayName());
                languageCheck.setValueAttribute(language.getLanguage());
                this.languages.add((Field)languageCheck);
            }
            this.languages.addStyleName("wip-language-list");
            langContainer.add((Widget)this.languages);
            langContainer.setScrollMode(Style.Scroll.AUTO);
            langContainer.setHeight(100);
            vpLanguages.add((Widget)langContainer);
            this.errorLanguages.addStyleName("error-message");
            this.errorLanguages.setHtml(Messages.get("label.wip.localisedcontent.error", "At least one language must be selected"));
            this.errorLanguages.hide();
            vpLanguages.add((Widget)this.errorLanguages);
            vp.add((Widget)vpLanguages);
            vpLanguages.addStyleName("wip-radio-localised");
            this.turnOff.setBoxLabel(Messages.get("label.wip.turnoff", "Turn off Work in Progress"));
            this.turnOff.addListener(Events.OnClick, this.getOnChangeListener(false, Messages.getWithArgs("label.wip.turnoff.helper", "Turn off helper text. <a target=\"_blank\" href=\"{0}\">Find out more at The Academy</a>", new String[]{WorkInProgressButtonItem.this.academyUrl})));
            this.turnOff.addStyleName("wip-radio-off");
            vp.add((Widget)this.turnOff);
            this.add((Component)vp);
            Button cancel = new Button(Messages.get("label.cancel", "Cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    WorkInProgressWindow.this.hide();
                }
            });
            cancel.addStyleName("button-cancel");
            this.addButton(cancel);
            Button save = new Button(Messages.get("label.save", "Save"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    if (WorkInProgressWindow.this.selectedLanguages.getValue().booleanValue() && WorkInProgressWindow.this.languages.getValues().size() < 1) {
                        WorkInProgressWindow.this.languages.markInvalid(Messages.get("label.wip.localisedcontent.error", "At least one language must be selected"));
                        vpLanguages.addStyleName("error-languages");
                        WorkInProgressWindow.this.errorLanguages.show();
                        return;
                    }
                    if (WorkInProgressWindow.this.allContents.getValue().booleanValue()) {
                        engine.setWipStatus(GWTJahiaNode.WipStatus.ALL_CONTENT);
                    } else if (WorkInProgressWindow.this.selectedLanguages.getValue().booleanValue()) {
                        engine.setWipStatus(GWTJahiaNode.WipStatus.LANGUAGES);
                    } else if (WorkInProgressWindow.this.turnOff.getValue().booleanValue()) {
                        engine.setWipStatus(GWTJahiaNode.WipStatus.DISABLED);
                    } else {
                        throw new IllegalArgumentException("unable to set WIP status");
                    }
                    HashSet<String> langs = new HashSet<String>();
                    for (CheckBox language : WorkInProgressWindow.this.languages.getValues()) {
                        if (!language.getValue().booleanValue()) continue;
                        langs.add(language.getValueAttribute());
                    }
                    engine.setWorkInProgressLanguages(langs);
                    engine.updateWipStyle();
                    WorkInProgressButtonItem.this.wipButton.updateButtonTitle();
                    WorkInProgressWindow.this.hide();
                }
            });
            save.addStyleName("button-save");
            this.addButton(save);
            this.setFocusWidget((Widget)this.getButtonBar().getItem(0));
            WorkInProgressButtonItem.this.wipButton.updateButtonTitle();
            this.helpPanel.addStyleName("help-message");
            this.add((Component)this.helpPanel);
        }

        private Listener<BaseEvent> getOnChangeListener(final Boolean enableLanguage, final String help) {
            return new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    if (enableLanguage.booleanValue()) {
                        WorkInProgressWindow.this.languages.enable();
                    } else {
                        WorkInProgressWindow.this.languages.disable();
                    }
                    WorkInProgressWindow.this.helpPanel.setHtml(help);
                }
            };
        }
    }

    public class CheckBoxWip
    extends CheckBox {
    }
}

